/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.migration.db60to60;

import com.dassault.cecilia.migration.db60to60.DBCopySequences;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBCopyOracle
extends DBCopySequences {
    private void SuspendConstraints(Connection DBcible) throws SQLException {
        Statement statement = DBcible.createStatement();
        statement.executeUpdate("set log 0;");
        statement.executeUpdate("set referential_integrity false;");
        statement.close();
    }

    private void EnableConstraints(Connection DBcible) throws SQLException {
        Statement statement = DBcible.createStatement();
        statement.executeUpdate("set referential_integrity true;");
        statement.close();
    }

    @Override
    protected String getDeleteSQLCmd() {
        return "DELETE FROM";
    }

    @Override
    protected void dropTableIfExist(Statement statement, String tableName) throws SQLException {
        block2: {
            boolean update = false;
            try {
                ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM " + tableName);
                resultSet.close();
                update = true;
                statement.executeUpdate("DROP TABLE " + tableName);
            }
            catch (SQLException e) {
                if (!update) break block2;
                _LOG.severe("Exception during DROP TABLE '" + tableName + "'");
                throw e;
            }
        }
    }

    @Override
    protected void updateSequence(Connection DBTarget, String sequence, String table, String field) throws SQLException {
        int maxValue = this.getMaxValue(DBTarget, "SELECT MAX(" + field + ") FROM " + table);
        this.updateSequence(DBTarget, sequence, maxValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSequence(Connection DBTarget, String sequence, int maxValue) throws SQLException {
        try (Statement statement = DBTarget.createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT " + sequence + ".nextval FROM dual");
            resultSet.next();
            int nextValue = resultSet.getInt(1);
            if (maxValue < nextValue) {
                statement.executeUpdate("ALTER SEQUENCE " + sequence + " INCREMENT BY -" + (nextValue - maxValue) + " MINVALUE 0");
                statement.executeQuery("SELECT " + sequence + ".nextval FROM dual");
                statement.executeUpdate("ALTER SEQUENCE " + sequence + " INCREMENT BY 1");
            } else if (maxValue > nextValue) {
                statement.executeUpdate("ALTER SEQUENCE " + sequence + " INCREMENT BY " + (maxValue - nextValue));
                statement.executeQuery("SELECT " + sequence + ".nextval FROM dual");
                statement.executeUpdate("ALTER SEQUENCE " + sequence + " INCREMENT BY 1");
            }
        }
    }
}

