/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.dbgui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dbgui.LicenseMenuUtility;
import com.dassault.cecilia.core.plugin.Plug;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.SQLConnectionList;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class DBBaseEditDlg
extends JDialogCecilia {
    static Logger LOG = Logger.getLogger(DBBaseEditDlg.class.getPackage().getName());
    public static final String NAME_OF_H2_BASE = "Base.mv.db";
    protected SQLConnectionList.Item _previousConnection;
    protected SQLConnectionList.Item _currentConnection;
    protected String _previousName;
    protected String _currentName;
    protected Collection<String> _collectDBName;
    protected JTextField _ctrlDBName;
    protected JComboBox _ctrlDBChoose;
    protected JPanel _panelParam;
    protected CardLayout _layoutParam;
    protected JTextField _ctrlODBCDataSource;
    protected DbPanelWithFile _ctrlAccess;
    protected DbPanelWithFile _ctrlSqlite;
    protected DbPanelWithFile _ctrlH2;
    protected JRadioButton _ctrlMainConnectDirect;
    protected JLabel _lblMainConnect;
    protected JTextArea _ctrlMainConnect;
    protected JRadioButton _ctrlMainConnectDefine;
    protected JLabel _lblMainHost;
    protected JTextField _ctrlMainHost;
    protected JLabel _lblMainPort;
    protected JTextField _ctrlMainPort;
    protected JLabel _lblMainBase;
    protected JTextField _ctrlMainBase;
    protected JTextField _ctrlMainUser;
    protected JPasswordField _ctrlMainPasswd;
    protected JButton _ctrlUtility;
    protected LicenseMenuUtility _utilLicense;
    String _oldType = null;
    private static Pattern PATTERN_SPACES = Pattern.compile("\\s");

    public DBBaseEditDlg(Plug module) {
        this.make();
    }

    public DBBaseEditDlg(Window owner) {
        super(owner);
        this.make();
    }

    public Component getComponentOwner() {
        return this;
    }

    private void make() {
        this.init();
        this._utilLicense = new LicenseMenuUtility(new LicenseMenuUtility.LicenseHelper(){

            @Override
            public boolean verifyConnection(SQLConnection connect) {
                return false;
            }

            @Override
            public SQLConnection getSQLConnection() {
                return null;
            }

            @Override
            public String getTitle() {
                return DBBaseEditDlg.this.getTitle();
            }

            @Override
            public Plug getModule() {
                return null;
            }

            @Override
            public Component getComponentOwner() {
                return DBBaseEditDlg.this._ctrlUtility;
            }
        });
        JPanel root = new JPanel(new BorderLayout());
        root.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(root);
        JPanel north = new JPanel(new GridBagLayout());
        north.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        north.add((Component)new JLabel(ResMsgCore.getString("DLG_DBCHANGE_NAMEDB")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this._ctrlDBName = new JTextField(20);
        north.add((Component)this._ctrlDBName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)new JLabel(ResMsgCore.getString("DLG_DBCHANGE_CHOOSEDB")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        Vector<SQLConnection.DBType> dbChoose = new Vector<SQLConnection.DBType>(5);
        if (this.verifyJDBCDriver(SQLConnection.DBType.H2.getDriver())) {
            dbChoose.add(SQLConnection.DBType.H2);
        }
        if (ConfigManager.getVersion() != ConfigManager.TypeVersion.DEMO) {
            if (this.verifyJDBCDriver(SQLConnection.DBType.Oracle.getDriver())) {
                dbChoose.add(SQLConnection.DBType.Oracle);
            }
            if (this.verifyJDBCDriver(SQLConnection.DBType.Postgres.getDriver())) {
                dbChoose.add(SQLConnection.DBType.Postgres);
            }
            if (this.verifyJDBCDriver(SQLConnection.DBType.MySQL.getDriver())) {
                dbChoose.add(SQLConnection.DBType.MySQL);
            }
        }
        this._ctrlDBChoose = new JComboBox(dbChoose);
        this._ctrlDBChoose.setEditable(false);
        this._ctrlDBChoose.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DBBaseEditDlg.this.switchDBChoose();
            }
        });
        if (this._ctrlDBChoose.getItemCount() == 0) {
            LOG.severe("No compatible database drivers installed");
        }
        north.add((Component)this._ctrlDBChoose, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        root.add((Component)north, "North");
        this._layoutParam = new CardLayout();
        this._panelParam = new JPanel(this._layoutParam);
        this._panelParam.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ResMsgCore.getString("DLG_DBCHANGE_CONNECTPARAM")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this._ctrlH2 = new DbH2Panel();
        this._panelParam.add((Component)this._ctrlH2, "h2");
        JPanel param = new JPanel(new GridBagLayout());
        ButtonGroup groupOptConnect = new ButtonGroup();
        this._ctrlMainConnectDirect = new JRadioButton(ResMsgCore.getString("DLG_DBCHANGE_DBDIRECT"));
        groupOptConnect.add(this._ctrlMainConnectDirect);
        JPanel direct = new JPanel(new ToggleBorderLayout());
        this._ctrlMainConnect = new JTextArea(3, 25);
        this._ctrlMainConnect.setLineWrap(true);
        ToggleBorderLayout.configure(direct, this._ctrlMainConnectDirect, new JScrollPane(this._ctrlMainConnect));
        this._ctrlMainConnectDirect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBBaseEditDlg.this.changeOptionConnect();
            }
        });
        param.add((Component)direct, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        this._ctrlMainConnectDefine = new JRadioButton(ResMsgCore.getString("DLG_DBCHANGE_DBDEFINE"));
        groupOptConnect.add(this._ctrlMainConnectDefine);
        JPanel define = new JPanel(new ToggleBorderLayout());
        JPanel intern = new JPanel(new GridBagLayout());
        this._lblMainHost = new JLabel(ResMsgCore.getString("DLG_DBCHANGE_DBHOST"));
        intern.add((Component)this._lblMainHost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this._ctrlMainHost = new JTextField(10);
        intern.add((Component)this._ctrlMainHost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 5, 0), 0, 0));
        this._lblMainPort = new JLabel(ResMsgCore.getString("DLG_DBCHANGE_DBPORT"));
        intern.add((Component)this._lblMainPort, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this._ctrlMainPort = new JTextField(10);
        intern.add((Component)this._ctrlMainPort, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 5, 0), 0, 0));
        this._lblMainBase = new JLabel(ResMsgCore.getString("DLG_DBCHANGE_DBBASE"));
        intern.add((Component)this._lblMainBase, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this._ctrlMainBase = new JTextField(10);
        intern.add((Component)this._ctrlMainBase, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 5, 0), 0, 0));
        ToggleBorderLayout.configure(define, this._ctrlMainConnectDefine, intern);
        this._ctrlMainConnectDefine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBBaseEditDlg.this.changeOptionConnect();
            }
        });
        this._ctrlMainConnectDefine.setSelected(true);
        param.add((Component)define, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        param.add((Component)new JLabel(ResMsgCore.getString("DLG_DBCHANGE_DBUSER")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this._ctrlMainUser = new JTextField(10);
        param.add((Component)this._ctrlMainUser, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 5, 0), 0, 0));
        param.add((Component)new JLabel(ResMsgCore.getString("DLG_DBCHANGE_DBPASSWD")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this._ctrlMainPasswd = new JPasswordField(10);
        param.add((Component)this._ctrlMainPasswd, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 5, 0), 0, 0));
        this._panelParam.add((Component)param, "server");
        root.add((Component)this._panelParam, "Center");
        JPanel south = new JPanel(new BorderLayout());
        JPanel center = new JPanel();
        JPanel valid = new JPanel(new GridLayout(1, 2, 5, 5));
        AbstractAction actOK = new AbstractAction(ResMsgVoc.getString("VOC_VALIDATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBBaseEditDlg.this.validateAction();
            }
        };
        JButton butOK = new JButton(actOK);
        valid.add(butOK);
        this.putAction("CECILIA_ENTER", actOK);
        AbstractAction actCancel = new AbstractAction(ResMsgVoc.getString("VOC_CANCEL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBBaseEditDlg.this.setVisible(false);
            }
        };
        JButton butCancel = new JButton(actCancel);
        valid.add(butCancel);
        this.putAction("CECILIA_CANCEL", actCancel);
        center.add(valid);
        south.add((Component)center, "Center");
        JPanel east = new JPanel();
        this._ctrlUtility = new JButton(ResIcoCore.getImageIcon("MENU_DOWN"));
        this._ctrlUtility.setToolTipText(ResMsgCore.getString("DLG_DBCHANGE_UTILTYMENU"));
        this._ctrlUtility.setPreferredSize(new Dimension(25, 25));
        this._ctrlUtility.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle butRect = DBBaseEditDlg.this._ctrlUtility.getBounds();
                JPopupMenu menu = DBBaseEditDlg.this._utilLicense.getMenu();
                Dimension menSize = menu.getPreferredSize();
                menu.show(DBBaseEditDlg.this._ctrlUtility, butRect.width - menSize.width, -menSize.height);
            }
        });
        east.add(this._ctrlUtility);
        this._ctrlUtility.setVisible(false);
        south.add((Component)east, "East");
        root.add((Component)south, "South");
        this.pack();
        this.setModal(true);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this.getComponentOwner()));
        this.setTitle(ResMsgCore.getString("DLG_DBCHANGE_TITLE"));
        this.switchDBChoose();
    }

    private void changeOptionConnect() {
        boolean direct = this._ctrlMainConnectDirect.isSelected();
        this._ctrlMainConnect.setEnabled(direct);
        boolean define = this._ctrlMainConnectDefine.isSelected();
        this._lblMainHost.setEnabled(define);
        this._ctrlMainHost.setEnabled(define);
        this._lblMainPort.setEnabled(define);
        this._ctrlMainPort.setEnabled(define);
        this._lblMainBase.setEnabled(define);
        this._ctrlMainBase.setEnabled(define);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDatabaseToFile(File f, String resource) throws IOException {
        InputStream is = DBBaseEditDlg.class.getResourceAsStream(resource);
        if (is == null) {
            throw new IOException("No access to internal database");
        }
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(f));
            in = new BufferedInputStream(is);
            byte[] read = new byte[128];
            int len = 128;
            while ((len = in.read(read)) > 0) {
                ((BufferedOutputStream)out).write(read, 0, len);
            }
            ((BufferedOutputStream)out).flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void switchDBChoose() {
        SQLConnection.DBType type = (SQLConnection.DBType)((Object)this._ctrlDBChoose.getSelectedItem());
        if (type == null) {
            return;
        }
        this._layoutParam.show(this._panelParam, type.getKey());
        if (this._previousName == null) {
            String oldName = this._ctrlDBName.getText();
            if (oldName.length() == 0) {
                this._ctrlDBName.setText(type.toString());
            } else if (oldName.startsWith(this._oldType)) {
                if (this._oldType.length() == oldName.length()) {
                    this._ctrlDBName.setText(type.toString());
                } else {
                    StringBuffer sb = new StringBuffer(128);
                    sb.append(type.toString());
                    sb.append(oldName.substring(this._oldType.length()));
                    this._ctrlDBName.setText(sb.toString());
                }
            }
        }
        this._oldType = type.toString();
    }

    private void initConnection(SQLConnectionList.Item previousItem) {
        this._previousConnection = previousItem;
        if (previousItem == null) {
            return;
        }
        SQLConnection previousConnect = previousItem.getSQLConnection();
        this._ctrlDBChoose.setSelectedItem((Object)previousConnect.getType());
        switch (previousConnect.getType()) {
            case H2: {
                String path = previousConnect.getData("db.h2.file");
                if (path == null) break;
                this._ctrlH2._ctrlExistFile.setText(path);
                break;
            }
            default: {
                String pass;
                String user;
                String name;
                String port;
                String host;
                String direct = previousConnect.getData("db.connect.direct");
                if (direct != null && direct.equalsIgnoreCase("true")) {
                    this._ctrlMainConnectDirect.setSelected(true);
                } else {
                    this._ctrlMainConnectDefine.setSelected(true);
                }
                this.changeOptionConnect();
                String connect = previousConnect.getData("db.connect");
                if (connect != null) {
                    this._ctrlMainConnect.setText(connect);
                }
                if ((host = previousConnect.getData("db.srv.host")) != null) {
                    this._ctrlMainHost.setText(host);
                }
                if ((port = previousConnect.getData("db.srv.port")) != null) {
                    this._ctrlMainPort.setText(port);
                }
                if ((name = previousConnect.getData("db.srv.name")) != null) {
                    this._ctrlMainBase.setText(name);
                }
                if ((user = previousConnect.getData("db.srv.user")) != null) {
                    this._ctrlMainUser.setText(user);
                }
                if ((pass = previousConnect.getData("db.srv.password")) == null) break;
                this._ctrlMainPasswd.setText(pass);
            }
        }
    }

    private SQLConnection verifyDBParameters() {
        SQLConnection.DBType type = (SQLConnection.DBType)((Object)this._ctrlDBChoose.getSelectedItem());
        switch (type) {
            case H2: {
                String path = this._ctrlH2._ctrlExistFile.getText();
                if (!FileUtility.verifyPath((String)path, (boolean)false, (Component)this._ctrlH2._ctrlExistFile, (String)this.getTitle())) {
                    return null;
                }
                File file = new File(path);
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("db.h2.file", file.getAbsolutePath());
                return new SQLConnection(SQLConnection.DBType.H2, props);
            }
            case ODBC: {
                String name = this.verifyTextFieldEmpty(this._ctrlODBCDataSource, ResMsgCore.getString("DLG_DBCHANGE_ERR_ODBCDATA"));
                if (name.length() == 0) {
                    return null;
                }
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("db.odbc.data", name);
                return new SQLConnection(SQLConnection.DBType.ODBC, props);
            }
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (this._ctrlMainConnectDefine.isSelected()) {
            props.put("db.connect.direct", "false");
            String host = this.verifyTextFieldWithoutSpace(this._ctrlMainHost, ResMsgCore.getString("DLG_DBCHANGE_ERR_DBHOST"));
            if (host.length() == 0) {
                return null;
            }
            props.put("db.srv.host", host);
            String port = this.verifyTextFieldWithoutSpace(this._ctrlMainPort, ResMsgCore.getString("DLG_DBCHANGE_ERR_DBPORT"));
            if (port.length() == 0) {
                return null;
            }
            props.put("db.srv.port", port);
            String base = this.verifyTextFieldWithoutSpace(this._ctrlMainBase, ResMsgCore.getString("DLG_DBCHANGE_ERR_DBBASE"));
            if (base.length() == 0) {
                return null;
            }
            props.put("db.srv.name", base);
        } else {
            props.put("db.connect.direct", "true");
            String connect = this.verifyTextFieldWithoutSpace(this._ctrlMainConnect, ResMsgCore.getString("DLG_DBCHANGE_ERR_CONNECT"));
            if (connect.length() == 0) {
                return null;
            }
            props.put("db.connect", connect);
        }
        props.put("db.srv.user", this.verifyTextFieldEmpty(this._ctrlMainUser, ResMsgCore.getString("DLG_DBCHANGE_ERR_DBUSER")));
        props.put("db.srv.password", this.verifyTextFieldEmpty(this._ctrlMainPasswd, ResMsgCore.getString("DLG_DBCHANGE_ERR_DBPASSWD")));
        switch (type) {
            case Oracle: {
                return new SQLConnection(SQLConnection.DBType.Oracle, props);
            }
            case Postgres: {
                return new SQLConnection(SQLConnection.DBType.Postgres, props);
            }
            case MySQL: {
                return new SQLConnection(SQLConnection.DBType.MySQL, props);
            }
        }
        return null;
    }

    private String verifyTextFieldEmpty(JTextComponent owner, String msg) {
        String name = owner.getText().trim();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), msg, this.getTitle(), 0);
            owner.requestFocus();
            return "";
        }
        return name;
    }

    private String verifyTextFieldWithoutSpace(JTextComponent owner, String msg) {
        String name = owner.getText().trim();
        if (name.length() == 0 || PATTERN_SPACES.matcher(name).find()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), msg, this.getTitle(), 0);
            owner.requestFocus();
            return "";
        }
        return name;
    }

    private boolean verifyJDBCDriver(String driver) {
        try {
            Class.forName(driver);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Exception during load JDBC driver: " + driver);
            return false;
        }
    }

    private void validateAction() {
        String currentName = this._ctrlDBName.getText().trim();
        if (currentName.length() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.getString("DLG_DBCHANGE_ERR_DBNAME"), this.getTitle(), 0);
            this._ctrlDBName.requestFocus();
            return;
        }
        if ((this._previousName == null || !this._previousName.equals(currentName)) && this._collectDBName.contains(currentName)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.getString("DLG_DBCHANGE_ERR_DBNAME"), this.getTitle(), 0);
            this._ctrlDBName.requestFocus();
            return;
        }
        this._currentName = currentName;
        SQLConnection currentConnect = this.verifyDBParameters();
        if (currentConnect == null) {
            return;
        }
        this._currentConnection = new SQLConnectionList.Item(currentConnect, this._currentName);
        currentConnect.setName(this._currentName);
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            LOG.warning("Use display method !!!");
            assert (false) : "Use display method !!!";
        } else {
            super.setVisible(false);
        }
    }

    public final SQLConnectionList.Item display(SQLConnectionList.Item previous, Collection<String> dbNames) {
        if (this._ctrlDBChoose.getItemCount() == 0) {
            LOG.fine("No compatible database drivers installed");
            return null;
        }
        this._currentConnection = null;
        this.initConnection(previous);
        if (previous != null) {
            this._previousName = previous.getName();
            this._ctrlDBName.setText(this._previousName);
        }
        this._collectDBName = dbNames;
        super.setVisible(true);
        return this._currentConnection;
    }

    class DbH2Panel
    extends DbPanelWithFile {
        DbH2Panel() {
        }

        @Override
        public String getFilterDesc() {
            return ResMsgCore.getString("FILE_TYPE_H2");
        }

        @Override
        public String getFilterExt() {
            return ".mv.db";
        }

        @Override
        public String getLabel() {
            return ResMsgCore.getString("DLG_DBCHANGE_H2");
        }

        @Override
        public String getKeyBinNewDB() {
            return DBBaseEditDlg.NAME_OF_H2_BASE;
        }
    }

    abstract class DbPanelWithFile
    extends JPanel {
        protected JTextField _ctrlExistFile;
        protected JButton _ctrlExistLook;
        protected JFileChooser _ctrlChooseFile;

        public abstract String getFilterDesc();

        public abstract String getFilterExt();

        public abstract String getLabel();

        public abstract String getKeyBinNewDB();

        private JFileChooser getSQLIteFileChooser(String pathname) {
            File file;
            File dir;
            if (this._ctrlChooseFile == null) {
                File pdir;
                this._ctrlChooseFile = new JFileChooser();
                FileFilterExtention defaultFilter = new FileFilterExtention(this.getFilterDesc(), this.getFilterExt());
                this._ctrlChooseFile.addChoosableFileFilter(defaultFilter);
                this._ctrlChooseFile.setFileFilter(defaultFilter);
                dir = new File(".");
                String property = System.getProperty("cecilia.core.LicensePath");
                if (property != null && !(pdir = new File(property)).isDirectory()) {
                    dir = pdir;
                }
                this._ctrlChooseFile.setCurrentDirectory(dir);
            }
            if (pathname != null && pathname.length() > 0 && (dir = (file = new File(pathname)).getParentFile()).isDirectory()) {
                this._ctrlChooseFile.setCurrentDirectory(dir);
                this._ctrlChooseFile.setSelectedFile(file);
            }
            return this._ctrlChooseFile;
        }

        public DbPanelWithFile() {
            super(new GridBagLayout());
            this.add((Component)new JLabel(this.getLabel()), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 15), 0, 0));
            this._ctrlExistFile = new JTextField(30);
            this.add((Component)this._ctrlExistFile, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this._ctrlExistLook = new JButton("...");
            this._ctrlExistLook.setPreferredSize(new Dimension(25, 25));
            this.add((Component)this._ctrlExistLook, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this._ctrlExistLook.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = DbPanelWithFile.this.getSQLIteFileChooser(DbPanelWithFile.this._ctrlExistFile.getText());
                    if (fc.showOpenDialog(DbPanelWithFile.this._ctrlExistFile) == 0) {
                        File f = fc.getSelectedFile();
                        DbPanelWithFile.this._ctrlExistFile.setText(f.getPath());
                    }
                }
            });
            AbstractAction action = new AbstractAction(ResMsgCore.getString("DLG_DBCHANGE_FILENEW")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = DbPanelWithFile.this.getSQLIteFileChooser(DbPanelWithFile.this._ctrlExistFile.getText());
                    if (fc.showSaveDialog(DbPanelWithFile.this._ctrlExistFile) != 0) {
                        return;
                    }
                    File f = FileFilterExtention.addDefaultExtention(fc);
                    String path = f.getAbsolutePath();
                    if (!FileUtility.verifyPath((String)path, (boolean)true, (Component)DbPanelWithFile.this._ctrlExistFile, (String)DBBaseEditDlg.this.getTitle())) {
                        return;
                    }
                    try {
                        DBBaseEditDlg.copyDatabaseToFile(f, DbPanelWithFile.this.getKeyBinNewDB());
                        DbPanelWithFile.this._ctrlExistFile.setText(path);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(DbPanelWithFile.this), ex.getMessage(), DBBaseEditDlg.this.getTitle(), 0);
                        LOG.log(Level.INFO, "Exception during create database file: " + f, ex);
                    }
                }
            };
            JButton accessCreate = new JButton(action);
            this.add((Component)accessCreate, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        }
    }
}

