/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.dbgui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dbgui.DBBaseEditDlg;
import com.dassault.cecilia.core.cecilia.dbgui.LicenseException;
import com.dassault.cecilia.core.cecilia.dbgui.LicenseManager;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.SQLConnectionList;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class DBBaseSelectUtility {
    static Logger LOG = Logger.getLogger(DBBaseSelectUtility.class.getPackage().getName());
    SQLConnectionList _list;
    boolean _mustSaveList;
    boolean _batchApp;
    boolean _defaultDBAlreadySelected = false;

    public DBBaseSelectUtility(SQLConnectionList list, boolean batchApp) {
        this._list = list;
        this._batchApp = batchApp;
    }

    public SQLConnection selectConnection() {
        String systemDefaultDB;
        SQLConnectionList.Item select = null;
        SQLConnectionList.Item first = this._list.getFirstSQLConnection();
        if (select == null) {
            select = this._list.getDefaultSQLConnection();
        }
        if (select == null) {
            select = first;
        }
        boolean isBatchApp = this._batchApp;
        if (!this._defaultDBAlreadySelected && (systemDefaultDB = System.getProperty("cecilia.db.DefaultDB")) != null) {
            select = this._list.getSQLConnection(systemDefaultDB);
            if (select == null) {
                String msg = ResMsgCore.msgFormat("DLG_DBSELECT_ERR_SYSTEMDEFAULT", systemDefaultDB);
                if (isBatchApp) {
                    System.err.println(msg);
                } else {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(null), msg, ResMsgCore.getString("LICENSE_DLG_TITLE"), 0);
                }
            } else {
                this._defaultDBAlreadySelected = true;
                if (this.verifyConnection(select)) {
                    return select.getSQLConnection().setUnique(isBatchApp || Boolean.getBoolean("cecilia.db.QuickLaunch") || !this._list.canBeModify());
                }
            }
        }
        if (this._list.getItems().size() == 1 && (isBatchApp || Boolean.getBoolean("cecilia.db.QuickLaunch") || !this._list.canBeModify()) && this.verifyConnection(select = first)) {
            return select.getSQLConnection().setUnique(true);
        }
        if (isBatchApp || first == null && !this._list.canBeModify()) {
            return null;
        }
        if (this._list.getItems().size() == 0) {
            select = this.createItem(null);
            if (select != null && this.verifyConnection(select)) {
                if (this._mustSaveList && this._list.canBeModify()) {
                    this._list.writeDatabaseFile();
                }
                return select.getSQLConnection().setUnique(!this._list.canBeModify());
            }
            return null;
        }
        DlgConnectionSelectWin dlg = new DlgConnectionSelectWin();
        select = dlg._currentItem;
        if (select != null && this.verifyConnection(select)) {
            if (this._mustSaveList && this._list.canBeModify()) {
                this._list.writeDatabaseFile();
            }
            return select.getSQLConnection();
        }
        return null;
    }

    protected final boolean verifyConnection(SQLConnectionList.Item item) {
        SQLConnection connect = item.getSQLConnection();
        boolean result = true;
        LicenseManager lic = new LicenseManager(connect);
        try {
            Date date = lic.login(null);
            if (date != null) {
                Calendar current = Calendar.getInstance();
                current.add(5, 7);
                if (current.getTime().after(date)) {
                    String msg = ResMsgCore.getString("LICENSE_WARNING_DATE") + DateFormat.getDateInstance().format(date);
                    item.setError(msg);
                    if (this._batchApp) {
                        System.err.println(msg);
                    } else {
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(null), msg, ResMsgCore.getString("LICENSE_DLG_TITLE"), 0);
                    }
                    result = false;
                }
            }
        }
        catch (LicenseException exc) {
            item.setError(ResMsgCore.getString("ERR_DB_TITLE") + "\n" + exc.getMessage());
            if (this._batchApp) {
                System.err.println(ResMsgCore.getString("ERR_DB_TITLE"));
                System.err.println(exc.getMessage());
            } else {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(null), exc.getMessage(), ResMsgCore.getString("ERR_DB_TITLE"), 0);
            }
            result = false;
            try {
                connect.close();
            }
            catch (SQLException ex) {
                LOG.log(Level.FINE, "Exception during close connection", ex);
            }
        }
        return result;
    }

    protected SQLConnectionList.Item createItem(Window win) {
        SQLConnectionList.Item item2;
        HashSet<String> collectDBNames = new HashSet<String>();
        for (SQLConnectionList.Item item2 : this._list.getItems()) {
            collectDBNames.add(item2.getName());
        }
        DBBaseEditDlg dlg = new DBBaseEditDlg(win);
        item2 = dlg.display(null, collectDBNames);
        if (item2 != null) {
            this._list.addItem(item2);
            this._mustSaveList = true;
            return item2;
        }
        return null;
    }

    protected SQLConnectionList.Item editItem(Window win, SQLConnectionList.Item prev) {
        HashSet<String> collectDBNames = new HashSet<String>();
        for (SQLConnectionList.Item item : this._list.getItems()) {
            collectDBNames.add(item.getName());
        }
        DBBaseEditDlg dlg = new DBBaseEditDlg(win);
        SQLConnectionList.Item curr = dlg.display(prev, collectDBNames);
        if (curr != null) {
            this._list.replaceItem(prev, curr);
            this._mustSaveList = true;
            return curr;
        }
        return null;
    }

    protected abstract ImageIcon getBackgroundIcon();

    protected abstract List<? extends Image> getImageIcons();

    protected String getInfos() {
        return ResMsgVoc.getString("VOC_VERSION") + " " + "6.2.0";
    }

    protected String getTypeLicense() {
        return ConfigManager.getVersionLabel();
    }

    class DlgConnectionSelectWin
    extends JDialogCecilia {
        SQLConnectionList.Item _currentItem;
        boolean _bChangeSelect;
        int _timeOut;
        JComboBox _ctrlComboBox;
        DefaultComboBoxModel _ctrlComboBoxModel;
        JPopupMenu _popupList;
        AbstractAction _actionEdit;
        AbstractAction _actionAdd;
        AbstractAction _actionDel;
        JButton _ctrlButOK;
        JButton _ctrlButCancel;

        public DlgConnectionSelectWin() {
            super((Window)null, true);
            this._bChangeSelect = false;
            this._timeOut = DBBaseSelectUtility.this._list.getTimeOut();
            this.create();
            this.init();
            if (this._timeOut > 0 && this._ctrlComboBox.getSelectedItem() != null) {
                Thread timeOutThread = new Thread("DBSelect-TimeOut"){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(DlgConnectionSelectWin.this._timeOut);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (DlgConnectionSelectWin.this._bChangeSelect) {
                            return;
                        }
                        if (!DlgConnectionSelectWin.this.isVisible()) {
                            return;
                        }
                        SQLConnectionList.Item item = (SQLConnectionList.Item)DlgConnectionSelectWin.this._ctrlComboBox.getSelectedItem();
                        if (item != null && DBBaseSelectUtility.this.verifyConnection(item)) {
                            DlgConnectionSelectWin.this._currentItem = item;
                            DlgConnectionSelectWin.this.setVisible(false);
                        }
                    }
                };
                timeOutThread.start();
            }
            this.setVisible(true);
        }

        private void create() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().setBackground(Color.black);
            this.setUndecorated(true);
            List<? extends Image> icons = DBBaseSelectUtility.this.getImageIcons();
            if (icons != null && icons.size() > 0) {
                this.setIconImages(icons);
            }
            int idxSel = -1;
            this._popupList = new JPopupMenu();
            this._actionAdd = new AbstractAction(ResMsgCore.getString("DLG_DBSELECT_CREATE")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLConnectionList.Item item = DBBaseSelectUtility.this.createItem(DlgConnectionSelectWin.this);
                    if (item != null) {
                        DlgConnectionSelectWin.this._ctrlComboBoxModel.addElement(item);
                        DlgConnectionSelectWin.this._ctrlComboBox.setSelectedItem(item);
                        DlgConnectionSelectWin.this.refreshToolTip();
                    }
                }
            };
            this._popupList.add(this._actionAdd);
            this._actionDel = new AbstractAction(ResMsgCore.getString("DLG_DBSELECT_DEL")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int pos = DlgConnectionSelectWin.this._ctrlComboBox.getSelectedIndex();
                    if (pos < 0) {
                        return;
                    }
                    SQLConnectionList.Item item = (SQLConnectionList.Item)DlgConnectionSelectWin.this._ctrlComboBoxModel.getElementAt(pos);
                    int result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(DlgConnectionSelectWin.this), ResMsgCore.msgFormat("DLG_DBSELECT_DEL_CONFIRM", item.getName()), DlgConnectionSelectWin.this.getTitle(), 0);
                    if (result == 0) {
                        DBBaseSelectUtility.this._list.delItem(item);
                        DBBaseSelectUtility.this._mustSaveList = true;
                        DlgConnectionSelectWin.this._ctrlComboBoxModel.removeElementAt(pos);
                    }
                }
            };
            this._popupList.add(this._actionDel);
            this._actionEdit = new AbstractAction(ResMsgCore.getString("DLG_DBSELECT_EDIT")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int pos = DlgConnectionSelectWin.this._ctrlComboBox.getSelectedIndex();
                    if (pos < 0) {
                        return;
                    }
                    SQLConnectionList.Item item = (SQLConnectionList.Item)DlgConnectionSelectWin.this._ctrlComboBoxModel.getElementAt(pos);
                    SQLConnectionList.Item curr = DBBaseSelectUtility.this.editItem(DlgConnectionSelectWin.this, item);
                    if (curr != null) {
                        DlgConnectionSelectWin.this._ctrlComboBoxModel.removeElementAt(pos);
                        DlgConnectionSelectWin.this._ctrlComboBoxModel.insertElementAt(curr, pos);
                        DlgConnectionSelectWin.this._ctrlComboBox.setSelectedIndex(pos);
                        DlgConnectionSelectWin.this.refreshToolTip();
                    }
                }
            };
            this._popupList.add(this._actionEdit);
            JPanel selectDBPanel = new JPanel(new GridBagLayout());
            selectDBPanel.setOpaque(false);
            JLabel label = new JLabel(ResMsgCore.getString("DLG_DBSELECT_LABEL"));
            label.setForeground(Color.black);
            label.setOpaque(false);
            selectDBPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlComboBoxModel = new DefaultComboBoxModel();
            int curIdx = 0;
            SQLConnectionList.Item defItem = DBBaseSelectUtility.this._list.getDefaultSQLConnection();
            for (SQLConnectionList.Item item : DBBaseSelectUtility.this._list.getItems()) {
                if (!item.verifyCompatibility()) continue;
                this._ctrlComboBoxModel.addElement(item);
                if (idxSel == -1 && defItem != null && item == defItem) {
                    idxSel = curIdx;
                }
                ++curIdx;
            }
            this._ctrlComboBox = new JComboBox(this._ctrlComboBoxModel);
            this._ctrlComboBox.setEditable(false);
            this._ctrlComboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    this.setHorizontalAlignment(0);
                    if (isSelected) {
                        this.setForeground(list.getSelectionForeground());
                    } else {
                        this.setForeground(list.getForeground());
                    }
                    if (value != null) {
                        String name;
                        SQLConnectionList.Item item = (SQLConnectionList.Item)value;
                        if (item.getError() != null) {
                            this.setForeground(Color.red);
                        }
                        if ((name = item.getName()).length() > 20) {
                            name = name.substring(0, 20) + "...";
                        }
                        this.setText(name);
                        this.setToolTipText(DlgConnectionSelectWin.this.defineToolTip(item));
                    }
                    return this;
                }
            });
            this._ctrlComboBox.setForeground(Color.black);
            this._ctrlComboBox.setOpaque(false);
            this._ctrlComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgConnectionSelectWin.this._bChangeSelect = true;
                    DlgConnectionSelectWin.this.refreshToolTip();
                }
            });
            if (DBBaseSelectUtility.this._list.canBeModify()) {
                this._ctrlComboBox.setComponentPopupMenu(this._popupList);
                this._popupList.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        Object obj = DlgConnectionSelectWin.this._ctrlComboBox.getSelectedItem();
                        DlgConnectionSelectWin.this._actionEdit.setEnabled(obj != null);
                        DlgConnectionSelectWin.this._actionDel.setEnabled(obj != null);
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                });
            }
            this._ctrlComboBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        DlgConnectionSelectWin.this.closeWindow(true);
                    } else if (e.getKeyCode() == 27) {
                        DlgConnectionSelectWin.this.closeWindow(false);
                    }
                }
            });
            selectDBPanel.add((Component)this._ctrlComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 0), 0, 0));
            JPanel panelOKCancel = new JPanel(new GridLayout(1, 2, 10, 10));
            panelOKCancel.setOpaque(false);
            AbstractAction actOk = new AbstractAction(ResMsgVoc.getString("VOC_OK")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgConnectionSelectWin.this.closeWindow(true);
                }
            };
            this._ctrlButOK = new JButton(actOk);
            this._ctrlButOK.setOpaque(false);
            panelOKCancel.add(this._ctrlButOK);
            this.putAction("CECILIA_ENTER", actOk);
            AbstractAction actCancel = new AbstractAction(ResMsgVoc.getString("VOC_CANCEL")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgConnectionSelectWin.this.closeWindow(false);
                }
            };
            this._ctrlButCancel = new JButton(actCancel);
            this._ctrlButCancel.setOpaque(false);
            panelOKCancel.add(this._ctrlButCancel);
            this.putAction("CECILIA_CANCEL", actCancel);
            selectDBPanel.add((Component)panelOKCancel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 15, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)selectDBPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 12, 2, new Insets(310, 20, 0, 20), 0, 0));
            JLabel infos = new JLabel(DBBaseSelectUtility.this.getTypeLicense());
            infos.setForeground(Color.black);
            infos.setOpaque(false);
            this.getContentPane().add((Component)infos, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 40, 20), 0, 0));
            infos = new JLabel(DBBaseSelectUtility.this.getInfos());
            infos.setForeground(Color.black);
            infos.setOpaque(false);
            this.getContentPane().add((Component)infos, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 20, 20), 0, 0));
            JLabel labelSplash = null;
            ImageIcon splash = DBBaseSelectUtility.this.getBackgroundIcon();
            if (splash != null) {
                labelSplash = new JLabel(splash);
                labelSplash.setBackground(Color.white);
                this.getContentPane().add((Component)labelSplash, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
            }
            if (idxSel == -1 && this._ctrlComboBoxModel.getSize() == 1) {
                idxSel = 0;
            }
            if (idxSel != -1) {
                this._ctrlComboBox.setSelectedIndex(idxSel);
            }
            this._bChangeSelect = false;
            this.pack();
            this.setLocationRelativeTo(null);
        }

        protected void closeWindow(boolean valid) {
            if (valid) {
                SQLConnectionList.Item item = (SQLConnectionList.Item)this._ctrlComboBox.getSelectedItem();
                if (item != null) {
                    if (DBBaseSelectUtility.this.verifyConnection(item)) {
                        this._currentItem = item;
                        this.setVisible(false);
                    } else {
                        this.refreshToolTip();
                    }
                }
            } else {
                this._currentItem = null;
                this.setVisible(false);
            }
        }

        protected String defineToolTip(SQLConnectionList.Item item) {
            StringBuffer ttbuffer = new StringBuffer();
            String error = item.getError();
            ttbuffer.append("<html>");
            ttbuffer.append("<b>");
            ttbuffer.append(item.getName());
            ttbuffer.append("</b>");
            ttbuffer.append("<br>");
            ttbuffer.append(item.getStringConnection());
            if (error != null) {
                ttbuffer.append("<br>");
                ttbuffer.append("<font color='red'>");
                ttbuffer.append(error.replaceAll("[\r\n]+", "<br>"));
                ttbuffer.append("</font>");
            }
            ttbuffer.append("</html>");
            return ttbuffer.toString();
        }

        protected void refreshToolTip() {
            String toolTip = null;
            SQLConnectionList.Item item = (SQLConnectionList.Item)this._ctrlComboBox.getSelectedItem();
            if (item != null) {
                toolTip = this.defineToolTip(item);
            }
            this._ctrlComboBox.setToolTipText(toolTip);
        }
    }
}

