/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.export.DBKTableModel;
import com.dassault.cecilia.core.cecilia.export.DBKWriter;
import java.io.IOException;
import java.util.Iterator;

public class DBKTable {
    private DBKWriter _xmlWriter;
    private DBKTableModel _xmlTableModel;

    public DBKTable(DBKWriter writer, DBKTableModel tableModel) {
        this._xmlWriter = writer;
        this._xmlTableModel = tableModel;
    }

    public void insertTable() {
        try {
            int nbCol = this._xmlTableModel.getColumnCount();
            int nbRow = this._xmlTableModel.getRowCount();
            this._xmlWriter.write(" <informaltable frame=\"all\">\n", false);
            this._xmlWriter.addIndent(1);
            this._xmlWriter.write("<tgroup cols=\"" + nbCol + "\"> \n", false);
            this._xmlWriter.addIndent(1);
            this._xmlWriter.write(" <thead>\n", false);
            Iterator<String> iterator = this._xmlTableModel.getColumn().iterator();
            this._xmlWriter.addIndent(1);
            this._xmlWriter.write("<row>\n", false);
            this._xmlWriter.addIndent(1);
            while (iterator.hasNext()) {
                this._xmlWriter.write("<entry align=\"center\">", false);
                this._xmlWriter.write(iterator.next(), true);
                this._xmlWriter.write("</entry>\n", false);
            }
            this._xmlWriter.addIndent(-1);
            this._xmlWriter.write("</row>\n", false);
            this._xmlWriter.addIndent(-1);
            this._xmlWriter.write(" </thead>\n ", false);
            this._xmlWriter.addIndent(-1);
            this._xmlWriter.write("<tbody>\n", false);
            this._xmlWriter.addIndent(1);
            for (int j = 0; j < nbRow; ++j) {
                this._xmlWriter.write("<row>\n", false);
                this._xmlWriter.addIndent(1);
                for (int i = 0; i < nbCol; ++i) {
                    int nbMoreRows = this._xmlTableModel.getMoreRowsValueAt(j, i);
                    if (nbMoreRows == 0) {
                        this._xmlWriter.write("<entry>", false);
                        this._xmlTableModel.writeEntryAt(this._xmlWriter, j, i);
                        this._xmlWriter.write("</entry>\n", false);
                        continue;
                    }
                    if (nbMoreRows <= 0) continue;
                    this._xmlWriter.write("<entry morerows=\"" + nbMoreRows + "\">", false);
                    this._xmlTableModel.writeEntryAt(this._xmlWriter, j, i);
                    this._xmlWriter.write("</entry>\n", false);
                }
                this._xmlWriter.addIndent(-1);
                this._xmlWriter.write("</row>\n", false);
            }
            this._xmlWriter.write("</tbody>\n", false);
            this._xmlWriter.addIndent(-1);
            this._xmlWriter.write("</tgroup>\n", false);
            this._xmlWriter.addIndent(-1);
            this._xmlWriter.write("</informaltable>\n", false);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

