/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.cecilia.folder.SetFolderTreeNode;
import com.dassault.cecilia.db.DBFolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SetFolderTreeModel
implements TreeModel {
    Map<DBFolder, SetFolderTreeNode> _nodes = new HashMap<DBFolder, SetFolderTreeNode>();
    SetFolderTreeNode _root;
    List<TreeModelListener> _listeners = new ArrayList<TreeModelListener>();

    public SetFolderTreeModel(Collection<DBFolder> dbFolders) {
        this.addFolders(dbFolders);
    }

    private SetFolderTreeNode addFolder(DBFolder dbFolder) {
        SetFolderTreeNode setFolder = this.getTreeNode(dbFolder);
        if (setFolder == null) {
            setFolder = new SetFolderTreeNode(dbFolder);
            this.putTreeNode(dbFolder, setFolder);
            if (this._root == null && dbFolder.getParent() == null) {
                this._root = setFolder;
            } else {
                SetFolderTreeNode parFolder = this.addFolder(dbFolder.getParent());
                parFolder.insert(setFolder);
            }
        }
        return setFolder;
    }

    public synchronized void addFolders(Collection<DBFolder> dbFolders) {
        this._root = null;
        this._nodes.clear();
        for (DBFolder dbFolder : dbFolders) {
            this.addFolder(dbFolder);
        }
        if (!this._listeners.isEmpty()) {
            TreeModelEvent e = new TreeModelEvent((Object)this, (TreePath)null);
            for (TreeModelListener l : this._listeners) {
                l.treeStructureChanged(e);
            }
        }
    }

    @Override
    public synchronized SetFolderTreeNode getRoot() {
        return this._root;
    }

    public SetFolderTreeNode getTreeNode(DBFolder dbFolder) {
        return this._nodes.get(dbFolder);
    }

    void putTreeNode(DBFolder dbFolder, SetFolderTreeNode trNode) {
        this._nodes.put(dbFolder, trNode);
    }

    void removeTreeNode(DBFolder dbFolder, SetFolderTreeNode trNode) {
        this._nodes.remove(dbFolder);
    }

    protected TreeNode getParentNode(TreeNode nodeFolder) {
        return nodeFolder.getParent();
    }

    public SetFolderTreeNode constructPath(DBFolder dbFolder) {
        SetFolderTreeNode node = this.getTreeNode(dbFolder);
        if (node != null) {
            return node;
        }
        DBFolder dbParent = dbFolder.getParent();
        node = this.constructPath(dbParent);
        if (node == null) {
            return null;
        }
        if (node.getChildCount() == 0) {
            return null;
        }
        return this.getTreeNode(dbFolder);
    }

    @Override
    public synchronized Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public synchronized int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    @Override
    public synchronized boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public synchronized int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this._listeners.remove(l);
    }

    private SetFolderTreeNode[] getPathToRoot_rec(SetFolderTreeNode dbFolder, int depth) {
        SetFolderTreeNode[] result;
        if (dbFolder == null) {
            if (depth == 0) {
                return null;
            }
            result = new SetFolderTreeNode[depth];
        } else {
            result = dbFolder == this._root ? new SetFolderTreeNode[depth] : this.getPathToRoot_rec(this.getTreeNode(dbFolder.getDBFolder().getParent()), ++depth);
            result[result.length - depth] = dbFolder;
        }
        return result;
    }

    public SetFolderTreeNode[] getPathToRoot(SetFolderTreeNode dbFolder) {
        return this.getPathToRoot_rec(dbFolder, 0);
    }
}

