/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder.dnd;

import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderList;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderListTransferable;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DBFolderListDropTargetListener
extends DropTargetAdapter {
    private static Logger _LOG = Logger.getLogger(DBFolderListDropTargetListener.class.getPackage().getName());
    Component _component;

    public DBFolderListDropTargetListener(Component component) {
        this._component = component;
    }

    protected abstract boolean isDnDAcceptable(DBFolderList var1);

    protected boolean isDropAcceptable(int dropAction, Transferable transferable) {
        if ((dropAction & 2) == 0) {
            return false;
        }
        try {
            DBFolderList dataDnD = (DBFolderList)transferable.getTransferData(DBFolderListTransferable.DB_FLAVOR);
            return this.isDnDAcceptable(dataDnD);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean isDragAcceptable(DropTargetDragEvent event) {
        if (event.isDataFlavorSupported(DBFolderListTransferable.DB_FLAVOR)) {
            return this.isDropAcceptable(event.getDropAction(), event.getTransferable());
        }
        return false;
    }

    protected boolean isDropAcceptable(DropTargetDropEvent event) {
        if (event.isDataFlavorSupported(DBFolderListTransferable.DB_FLAVOR)) {
            return this.isDropAcceptable(event.getDropAction(), event.getTransferable());
        }
        return false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
            return;
        }
        _LOG.finest("BatchPanel.BatchDropTarget.dragEnter");
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
            return;
        }
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (!this.isDropAcceptable(event)) {
            event.rejectDrop();
            return;
        }
        _LOG.finest("BatchPanel.BatchDropTarget.drop");
        try {
            event.acceptDrop(2);
            Transferable transferable = event.getTransferable();
            DBFolderList dataDnD = (DBFolderList)transferable.getTransferData(DBFolderListTransferable.DB_FLAVOR);
            this.dropDnD(dataDnD, event.getLocation());
            event.dropComplete(true);
        }
        catch (IOException e) {
            _LOG.log(Level.WARNING, "Drag'n Drop error", e);
            event.dropComplete(false);
        }
        catch (UnsupportedFlavorException e) {
            _LOG.log(Level.WARNING, "Drag'n Drop error", e);
            event.dropComplete(false);
        }
    }

    protected abstract void dropDnD(DBFolderList var1, Point var2);
}

