/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder.gui;

import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class DBFolderPanelSelect
extends JPanel {
    PlugableAppl _application;
    DBFolder.Family _dbFamily;
    DBFolderTreeModel _ctrlModel;
    DBFolderTree _ctrlTree;

    public DBFolderPanelSelect(PlugableAppl appl, DBFolder.Family dbFamily) {
        this(appl, dbFamily, true);
    }

    protected DBFolderPanelSelect(PlugableAppl appl, DBFolder.Family dbFamily, boolean create) {
        super(new BorderLayout());
        this._application = appl;
        this._dbFamily = dbFamily;
        if (create) {
            this.make();
        }
    }

    protected String getRootName() {
        return this._dbFamily.getRootName();
    }

    public boolean selectFolder(DBFolder dbFolder) {
        return true;
    }

    public void resetCache() {
        DAOFolder daoFolder = this._application.getDAOFactory().createFolderDAO();
        DBFolder root = daoFolder.getRootID(this.getRootName());
        this._ctrlModel.setFolderRoot(root);
    }

    public DBFolderTree getCtrlTree() {
        return this._ctrlTree;
    }

    public DBFolderTreeModel getCtrlModel() {
        return this._ctrlModel;
    }

    protected void make() {
        DAOFolder daoFolder = this._application.getDAOFactory().createFolderDAO();
        DBFolder root = daoFolder.getRootID(this.getRootName());
        if (root == null) {
            throw new NullPointerException();
        }
        this._ctrlModel = this.createTreeModel(this._application, this._dbFamily);
        this._ctrlModel.setFolderRoot(root);
        this._ctrlModel.setWithNodeFile(false);
        this._application.addFolderUpdateListener(this._ctrlModel);
        this._ctrlTree = new DBFolderTree(this._application, this._ctrlModel, true);
        this._ctrlTree.getSelectionModel().setSelectionMode(1);
        this._ctrlTree.doExpand(Collections.singletonList(root), 0);
        JScrollPane scroll = new JScrollPane(this._ctrlTree);
        scroll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)scroll, "Center");
    }

    protected DBFolderTreeModel createTreeModel(PlugableAppl appl, DBFolder.Family dbFamily) {
        DAOFactory daoFactory = appl.getDAOFactory();
        return new DBFolderTreeModel(daoFactory.createFolderDAO(), daoFactory.createUserDAO(), appl.getDBUser(), dbFamily, "Select-" + (Object)((Object)dbFamily)){

            @Override
            public boolean acceptFolder(DBFolder dbFolder) {
                return DBFolderPanelSelect.this.selectFolder(dbFolder);
            }
        };
    }

    public DBFolder[] getSelectFolders() {
        TreePath[] paths = this._ctrlTree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        DBFolder[] dbFolders = new DBFolder[paths.length];
        int j = 0;
        for (int i = 0; i < paths.length; ++i) {
            DBFolderTreeNode selectNode = (DBFolderTreeNode)paths[i].getLastPathComponent();
            if (selectNode == null) continue;
            dbFolders[j++] = selectNode.getDBFolder();
        }
        if (j == paths.length) {
            return dbFolders;
        }
        if (j == 0) {
            return null;
        }
        DBFolder[] result = new DBFolder[j];
        System.arraycopy(dbFolders, 0, result, 0, j);
        return result;
    }

    public DBFolder getSelectFolder(boolean expand) {
        TreePath path = this._ctrlTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DBFolderTreeNode selectNode = (DBFolderTreeNode)path.getLastPathComponent();
        if (selectNode == null) {
            return null;
        }
        DBFolder dbFolder = selectNode.getDBFolder();
        if (dbFolder == null) {
            return null;
        }
        if (dbFolder.isVersion()) {
            return dbFolder;
        }
        if (dbFolder.isModel() && expand) {
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = this._application.getDAOFactory().createFolderDAO().findChildren(dbFolder);
            }
            if (children != null && children.size() == 1) {
                return children.get(0);
            }
        }
        return null;
    }

    public void setSelectFolder(DBFolder dbFolder) {
        this._ctrlTree.doSelect(dbFolder == null ? null : Collections.singletonList(dbFolder));
    }

    public void setSelectFolder(String strPath) {
        DBFolder dbFolder = this._application.getDAOFactory().createFolderDAO().findFolder(this.getRootName(), strPath);
        this.setSelectFolder(dbFolder);
    }

    public void dispose() {
        if (this._application != null) {
            PlugableAppl appl = this._application;
            this._application = null;
            appl.removeFolderUpdateListener(this._ctrlModel);
        }
    }
}

