/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.pluginmanager.AbstractAttachableComponentDescriptor;
import com.dassault.cecilia.core.pluginmanager.Menu;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.IOException;
import org.w3c.dom.Node;

public class MenuDescriptor
extends AbstractAttachableComponentDescriptor {
    private String _name;
    private String _iconPath = "";

    public MenuDescriptor() {
        super("MENU");
    }

    @Override
    public void readNode(Node node) {
        this._name = node.getAttributes().getNamedItem("NAME").getNodeValue();
        Node icon = node.getAttributes().getNamedItem("ICON_PATH");
        if (icon != null) {
            this._iconPath = node.getNodeValue();
        }
        super.readNode(node);
    }

    @Override
    public void writeNodeAttributes(BufferedWriter writer) throws IOException {
        writer.write("NAME=\"" + this._name + "\" ");
        if (this._iconPath != null && this._iconPath.length() > 0) {
            writer.write("ICON_PATH=\"" + this._iconPath + "\" ");
        }
        super.writeNodeAttributes(writer);
    }

    @Override
    public Component createComponent() {
        Menu menu = new Menu(this);
        return menu;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setIconPath(String iconPath) {
        this._iconPath = iconPath == null ? "" : iconPath;
    }

    public String getName() {
        return this._name;
    }

    public String getIconPath() {
        return this._iconPath;
    }
}

