/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.table;

import com.dassault.cecilia.lib.util.format.HtmlConverter;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class HtmlTableCellRenderer
extends DefaultTableCellRenderer {
    int _minimalHeight = -1;

    public HtmlTableCellRenderer() {
    }

    public HtmlTableCellRenderer(int minimalHeight) {
        this._minimalHeight = minimalHeight;
    }

    @Override
    public Component getTableCellRendererComponent(final JTable component, Object value, boolean isSelected, boolean hasFocus, final int row, int column) {
        super.getTableCellRendererComponent(component, value, isSelected, hasFocus, row, column);
        String msg = value.toString();
        int nbrLine = 0;
        HtmlConverter htmlConverter = new HtmlConverter();
        StringBuilder bufferText = new StringBuilder(msg.length() * 12 / 10);
        StringBuilder bufferToolTip = new StringBuilder(msg.length() * 12 / 10);
        bufferText.append("<html>\n");
        bufferToolTip.append("<html>\n");
        StringTokenizer tok = new StringTokenizer(msg, "\n");
        while (tok.hasMoreElements()) {
            String str = tok.nextToken();
            if (++nbrLine <= 4) {
                htmlConverter.toHTML(bufferText, str).append("<br />\n");
            }
            htmlConverter.toHTML(bufferToolTip, str).append("<br />\n");
        }
        if (nbrLine > 4) {
            bufferText.append("...");
        }
        bufferText.append("</html>");
        bufferToolTip.append("</html>");
        this.setText(bufferText.toString());
        this.setToolTipText(bufferToolTip.toString());
        final int height = Math.max(this._minimalHeight, component.getRowHeight() * Math.min(5, nbrLine));
        if (height != component.getRowHeight(row)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    component.setRowHeight(row, height);
                }
            });
        }
        return this;
    }
}

