/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFlagItem;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IFolder;
import com.dassault.cecilia.db.IGroup;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparable;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.lib.util.AlphaNumComparator;
import com.dassault.cecilia.lib.util.format.Convertable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DBFolder
extends DBFlagItem
implements IFolder,
Convertable,
Comparable<DBFolder>,
DBComparable<DBFolder> {
    DBFolder _parent;
    DBObject _obj;
    String _name = "";
    String _description = "";
    IGroup _groupOwner;
    IUser _userOwner;
    DBAccess.Right _rightGroup;
    DBAccess.Right _rightOther;
    Date _dateCreate;
    Date _dateModify;
    IUser _userModify;
    long _timeUpdate;
    List<DBAccess> _accesses;
    List<DBFolder> _children;
    Collection<DBRelation> _relations;
    private static Comparator<DBFolder> __COMPARATOR_WITH_FAMILY = new Comparator<DBFolder>(){

        @Override
        public int compare(DBFolder o1, DBFolder o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int r = Family.getComparator().compare(o1.getFamily(), o2.getFamily());
            if (r == 0) {
                r = o1.getRefPath().compareTo(o2.getRefPath());
            }
            return r;
        }
    };
    private static Comparator<DBFolder> __COMPARATOR_DEPTH = new Comparator<DBFolder>(){

        @Override
        public int compare(DBFolder fol1, DBFolder fol2) {
            if (fol1.isVersion()) {
                if (fol2.isVersion()) {
                    return Long.compare(fol1.getID(), fol2.getID());
                }
                return -1;
            }
            if (fol2.isVersion()) {
                return 1;
            }
            if (fol1.isModel()) {
                if (fol2.isModel()) {
                    return Long.compare(fol1.getID(), fol2.getID());
                }
                return -1;
            }
            if (fol2.isModel()) {
                return 1;
            }
            if (fol1.isFolder()) {
                if (fol2.isFolder()) {
                    int diff = fol2.getDepthUntilRoot() - fol1.getDepthUntilRoot();
                    if (diff != 0) {
                        return diff;
                    }
                    return Long.compare(fol1.getID(), fol2.getID());
                }
                return -1;
            }
            if (fol2.isFolder()) {
                return 1;
            }
            return Long.compare(fol1.getID(), fol2.getID());
        }
    };
    public static final int FLAG_UNUSED = -16777216;
    public static final int FLAG_SYSTEM = 0x800000;
    public static final int FLAG_FOLDER = 0x400000;
    public static final int FLAG_MODEL = 0x200000;
    public static final int FLAG_VERSION = 0x100000;
    public static final int FLAG_FAMILY = 1044480;
    public static final int FLAG_SUBFAMILY = 3840;
    public static final int FLAG_USER = 255;
    public static final String FOLDER_ROOT = "ROOT";
    public static final String FOLDER_BTP = "BTP";
    public static final String FOLDER_ATTRIBUTES = "ATTRIBUTES";
    public static final String FOLDER_LAW_PARAMETERS = "LAW_PARAMETERS";
    public static final String FOLDER_LAW_MODELS = "LAW_MODELS";
    public static final String FOLDER_BTP_APPLICATIONS = "BTP_APPLICATIONS";
    public static final String FOLDER_BTP_AUTHORS = "BTP_AUTHORS";
    public static final String FOLDER_BTP_SUBSTANTIATIONS = "BTP_SUBSTANTIATIONS";
    public static final String FOLDER_FMEA_MODELS = "FMEA_MODELS";
    public static final String FOLDER_CCF_MODELS = "CCF_MODELS";
    public static final String FOLDER_PROJECTS = "PROJECTS";
    public static final String FOLDER_EQUIPMENT_FAMILIES = "EQUIPMENT_FAMILIES";
    public static final String FOLDER_COMPONENT_FAMILIES = "COMPONENT_FAMILIES";
    public static final String FOLDER_OPERATOR_FAMILIES = "OPERATOR_FAMILIES";
    public static final String FOLDER_TYPE_FAMILIES = "TYPE_FAMILIES";
    public static final String FOLDER_IMAGE_FAMILIES = "IMAGE_FAMILIES";
    public static final short FFLAG_TYPE_ENUM = 1;
    public static final short FFLAG_TYPE_LINK = 2;
    public static final short FFLAG_PROJECT_MODEL = 1;
    public static final short FFLAG_PROJECT_TREE = 2;
    public static final short FFLAG_PROJECT_DSF = 3;
    public static final short FFLAG_PROJECT_FMEA = 4;
    public static final short FFLAG_PROJECT_BEQ = 5;
    public static final short FFLAG_PROJECT_ROOT = 8;
    private static final List<DBAccess> _SYS_ACCESSES = new ArrayList<DBAccess>(1);
    static Comparator<DBFolder> __comparatorName = new Comparator<DBFolder>(){
        Comparator<String> _delegate = AlphaNumComparator.getInstance((boolean)true);

        @Override
        public int compare(DBFolder o1, DBFolder o2) {
            return this._delegate.compare(o1.getName(), o2.getName());
        }
    };
    private boolean _mustBeUpdated = false;
    private boolean _isEdited = false;
    private long _isExternalFlag = 0L;

    public DBFolder() {
        this._dateCreate = new Date();
        this._dateModify = new Date();
    }

    public DBFolder(long id) {
        super(id);
    }

    public DBFolder(DBFolder parent, DBUser user) {
        this._parent = parent;
        this._dateCreate = new Date();
        this._dateModify = new Date();
        this._userOwner = user;
        this._userModify = user;
        List<DBAccess> parentAccesses = parent.getAccesses();
        if (!parent.isSystem()) {
            if (parent.getUserOwner().equals(user)) {
                this._groupOwner = parent.getGroupOwner();
                this._rightGroup = parent.getRightGroup();
                this._rightOther = parent.getRightOther();
                if (parentAccesses != null) {
                    this._accesses = new ArrayList<DBAccess>(parentAccesses);
                }
            } else {
                this._groupOwner = null;
                this._accesses = new ArrayList<DBAccess>();
                if (this._groupOwner == null && parent.getRightGroup() == DBAccess.Right.WRITE && user.getGroups().contains(parent.getGroupOwner())) {
                    this._groupOwner = parent.getGroupOwner();
                    this._rightGroup = parent.getRightGroup();
                    this._rightOther = parent.getRightOther();
                    if (parentAccesses != null) {
                        this._accesses = new ArrayList<DBAccess>(parentAccesses);
                    }
                }
                if (this._groupOwner == null && parent.getRightOther() == DBAccess.Right.WRITE) {
                    this._groupOwner = user.getDefaultGroup();
                    this._rightGroup = DBAccess.Right.WRITE;
                    this._rightOther = DBAccess.Right.WRITE;
                    if (parentAccesses != null) {
                        for (DBAccess dbAccess : parentAccesses) {
                            if (dbAccess.getGroup().equals(this._groupOwner)) continue;
                            this.addPrivateAccess(dbAccess);
                        }
                    }
                }
                if (this._groupOwner == null && parentAccesses != null) {
                    for (DBAccess dbAccess : parentAccesses) {
                        if (this._groupOwner == null && dbAccess.getGroup().equals(user.getDefaultGroup()) && dbAccess.getRight() == DBAccess.Right.WRITE) {
                            this._groupOwner = dbAccess.getGroup();
                            this._rightGroup = dbAccess.getRight();
                            this._rightOther = parent.getRightOther();
                            continue;
                        }
                        this.addPrivateAccess(dbAccess);
                    }
                    if (parent.getRightGroup() != DBAccess.Right.NONE) {
                        this.addPrivateAccess(new DBAccess().setGroup(parent.getGroupOwner()).setRight(parent.getRightGroup()));
                    }
                }
                if (this._groupOwner == null && parentAccesses != null) {
                    for (DBAccess dbAccess : parentAccesses) {
                        if (this._groupOwner == null && user.getGroups().contains(dbAccess.getGroup()) && dbAccess.getRight() == DBAccess.Right.WRITE) {
                            this._groupOwner = dbAccess.getGroup();
                            this._rightGroup = dbAccess.getRight();
                            this._rightOther = parent.getRightOther();
                            continue;
                        }
                        this.addPrivateAccess(dbAccess);
                    }
                    if (parent.getRightGroup() != DBAccess.Right.NONE) {
                        this.addPrivateAccess(new DBAccess().setGroup(parent.getGroupOwner()).setRight(parent.getRightGroup()));
                    }
                }
            }
        }
        if (this._groupOwner == null) {
            this._groupOwner = user.getDefaultGroup();
            this._rightGroup = DBAccess.Right.READ;
            this._rightOther = DBAccess.Right.NONE;
            this._accesses = new ArrayList<DBAccess>();
        }
        if (this._accesses == null) {
            this._accesses = new ArrayList<DBAccess>();
        }
    }

    public DBFolder(DBFolder src) {
        this();
        this.copyFrom(src);
    }

    public void copyFrom(DBFolder src) {
        super.copyFrom(src);
        this._parent = src._parent;
        this._children = src._children;
        this._obj = src._obj;
        this._groupOwner = src._groupOwner;
        this._userOwner = src._userOwner;
        this._name = src._name;
        this._description = src._description;
        this._rightGroup = src._rightGroup;
        this._rightOther = src._rightOther;
        this._dateCreate = src._dateCreate;
        this._dateModify = src._dateModify;
        this._userModify = src._userModify;
        this._timeUpdate = src._timeUpdate;
        if (src._accesses != null) {
            this._accesses = new ArrayList<DBAccess>(src._accesses.size());
            for (int i = 0; i < src._accesses.size(); ++i) {
                this._accesses.add(new DBAccess(src._accesses.get(i)));
            }
        } else {
            this._accesses = null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof DBFolder;
    }

    @Override
    public String toString() {
        StringBuilder debug = new StringBuilder();
        debug.append("Folder:").append(this._id).append(",").append(this._name);
        if (this._parent != null) {
            debug.append(",[<=").append(this._parent.getID()).append(",");
            this._parent.getPathUntilSystem(debug);
            debug.append("]");
        } else {
            debug.append(",[<=-1]");
        }
        return debug.toString();
    }

    public String convertToString() {
        return this.getRefPath();
    }

    public static Comparator<DBFolder> getComparatorWithFamily() {
        return __COMPARATOR_WITH_FAMILY;
    }

    public static Comparator<DBFolder> getComparatorDepth() {
        return __COMPARATOR_DEPTH;
    }

    @Override
    public int compareTo(DBFolder o) {
        return __COMPARATOR_WITH_FAMILY.compare(this, o);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isFreeze() {
        if (this._obj != null) {
            return this._obj.isFreeze();
        }
        return false;
    }

    @Override
    public boolean isLocked() {
        if (this._obj != null) {
            return this._obj.isLocked();
        }
        return false;
    }

    @Override
    public DBFolder getSource() {
        return this;
    }

    public DBFolder getParent() {
        return this._parent;
    }

    public DBFolder setParent(DBFolder parent) {
        this._parent = parent;
        return this;
    }

    public StringBuilder getPathUntilSystem(StringBuilder sb) {
        if (this.isSystem()) {
            return sb;
        }
        if (this._parent != null) {
            this._parent.getPathUntilSystem(sb);
        }
        sb.append("/").append(this.getName());
        return sb;
    }

    public String getRefPath() {
        StringBuilder sb = this.getPathUntilSystem(new StringBuilder());
        if (sb.length() > 0) {
            int pos;
            if (sb.charAt(0) == '/') {
                sb.deleteCharAt(0);
            }
            if (this.isVersion() && (pos = sb.lastIndexOf("/")) > 0) {
                sb.setCharAt(pos, ';');
            }
        }
        return sb.toString();
    }

    public int getDepthUntilSystem() {
        if (this.isSystem()) {
            return 0;
        }
        assert (this._parent != null);
        if (this._parent == null || this._parent.isSystem()) {
            return 1;
        }
        return this._parent.getDepthUntilSystem() + 1;
    }

    public int getDepthUntilRoot() {
        if (this._parent == null) {
            return 0;
        }
        return this._parent.getDepthUntilRoot() + 1;
    }

    public DBObject getObject() {
        return this._obj;
    }

    public DBFolder setObject(DBObject obj) {
        this._obj = obj;
        this._obj.setFolder(this);
        return this;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public DBFolder setName(String name) {
        this._name = name;
        return this;
    }

    public String getDescription() {
        return this._description;
    }

    public DBFolder setDescription(String description) {
        if (description != null && description.length() > 1023) {
            _LOG.severe("Description loo large (" + description.length() + ") for Folder : " + this.getRefPath());
            _LOG.info(description);
        }
        this._description = description;
        return this;
    }

    public IGroup getGroupOwner() {
        return this._groupOwner;
    }

    public DBFolder setGroupOwner(IGroup grp) {
        this._groupOwner = grp;
        return this;
    }

    public IUser getUserOwner() {
        return this._userOwner;
    }

    public DBFolder setUserOwner(IUser user) {
        this._userOwner = user;
        return this;
    }

    public DBAccess.Right getRightGroup() {
        if (this.isSystem()) {
            return DBAccess.Right.WRITE;
        }
        return this._rightGroup;
    }

    public DBFolder setRightGroup(DBAccess.Right right) {
        this._rightGroup = right;
        return this;
    }

    public DBAccess.Right getRightOther() {
        if (this.isSystem()) {
            return DBAccess.Right.WRITE;
        }
        return this._rightOther;
    }

    public DBFolder setRightOther(DBAccess.Right right) {
        this._rightOther = right;
        return this;
    }

    public Date getDateCreate() {
        return this._dateCreate;
    }

    public DBFolder setDateCreate(Date date) {
        this._dateCreate = date;
        return this;
    }

    public Date getDateModify() {
        return this._dateModify;
    }

    public DBFolder setDateModify(Date date) {
        this._dateModify = date;
        return this;
    }

    public IUser getUserModify() {
        return this._userModify;
    }

    public DBFolder setUserModify(IUser user) {
        this._userModify = user;
        return this;
    }

    public long getTimeUpdate() {
        return this._timeUpdate;
    }

    public DBFolder setTimeUpdate(long time) {
        this._timeUpdate = time;
        return this;
    }

    public static int createFlags(int base, Family family, short subFamily, short user) {
        if (subFamily < 0 || subFamily > 15) {
            _LOG.severe("DBFolder.createFlags(miss parameters)");
        }
        if (user < 0 || user > 255) {
            _LOG.severe("DBFolder.createFlags(miss parameters)");
        }
        int result = base;
        result |= family.toInt() << 12 & 0xFF000;
        result |= subFamily << 8 & 0xF00;
        return result |= user & 0xFF;
    }

    public static int createFlagsFolder(Family family, short subFamily, short user) {
        return DBFolder.createFlags(0x400000, family, subFamily, user);
    }

    public static int createFlagsModel(Family family, short subFamily, short user) {
        return DBFolder.createFlags(0x200000, family, subFamily, user);
    }

    public static int createFlagsVersion(Family family, short subFamily, short user) {
        return DBFolder.createFlags(0x100000, family, subFamily, user);
    }

    @Override
    public boolean isSystem() {
        return (this._flags & 0x800000) != 0;
    }

    public boolean isFolder() {
        return (this._flags & 0x400000) != 0;
    }

    public boolean isModel() {
        return (this._flags & 0x200000) != 0;
    }

    public boolean isVersion() {
        return (this._flags & 0x100000) != 0;
    }

    public Family getFamily() {
        Family result = Family.fromInt((this._flags & 0xFF000) >> 12);
        if (result == null) {
            _LOG.info("No folder family for: " + this.toString());
        } else if (result == Family.APPLICATION && !this.isSystem()) {
            _LOG.info("Folder Application isn't 'System': " + this.toString());
        }
        return result;
    }

    public short getFamilyFlag() {
        return (short)((this._flags & 0xF00) >> 8);
    }

    public short getUserFlag() {
        return (short)(this._flags & 0xFF);
    }

    public void setFamilyFlag(short subFamily) {
        if (subFamily < 0 || subFamily > 15) {
            _LOG.severe("DBFolder.setFamilyFlag(miss parameters)");
        }
        int result = this._flags & 0xFFFFF0FF;
        this._flags = result |= subFamily << 8 & 0xF00;
    }

    public void setUserFlag(short user) {
        if (user < 0 || user > 255) {
            _LOG.severe("DBFolder.setUserFlag(miss parameters)");
        }
        int result = this._flags & 0xFFFFFF00;
        this._flags = result |= user & 0xFF;
    }

    public Collection<DBRelation> getRelations() {
        return this._relations;
    }

    public DBFolder setRelations(Collection<DBRelation> relations) {
        this._relations = relations;
        return this;
    }

    public List<DBFolder> getChildren() {
        return this._children;
    }

    public DBFolder setChildren(List<DBFolder> children) {
        this._children = children;
        return this;
    }

    public List<DBAccess> getAccesses() {
        if (this.isSystem()) {
            return _SYS_ACCESSES;
        }
        return this._accesses;
    }

    public DBFolder setAccesses(List<DBAccess> accesses) {
        if (!this.isSystem()) {
            this._accesses = accesses;
        }
        return this;
    }

    private void addPrivateAccess(DBAccess dbAccess) {
        if (this._accesses == null) {
            throw new NullPointerException();
        }
        for (DBAccess curAccess : this._accesses) {
            if (!curAccess.getGroup().equals(dbAccess.getGroup())) continue;
            return;
        }
        this._accesses.add(dbAccess);
    }

    public DBAccess.Right getAccessRight(DBUser user) {
        if (!this.isSystem()) {
            if (this._accesses == null) {
                _LOG.warning("Droits d'acces specifique non charges pour le dossier : " + this.getRefPath());
            }
            assert (this._accesses != null);
        }
        if (this.isSystem()) {
            return DBAccess.Right.WRITE;
        }
        if (user.isAdmin()) {
            return DBAccess.Right.WRITE;
        }
        if (user.equals(this._userOwner)) {
            return DBAccess.Right.WRITE;
        }
        DBAccess.Right right = this._rightOther;
        if (right.equals((Object)DBAccess.Right.WRITE)) {
            return right;
        }
        for (IGroup grp : user.getGroups()) {
            if (grp.equals(this._groupOwner) && right.compareTo(this._rightGroup) < 0 && (right = this._rightGroup).equals((Object)DBAccess.Right.WRITE)) {
                return right;
            }
            if (this._accesses == null || this._accesses.size() <= 0) continue;
            for (DBAccess dbAccess : this._accesses) {
                if (!grp.equals(dbAccess.getGroup()) || right.compareTo(dbAccess.getRight()) >= 0 || !(right = dbAccess.getRight()).equals((Object)DBAccess.Right.WRITE)) continue;
                return right;
            }
        }
        return right;
    }

    public static Comparator<? super DBFolder> getComparator() {
        return __comparatorName;
    }

    public DBFolder findChild(String name) {
        if (this._children == null || this._children.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            DBFolder child = this._children.get(i);
            if (!child.getName().equalsIgnoreCase(name)) continue;
            return child;
        }
        return null;
    }

    public DBFolder setMustBeUpdated(boolean value) {
        this._mustBeUpdated = value;
        return this;
    }

    public boolean mustBeUpdated(long time) {
        if (this._mustBeUpdated) {
            this._mustBeUpdated = false;
            return true;
        }
        return this._timeUpdate < time;
    }

    public boolean isEdited() {
        return this._isEdited;
    }

    public void setEdited(boolean value) {
        this._isEdited = value;
    }

    public long getExternalFlag() {
        return this._isExternalFlag;
    }

    public void setExternalFlag(long value) {
        this._isExternalFlag = value;
    }

    @Override
    public DBComparaisons getCompareConflict(DAOFactory factoryWrap, DBFolder folder, boolean forImport) {
        if (this.getFamily() != folder.getFamily()) {
            return null;
        }
        DBComparaisons compare = new DBComparaisons();
        Function<DBFolder, String> getDesc = e -> e.getDescription();
        compare.addConflict(new CompareResultString(ResMsgVoc.getString("VOC_DESCRIPTION"), getDesc.apply(this), getDesc.apply(folder)));
        if (this.getFamily() == Family.BTP_SUBSTANTIATION) {
            Function<DBFolder, String> getDateSubs = e -> {
                DBObjProperty oprop = e.getObject().getProperty("btp.substantiation.date");
                return oprop.getValue();
            };
            compare.addConflict(new CompareResultString(ResMsgVoc.getString("VOC_SUBSTANTIATION"), getDateSubs.apply(this), getDateSubs.apply(folder)));
        }
        return compare;
    }

    public static enum Family {
        APPLICATION(0, -1, 0, "", ""),
        PROJECT(1, 2, 3000, "PROJECTS", "e708ea183c6ac6114f85df2eb7b53ea9e9761b7d83"),
        COMPONENT(2, 2, 1400, "COMPONENT_FAMILIES", "8af8d5412398efc9efb576757c586d0c75795dbe11b14e"),
        EQUIPMENT(3, 2, 1500, "EQUIPMENT_FAMILIES", "27dd2b3fc4ba75e1289311a4256118c5bb1706b8b81cc3"),
        OPERATOR(4, 2, 1300, "OPERATOR_FAMILIES", "44e5422583f89d025fe06185144e323646348b58b651"),
        TYPE(5, 2, 1200, "TYPE_FAMILIES", "4bfb806a6493258d3bf57fd5b378e58b373d"),
        BTP_MODEL(6, 4, 500, "LAW_MODELS", "caa2a74a517bdf8dbad3be42bceaa641778a5c22dfcc22"),
        ATTRIBUTE(7, 1, 200, "ATTRIBUTES", "d95961d8ab386ec88d7d8974341d5ba4a9424f660ccbcf"),
        PARAMETER(8, 1, 300, "LAW_PARAMETERS", "2bfd0b89c86b12e901cf30095a27c0a49effdb72c58d9e"),
        BTP_APPLICATION(9, 0, 150, "BTP_APPLICATIONS", "336dafaa71670f36a3461043f27077544a9bd84ff08d398485d997b787"),
        BTP_AUTHOR(10, 0, 140, "BTP_AUTHORS", "584710a5ba0741153d57622ecaf5f444f998c9d297c58312b4"),
        BTP_SUBSTANTIATION(11, 0, 130, "BTP_SUBSTANTIATIONS", "5b1aa683d5fbb519a3cf22d58c2e2604b9a492372b63c95c660002d56452d0b0fc"),
        FMEA_MODEL(12, 0, 100, "FMEA_MODELS", "70e45f91047b7e129531557cb3c2b40320813fdb21d55b51c2"),
        CCF_MODEL(13, 0, 400, "CCF_MODELS", "d3e6adb76821364fee8f56a02dc9b2b7d318adc3927edf3f"),
        IMAG(15, 1, 0, "IMAGE_FAMILIES", "9bc6625ece5364b39e8ca00f8132c3a505397a");

        static Map<Integer, Family> _map;
        static Object _mapLocker;
        int _ivalue;
        int _depthFolder;
        int _levelCmp;
        String _rootName;
        String _keyCode;
        private static Comparator<Family> __COMPARATOR_FAMILY;

        private Family(int db, int depth, int levelCmp, String root, String keyCode) {
            this._ivalue = db;
            this._depthFolder = depth;
            this._levelCmp = levelCmp;
            this._rootName = root;
            this._keyCode = keyCode;
        }

        public int toInt() {
            return this._ivalue;
        }

        public int getDepthFolder() {
            return this._depthFolder;
        }

        public String getRootName() {
            return this._rootName;
        }

        public String getKey() {
            return this._keyCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Family fromInt(int idx) {
            if (_map == null) {
                Object object = _mapLocker;
                synchronized (object) {
                    _map = new HashMap<Integer, Family>();
                    for (Family type : Family.values()) {
                        _map.put(type.toInt(), type);
                    }
                }
            }
            return _map.get(idx);
        }

        public static Comparator<Family> getComparator() {
            return __COMPARATOR_FAMILY;
        }

        static {
            _mapLocker = new Object();
            __COMPARATOR_FAMILY = new Comparator<Family>(){

                @Override
                public int compare(Family o1, Family o2) {
                    return o1._levelCmp - o2._levelCmp;
                }
            };
        }
    }
}

