/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao;

import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAO;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DAOFolder
extends DAO<DBFolder> {
    public static final String FAMILY_DEFAULT = "Default";
    private boolean _bAutoUpdateObject = true;
    public boolean _bAutoUpdateDepenties = true;
    HashSet<String> _cacheLogs = null;
    static final Pattern __VERSION_BTP = Pattern.compile("(.+);(([0-9]+)(\\.[0-9]+)?)$");

    public boolean isAutoUpdateObject() {
        return this._bAutoUpdateObject;
    }

    public DAOFolder setAutoUpdateObject(boolean auto) {
        this._bAutoUpdateObject = auto;
        return this;
    }

    public boolean isAutoUpdateDepenties() {
        return this._bAutoUpdateDepenties;
    }

    public DAOFolder setAutoUpdateDepenties(boolean auto) {
        this._bAutoUpdateDepenties = auto;
        return this;
    }

    public abstract DBFolder getRootID(String var1);

    public abstract boolean exist(long var1);

    public abstract List<DBFolder> findChildren(DBFolder var1);

    public abstract List<DBAccess> findAccesses(DBFolder var1);

    public abstract boolean refresh(DBFolder var1);

    public abstract void prepareCache();

    public abstract void updateCache(UpdateListener var1);

    public abstract void freezeCache(boolean var1);

    public void setCacheLogs(boolean cache) {
        if (this._cacheLogs != null == cache) {
            return;
        }
        this._cacheLogs = cache ? new HashSet() : null;
    }

    private void log(String cod, DBFolder rootFolder, String path, String msg) {
        StringBuilder sb = new StringBuilder(cod.length() + path.length() + 128);
        sb.append(cod).append(rootFolder.getFamily().toInt()).append("_").append(path);
        if (this._cacheLogs != null) {
            if (this._cacheLogs.contains(sb.toString())) {
                return;
            }
            this._cacheLogs.add(sb.toString());
        }
        _LOG.fine(sb.append(": ").append(msg).toString());
    }

    private DBFolder findChild(DBFolder dbFolder, String name) {
        List<DBFolder> children = dbFolder.getChildren();
        if (children == null) {
            children = this.findChildren(dbFolder);
        }
        if (children == null) {
            return null;
        }
        DBFolder find = null;
        for (int i = 0; find == null && i < children.size(); ++i) {
            if (!children.get(i).getName().equalsIgnoreCase(name)) continue;
            find = children.get(i);
        }
        return find;
    }

    public DBFolder findFolder(DBFolder rootFolder, String path, boolean withException) {
        Matcher matcher;
        DBFolder dbFolder = rootFolder;
        boolean bExceptSubFamily = false;
        boolean bExceptDefaultFamily = false;
        boolean bExceptVersion = false;
        boolean bExceptProject = false;
        boolean bOnlySlash = false;
        if (withException) {
            switch (dbFolder.getFamily()) {
                case TYPE: {
                    bExceptVersion = true;
                }
                case COMPONENT: 
                case EQUIPMENT: 
                case OPERATOR: {
                    bExceptSubFamily = true;
                    break;
                }
                case ATTRIBUTE: 
                case PARAMETER: {
                    bExceptDefaultFamily = true;
                    bExceptVersion = true;
                    break;
                }
                case BTP_MODEL: {
                    bOnlySlash = true;
                    bExceptVersion = true;
                    break;
                }
                case IMAG: 
                case CCF_MODEL: {
                    bExceptVersion = true;
                    break;
                }
                case PROJECT: {
                    bExceptProject = true;
                    break;
                }
            }
        }
        String lastName = null;
        boolean sameName = true;
        int cpt = 0;
        if (bOnlySlash && (matcher = __VERSION_BTP.matcher(path)).matches()) {
            path = matcher.group(1) + "/" + matcher.group(2);
        }
        StringTokenizer st = new StringTokenizer(path, bOnlySlash ? "/" : "/;", true);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (name.charAt(0) == '/' || name.charAt(0) == '\\' || name.charAt(0) == ';') continue;
            DBFolder find = this.findChild(dbFolder, name);
            if (find == null) {
                if (bExceptSubFamily && (cpt == 1 || sameName && cpt == 2)) {
                    this.log("R", rootFolder, path, "Recherche d'un dossier correspondant a la sous-famille '" + lastName + "' (Modele provenant de Cecilia 4.4).");
                    find = this.findChild(dbFolder, lastName);
                    if (find != null) {
                        find = this.findChild(find, name);
                    }
                } else if (bExceptDefaultFamily && cpt == 0) {
                    this.log("D", rootFolder, path, "Recherche d'un dossier correspondant a la famille 'Default' (Modele provenant de Cecilia 4.4).");
                    find = this.findChild(dbFolder, FAMILY_DEFAULT);
                    if (find != null) {
                        find = this.findChild(find, name);
                    }
                } else if (bExceptProject) {
                    this.log("P", rootFolder, path, "Recherche d'un dossier contenant potentiellement des caracteres interdits.");
                    StringBuilder testName = new StringBuilder(name.length() + 100).append(name);
                    while (st.hasMoreTokens()) {
                        testName.append(st.nextToken());
                        if (name.charAt(0) == '/' || name.charAt(0) == '\\' || name.charAt(0) == ';' || (find = this.findChild(dbFolder, testName.toString())) == null) continue;
                    }
                }
            }
            if (find == null) {
                _LOG.info("Le dossier reference par le chemin '" + path + "' n'est pas accessible au sein de la base.");
                return null;
            }
            dbFolder = find;
            sameName = sameName && (lastName == null || lastName.equals(name));
            lastName = name;
            ++cpt;
        }
        if (dbFolder.isModel() && bExceptVersion) {
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = this.findChildren(dbFolder);
            }
            if (children == null) {
                return null;
            }
            String name = "1";
            DBFolder find = null;
            for (int i = 0; find == null && i < children.size(); ++i) {
                if (!children.get(i).getName().equals(name)) continue;
                find = children.get(i);
            }
            if (find != null) {
                this.log("V", rootFolder, path, "La version '1' du modele a ete trouvee.");
                dbFolder = find;
            }
        }
        return dbFolder;
    }

    public DBFolder findFolder(String rootName, String refPath) {
        if (refPath == null) {
            throw new NullPointerException();
        }
        if (refPath.isEmpty()) {
            return null;
        }
        DBFolder dbFolder = this.getRootID(rootName);
        if (dbFolder == null) {
            return null;
        }
        return this.findFolder(dbFolder, refPath, true);
    }

    public DBFolder findFolder(long refID, String refPath, String rootName) {
        DBFolder dbFolder = null;
        DBFolder rootFolder = this.getRootID(rootName);
        if (refID != -1L && (dbFolder = (DBFolder)this.find(refID)) == null) {
            this.log("S", rootFolder, refPath, "ID (" + refID + ") invalide lors de la lecture d'un objet => utilisation du path en secours");
        }
        if (dbFolder == null) {
            if (rootFolder == null) {
                return null;
            }
            dbFolder = this.findFolder(rootFolder, refPath, refID == -1L);
        }
        return dbFolder;
    }

    public DBAccess.Right getAccessRight(DBFolder dbFolder, DBUser dbUser) {
        if (dbFolder.getAccesses() == null) {
            this.findAccesses(dbFolder);
        }
        return dbFolder.getAccessRight(dbUser);
    }

    public static interface UpdateListener {
        public void changeBegin();

        public boolean changeState(DBFolder var1);

        public void changeStateAndChildren(DBFolder var1, List<DBFolder> var2);

        public void changeEnd();

        public void refreshAll();
    }
}

