/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao;

import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.dao.DAO;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class DAOObjModel
extends DAO<DBObjModel> {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public abstract InputStream getBinaryStream(DBObjModel var1);

    private static String logReadToString(String msg) {
        _LOG.info(msg);
        return null;
    }

    private static String readToStringFromCompressedByte(DAOObjModel daoModel, DBObjModel model, String frm) {
        InputStream istream = daoModel.getBinaryStream(model);
        if (istream == null) {
            return DAOObjModel.logReadToString("[format=" + frm + "] Flux binaire illisible");
        }
        byte[] ibyte = DAOObjModel.convertFromCompressedByte(istream);
        if (ibyte == null) {
            return DAOObjModel.logReadToString("[format=" + frm + "] Flux binaire illisible");
        }
        String buffer = null;
        String encoding = model.getEncoding();
        if (encoding != null && !encoding.isEmpty()) {
            if (encoding.equals("ISO-8859-1")) {
                buffer = new String(ibyte, DBObjModel.getOcasCharset());
            } else if (encoding.equals("UTF-8")) {
                buffer = new String(ibyte, StandardCharsets.UTF_8);
            }
        }
        if (buffer == null) {
            buffer = new String(ibyte);
        }
        return buffer;
    }

    private static String readToStringFromByte(DAOObjModel daoModel, DBObjModel model, String frm) {
        InputStream istream = daoModel.getBinaryStream(model);
        if (istream == null) {
            return DAOObjModel.logReadToString("[format=" + frm + "] Flux binaire illisible");
        }
        byte[] ibyte = DAOObjModel.convertAsByte(istream);
        if (ibyte == null) {
            return DAOObjModel.logReadToString("[format=" + frm + "] Flux binaire illisible");
        }
        return new String(ibyte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(DAOObjModel daoModel, DBObjModel model) {
        String format = model.getFormat();
        if (format == null || format.isEmpty()) {
            if (model.getNature().equals("image")) {
                return "[Image] de taille : " + model.getSize();
            }
            if (model.getNature().equals("project.attribute.drive.average.approach")) {
                return DAOObjModel.readToStringFromByte(daoModel, model, "<empty>");
            }
            return DAOObjModel.readToStringFromCompressedByte(daoModel, model, "<empty>");
        }
        if (format.equals(DBObjModel.FORMAT_IMAGE_GIF) || format.equals(DBObjModel.FORMAT_IMAGE_JPG) || format.equals(DBObjModel.FORMAT_IMAGE_PNG)) {
            return "[Image] d'extention " + format + "et de taille : " + model.getSize();
        }
        if (format.equals("OCAS")) {
            return DAOObjModel.readToStringFromCompressedByte(daoModel, model, format);
        }
        if (format.equals("ZML")) {
            return DAOObjModel.readToStringFromCompressedByte(daoModel, model, format);
        }
        if (format.equals("XML")) {
            return DAOObjModel.readToStringFromCompressedByte(daoModel, model, format);
        }
        if (format.equals("JOS")) {
            return DAOObjModel.readToStringFromCompressedByte(daoModel, model, format);
        }
        if (format.equals("RAWTOHEX")) {
            InputStream istream = daoModel.getBinaryStream(model);
            if (istream == null) {
                return DAOObjModel.logReadToString("[format=RAWTOHEX] Flux binaire illisible");
            }
            String istr = DAOObjModel.convertWithFromRAWTOHEX(istream);
            if (istr == null) {
                return DAOObjModel.logReadToString("[format=RAWTOHEX] Flux binaire illisible");
            }
            return istr;
        }
        if (format.equals("RAW")) {
            return DAOObjModel.readToStringFromByte(daoModel, model, "RAW");
        }
        if (format.equals("ARBOR")) {
            if (model.getNature().equals("tree.dag") || model.getNature().startsWith("tree.def") || model.getNature().startsWith("dsf.config")) {
                return DAOObjModel.readToStringFromCompressedByte(daoModel, model, format);
            }
        } else if (format.equals("FRB")) {
            if (model.getNature().equals("attribute")) {
                InputStream istream = daoModel.getBinaryStream(model);
                if (istream == null) {
                    return DAOObjModel.logReadToString("[format=FRB] Flux binaire illisible");
                }
                String istr = DAOObjModel.convertWithByteArray(istream);
                if (istr == null) {
                    return DAOObjModel.logReadToString("[format=FRB] Flux binaire illisible");
                }
                return istr;
            }
        } else if (format.equals("ZIP")) {
            ZipInputStream istream = new ZipInputStream(daoModel.getBinaryStream(model));
            StringBuilder buffer = new StringBuilder();
            try {
                ZipEntry ze = null;
                while ((ze = istream.getNextEntry()) != null) {
                    buffer.append("Entry: ").append(ze.getName()).append("\n");
                    if (ze.getComment() != null) {
                        buffer.append("  Comment: ").append(ze.getComment()).append("\n");
                    }
                    if (ze.getSize() > 0L) {
                        buffer.append("  Size: ").append(ze.getSize()).append("\n");
                    }
                    if (ze.getCompressedSize() > 0L) {
                        buffer.append("  CompressedSize: ").append(ze.getCompressedSize()).append("\n");
                    }
                    if (ze.getCrc() != -1L) {
                        buffer.append("  Crc: ").append(ze.getCrc()).append("\n");
                    }
                    if (ze.getCreationTime() != null) {
                        buffer.append("  CreationTime: ").append(ze.getCreationTime()).append("\n");
                    }
                    if (ze.getTime() != -1L) {
                        buffer.append("  Time: ").append(ze.getTime()).append("\n");
                    }
                    buffer.append("  Content: [\n");
                    if (ze.getName().equals("Information")) {
                        DataInputStream input = new DataInputStream(istream);
                        try {
                            try {
                                while (true) {
                                    String key = input.readUTF();
                                    String value = input.readUTF();
                                    buffer.append(key).append(" = ").append(value).append("\n");
                                }
                            }
                            catch (EOFException key) {
                                istream.closeEntry();
                            }
                        }
                        catch (Throwable throwable) {
                            istream.closeEntry();
                            throw throwable;
                        }
                    }
                    try {
                        BufferedReader in = new BufferedReader(new InputStreamReader(istream));
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            buffer.append(line).append("\n");
                        }
                    }
                    finally {
                        istream.closeEntry();
                    }
                    buffer.append("]\n\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return buffer.toString();
        }
        _LOG.info("Pas de lecture pour le modele : " + model);
        return null;
    }

    public static String asHex(byte[] buf) {
        char[] chars = new char[2 * buf.length];
        for (int i = 0; i < buf.length; ++i) {
            chars[2 * i] = HEX_CHARS[(buf[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[buf[i] & 0xF];
        }
        return new String(chars);
    }

    public static void convertHex(byte[] buffer, int offset, int len, StringBuilder result) {
        for (int i = offset; i < offset + len; ++i) {
            if (buffer[i] == 0) {
                ++i;
            }
            if (i >= offset + len) continue;
            result.append((char)buffer[i]);
        }
    }

    public static String convertWithFromRAWTOHEX(InputStream stream) {
        try {
            int len;
            StringBuilder sb = new StringBuilder();
            byte[] buffer = new byte[128];
            while ((len = stream.read(buffer)) != -1) {
                DAOObjModel.convertHex(buffer, 0, len, sb);
            }
            return sb.toString();
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Probleme dans le decodage du stream", e);
            return null;
        }
    }

    public static byte[] convertAsByte(InputStream stream) {
        try {
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] bytes = new byte[0x100000];
            while ((len = stream.read(bytes)) != -1) {
                out.write(bytes, 0, len);
            }
            stream.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Probleme dans le decodage du stream", e);
            return null;
        }
    }

    public static byte[] convertFromCompressedByte(InputStream data) {
        try {
            int len;
            InflaterInputStream in = new InflaterInputStream(data, new Inflater());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] bytes = new byte[0x100000];
            while ((len = in.read(bytes)) != -1) {
                out.write(bytes, 0, len);
            }
            in.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Probleme dans le decodage du stream", e);
            return null;
        }
    }

    public static byte[] convertToCompressedByte(InputStream in) {
        try {
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DeflaterOutputStream zipOut = new DeflaterOutputStream((OutputStream)out, new Deflater(9));
            byte[] bytes = new byte[0x100000];
            while ((len = in.read(bytes)) != -1) {
                zipOut.write(bytes, 0, len);
            }
            in.close();
            zipOut.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Probleme dans le decodage du stream", e);
            return null;
        }
    }

    public static String convertWithByteArray(InputStream stream) {
        try {
            int size;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2000);
            byte[] byteArray = new byte[2000];
            while ((size = stream.read(byteArray, 0, 2000)) != -1) {
                baos.write(byteArray, 0, size);
            }
            return baos.toString();
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Probleme dans le decodage du stream", e);
            return null;
        }
    }
}

