/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ConfigProperty;
import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.core.cecilia.dbgui.LicenseManager;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SQLConnectionList {
    private static Logger _LOG = Logger.getLogger(SQLConnectionList.class.getPackage().getName());
    public static final String PROP_DB_QUICKLAUNCH = "cecilia.db.QuickLaunch";
    public static final String PROP_DB_DEFAULTDB = "cecilia.db.DefaultDB";
    public static final String PROP_DEF_DB_DATAFILE = "./database.ini";
    public static final String PROP_DB_DATAFILE = "cecilia.db.Datafile";
    File _databaseFile;
    boolean _canBeModify;
    Map<String, Item> _connects;
    Item _default;
    int _timeOut;
    protected static final String XML_ELT_ROOT = "database-select";
    protected static final String XML_ATT_DEFAULT = "default";
    protected static final String XML_ATT_TIMEOUT = "time-out";
    protected static final String XML_ELT_DB = "database";
    protected static final String XML_ELT_DB_PROPERTY = "property";
    protected static final String XML_ATT_NAME = "name";
    protected static final String XML_ATT_TYPE = "type";
    protected static final String XML_ATT_CONNECT = "connect";
    protected static final String XML_ATT_VALUE = "value";

    public SQLConnectionList(File dbFile) {
        this._databaseFile = dbFile;
        this._connects = new LinkedHashMap<String, Item>();
        this._default = null;
        this._canBeModify = !this._databaseFile.exists() || this._databaseFile.canWrite();
        this._timeOut = 0;
    }

    public Item getSQLConnection(String name) {
        return this._connects.get(name);
    }

    public Item getDefaultSQLConnection() {
        return this._default;
    }

    public Item getFirstSQLConnection() {
        if (this._connects.size() > 0) {
            return this._connects.values().iterator().next();
        }
        return null;
    }

    public boolean canBeModify() {
        return this._canBeModify;
    }

    public int getTimeOut() {
        return this._timeOut;
    }

    public Collection<Item> getItems() {
        return this._connects.values();
    }

    public boolean addItem(Item item) {
        Item prev = this._connects.get(item.getName());
        if (prev != null && item != prev) {
            return false;
        }
        this._connects.put(item.getName(), item);
        return true;
    }

    public boolean replaceItem(Item oldItem, Item newItem) {
        Item prev = this._connects.get(oldItem.getName());
        if (prev == null) {
            return false;
        }
        if (!oldItem.getName().equals(newItem.getName())) {
            this._connects.remove(oldItem.getName());
        }
        this._connects.put(newItem.getName(), newItem);
        return true;
    }

    public boolean delItem(Item item) {
        Item cur = this._connects.remove(item.getName());
        if (cur != null && cur != item) {
            _LOG.fine("SQLConnectionList::delItem with item not in mapConnect");
        }
        return cur != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDataConnections() throws IOException {
        if (!this._databaseFile.exists()) {
            _LOG.finer("Don't exist database file : " + this._databaseFile);
            return;
        }
        if (!this._databaseFile.canRead()) {
            _LOG.info("Can't read database file : " + this._databaseFile);
            return;
        }
        char[] starter = new char[32];
        try (FileReader inReader = null;){
            inReader = new FileReader(this._databaseFile);
            inReader.read(starter);
        }
        try (FileInputStream inStream = null;){
            inStream = new FileInputStream(this._databaseFile);
            if (new String(starter).startsWith("<?xml")) {
                this.loadXML(inStream);
            } else {
                SQLConnection readConnect = this.readOldFileConnection(inStream);
                Item dbItem = new Item(readConnect, XML_ATT_DEFAULT);
                readConnect.setName(dbItem.getName());
                this._connects.put(dbItem._name, dbItem);
                this._default = dbItem;
            }
        }
    }

    public void changeBeforeUse() {
        boolean change = false;
        for (Item item : this._connects.values()) {
            SQLConnection sqlConnection = item.getSQLConnection();
            if (!sqlConnection.changeBeforeUse()) continue;
            item.setDataConnect(sqlConnection);
            change = true;
        }
        if (change && this.canBeModify()) {
            this.writeDatabaseFile();
        }
    }

    public void writeDatabaseFile() {
        Writer output = null;
        try {
            try {
                output = new BufferedWriter(new FileWriter(this._databaseFile));
                this.saveXML(output);
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (IOException e) {
            _LOG.log(Level.FINE, "Exception during write databases definition file", e);
        }
    }

    private void writeOldFileConnection(SQLConnection dbdc, FileWriter writer) throws IOException {
        String crlf = System.getProperty("line.separator", "\n");
        for (Map.Entry<String, String> entry : dbdc.getProperties().entrySet()) {
            String key = entry.getKey();
            writer.write(key);
            writer.write(" = ");
            String value = entry.getValue();
            if (key.equals("db.srv.password")) {
                value = LicenseManager.cryptData(value);
            }
            writer.write(value);
            writer.write(crlf);
        }
    }

    private SQLConnection readOldFileConnection(InputStream inStream) throws IOException {
        SQLConnection.DBType type = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        BufferedReader read = new BufferedReader(new InputStreamReader(inStream));
        String line = null;
        int cptLine = 1;
        while ((line = read.readLine()) != null) {
            int pos = line.indexOf("=");
            if (pos < 1 || pos >= line.length() - 1) {
                throw new IOException("Syntax error at line " + (cptLine + 1));
            }
            String key = line.substring(0, pos).trim();
            String value = line.substring(pos + 1).trim();
            if (key.equals("db.product") && (type = SQLConnection.DBType.valueOf(value)) == null) {
                throw new IOException("Unknow type value : " + value);
            }
            if (key.equals("db.srv.password")) {
                value = LicenseManager.decryptData(value);
                properties.put(key, value);
            } else {
                properties.put(key, value);
            }
            ++cptLine;
        }
        read.close();
        if (type == null) {
            throw new IOException("Undefine type value");
        }
        return new SQLConnection(type, properties);
    }

    public void saveXML(Appendable output) throws IOException {
        output.append("<?xml version=\"1.0\" ?>\n");
        output.append("<database-select version=\"1.0\"");
        if (this._default != null) {
            output.append(" default=\"");
            Util.appendForXml(output, this._default._name).append("\"");
        }
        if (this._timeOut > 0) {
            output.append(" time-out=\"");
            Util.appendForXml(output, Integer.toString(this._timeOut)).append("\"");
        }
        output.append(">\n");
        for (Item item : this._connects.values()) {
            output.append("  <database");
            output.append(" name=\"");
            Util.appendForXml(output, item._name).append("\"");
            output.append(" type=\"");
            Util.appendForXml(output, item._type.toString()).append("\"");
            output.append(" connect=\"");
            Util.appendForXml(output, item._connectString).append("\"");
            output.append(">\n");
            for (Map.Entry<String, String> prop : item._properties.entrySet()) {
                output.append("    <property");
                String key = prop.getKey();
                String value = prop.getValue();
                if (key.equals("db.srv.password")) {
                    value = LicenseManager.cryptData(value);
                }
                output.append(" name=\"");
                Util.appendForXml(output, key).append("\"");
                output.append(" value=\"");
                Util.appendForXml(output, value).append("\"");
                output.append("/>\n");
            }
            output.append("  </database>\n");
        }
        output.append("</database-select>\n");
    }

    public void loadXML(InputStream inStream) throws IOException {
        class ConfigHandler
        extends DefaultHandler {
            Item _currentItem = null;
            String _defaultName = null;
            Locator _locator;

            ConfigHandler() {
            }

            public Locator getLocator() {
                return this._locator;
            }

            @Override
            public void setDocumentLocator(Locator locator) {
                this._locator = locator;
                super.setDocumentLocator(locator);
            }

            private String getValAttribute(Attributes attrs, String name, String entity) throws SAXException {
                return this.getValAttribute(attrs, name, entity, false);
            }

            private String getValAttribute(Attributes attrs, String name, String entity, boolean optionnal) throws SAXException {
                int idx = attrs.getIndex(name);
                if (idx == -1) {
                    if (optionnal) {
                        return null;
                    }
                    throw new SAXException("No attribute '" + name + "' for element '" + entity + "' !");
                }
                return attrs.getValue(idx);
            }

            @Override
            public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
                String eltName;
                if (attrs == null) {
                    return;
                }
                String string = eltName = "".equals(sName) ? qName : sName;
                if (eltName.equalsIgnoreCase(SQLConnectionList.XML_ELT_DB)) {
                    String name = this.getValAttribute(attrs, SQLConnectionList.XML_ATT_NAME, SQLConnectionList.XML_ELT_DB);
                    String type = this.getValAttribute(attrs, SQLConnectionList.XML_ATT_TYPE, SQLConnectionList.XML_ELT_DB);
                    SQLConnection.DBType dbType = SQLConnection.DBType.valueOf(type);
                    if (dbType == null) {
                        throw new SAXException("Unknow type value '" + type + "' for element '" + SQLConnectionList.XML_ELT_DB + "' !");
                    }
                    String connect = this.getValAttribute(attrs, SQLConnectionList.XML_ATT_CONNECT, SQLConnectionList.XML_ELT_DB);
                    this._currentItem = new Item(name, dbType, connect);
                } else if (eltName.equalsIgnoreCase(SQLConnectionList.XML_ELT_DB_PROPERTY)) {
                    String key = this.getValAttribute(attrs, SQLConnectionList.XML_ATT_NAME, SQLConnectionList.XML_ELT_DB_PROPERTY);
                    String value = this.getValAttribute(attrs, SQLConnectionList.XML_ATT_VALUE, SQLConnectionList.XML_ELT_DB_PROPERTY);
                    if (key.equals("db.srv.password")) {
                        value = LicenseManager.decryptData(value);
                    }
                    if (this._currentItem != null) {
                        this._currentItem._properties.put(key, value);
                    }
                } else if (eltName.equalsIgnoreCase(SQLConnectionList.XML_ELT_ROOT)) {
                    this._defaultName = this.getValAttribute(attrs, SQLConnectionList.XML_ATT_DEFAULT, SQLConnectionList.XML_ELT_ROOT, true);
                    String to = this.getValAttribute(attrs, SQLConnectionList.XML_ATT_TIMEOUT, SQLConnectionList.XML_ELT_ROOT, true);
                    if (to != null) {
                        try {
                            SQLConnectionList.this._timeOut = Integer.parseInt(to);
                        }
                        catch (NumberFormatException e) {
                            throw new SAXException("Attribute 'time-out' is not an integer !");
                        }
                    }
                }
            }

            @Override
            public void endElement(String uri, String sName, String qName) throws SAXException {
                String eltName;
                String string = eltName = "".equals(sName) ? qName : sName;
                if (eltName.equalsIgnoreCase(SQLConnectionList.XML_ELT_DB)) {
                    SQLConnectionList.this._connects.put(this._currentItem._name, this._currentItem);
                    this._currentItem = null;
                } else if (eltName.equalsIgnoreCase(SQLConnectionList.XML_ELT_ROOT) && this._defaultName != null) {
                    SQLConnectionList.this._default = SQLConnectionList.this._connects.get(this._defaultName);
                }
            }
        }
        ConfigHandler handler = null;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            handler = new ConfigHandler();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(inStream, (DefaultHandler)handler);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Locator loc;
            StringBuilder sb = new StringBuilder();
            sb.append("SAX Parser Exception\n");
            if (handler != null && (loc = handler.getLocator()) != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            throw new IOException(sb.toString(), e);
        }
    }

    public static class Item {
        String _name;
        SQLConnection.DBType _type;
        String _connectString;
        Map<String, String> _properties;
        SQLConnection _dataConnect;
        StringBuffer _errors;

        public Item(SQLConnection data, String name) {
            this._name = name;
            this._dataConnect = data;
            this._type = data.getType();
            this._connectString = data.getConnectionUrl();
            this._properties = new HashMap<String, String>(data.getProperties());
            this._errors = new StringBuffer();
        }

        Item(String name, SQLConnection.DBType type, String connectString) {
            this._name = name;
            this._dataConnect = null;
            this._type = type;
            this._connectString = connectString;
            this._properties = new HashMap<String, String>();
            this._errors = new StringBuffer();
        }

        public boolean verifyCompatibility() {
            if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && this._type != SQLConnection.DBType.H2) {
                _LOG.info("Demonstration only with H2 database");
                return false;
            }
            try {
                Class.forName(this._type.getDriver());
            }
            catch (Exception e) {
                _LOG.info("Error during load JDBC driver for database: " + this._name);
                return false;
            }
            if ((this._type == SQLConnection.DBType.Access || this._type == SQLConnection.DBType.ODBC) && ConfigProperty.getJVMArch().equals("x64")) {
                _LOG.info("Error compatibility 64 bits for database: " + this._name);
                return false;
            }
            return true;
        }

        public SQLConnection getSQLConnection() {
            if (this._dataConnect == null) {
                this._dataConnect = new SQLConnection(this._type, this._properties);
            }
            this._dataConnect.setName(this._name);
            return this._dataConnect;
        }

        public void setDataConnect(SQLConnection data) {
            this._dataConnect = data;
            this._type = data.getType();
            this._connectString = data.getConnectionUrl();
            this._properties = new HashMap<String, String>(data.getProperties());
            this._errors = new StringBuffer();
        }

        public void setError(String msg) {
            this._errors.delete(0, this._errors.length());
            this._errors.append(msg).append("\n");
        }

        public String getError() {
            if (this._errors == null || this._errors.length() == 0) {
                return null;
            }
            return this._errors.toString();
        }

        public String getStringConnection() {
            return this._connectString;
        }

        public String getName() {
            return this._name;
        }
    }
}

