/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IWrap;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import com.dassault.cecilia.db.dao.sql.def.DefaultObjModel;
import com.dassault.cecilia.db.dao.sql.def.DefaultObjProperty;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class DefaultObject
extends DAOObject {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;
    Map<DBObject, IWrap> _cacheWrap = new HashMap<DBObject, IWrap>();
    int _statNbrGet = 0;
    int _statNbrGetTrue = 0;
    int _statNbrPut = 0;
    int _statNbrPutOld = 0;

    public DefaultObject(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createObjectIntoTable(DBObject obj) throws SQLException {
        boolean result;
        block18: {
            result = false;
            PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.OBJECTS + " (obj_flags, obj_ses_id, obj_time_update) VALUES (?, ?, " + this._factory.getSQLFunctionNow() + ")", 1);
            this._factory.initStatement(prepare);
            try {
                prepare.setInt(1, obj.getFlags());
                DBSession session = obj.getLockedSession();
                if (session == null) {
                    prepare.setNull(2, -5);
                } else {
                    prepare.setLong(2, session.getID());
                }
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) break block18;
                ResultSet resultSet = prepare.getGeneratedKeys();
                try {
                    if (resultSet.next()) {
                        obj.setID(resultSet.getLong(1));
                        result = true;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!result) {
            throw new SQLException("Internal error during INSERT INTO " + SQLTable.OBJECTS + ": " + obj.getFolder().getID());
        }
    }

    protected boolean createInTransaction(DBObject obj) throws SQLException {
        Collection<DBObjModel> models;
        boolean result = true;
        this.createObjectIntoTable(obj);
        Collection<DBObjProperty> properties = obj.getProperties();
        if (properties.size() > 0) {
            DefaultObjProperty daoObjProp = this._factory.createObjPropertyDAO();
            for (DBObjProperty prop : properties) {
                prop.setObject(obj);
                result &= daoObjProp.createInTransaction(prop);
            }
        }
        if ((models = obj.getModels()).size() > 0) {
            DefaultObjModel daoModel = this._factory.createObjModelDAO();
            for (DBObjModel model : models) {
                model.setObject(obj);
                result &= daoModel.createInTransaction(model);
            }
        }
        return result;
    }

    @Override
    public DBObject create(DBObject obj) {
        boolean result = true;
        try {
            this._factory.beginTransaction(false);
            result = this.createInTransaction(obj);
            this._factory.endTransaction();
        }
        catch (Exception e) {
            result = false;
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultObject::create(" + obj.getID() + ")");
        }
        if (result) {
            return this.find(obj.getID());
        }
        return null;
    }

    protected boolean deleteInTransaction(DBObject obj) throws SQLException {
        Statement prepare = null;
        try {
            prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.OBJECTS + " WHERE obj_id = ?");
            this._factory.initStatement(prepare);
            prepare.setLong(1, obj.getID());
            int nbrChg = prepare.executeUpdate();
            if (nbrChg == 1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            DefaultFactory._LOG.info("SQLException during DefaultObject::delete(" + obj.getID() + ")");
            throw e;
        }
        finally {
            try {
                if (prepare != null) {
                    prepare.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Override
    public boolean delete(DBObject obj) {
        try {
            return this.deleteInTransaction(obj);
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObject::delete(" + obj.getID() + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultObject::delete(" + obj.getID() + ")");
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    protected boolean updateInTransaction(DBObject obj) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean update(DBObject obj) {
        try {
            boolean result = true;
            this._factory.beginTransaction(false);
            result = this.updateInTransaction(obj);
            this._factory.endTransaction();
            return result;
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultObject::update(" + obj.getID() + ")");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBObject load(long id, DBObject obj) throws SQLException {
        PreparedStatement prepare = this._connect.prepareStatement("SELECT obj_flags, obj_ses_id, obj_time_update FROM " + SQLTable.OBJECTS + " WHERE obj_id = ? ", 1004, 1007);
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, id);
            ResultSet resultSet = prepare.executeQuery();
            try {
                if (resultSet.first()) {
                    if (obj == null) {
                        obj = new DBObject(id);
                    }
                    obj.setFlags(resultSet.getInt(1));
                    long sesID = resultSet.getLong(2);
                    if (sesID > 0L) {
                        DBSession session = this._factory.createSessionDAO().find(sesID);
                        if (session != null) {
                            obj.setLocked(session);
                        } else {
                            DefaultFactory._LOG.warning("Objet verouille par une session qui n'existe pas : SessionID=" + sesID + ", ObjectID=" + id);
                        }
                    } else {
                        obj.setUnlocked();
                    }
                    obj.setTimeUpdate(resultSet.getTimestamp(3).getTime());
                } else {
                    obj = null;
                }
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        return obj;
    }

    @Override
    public DBObject find(long id) {
        DBObject obj = null;
        try {
            obj = this.load(id, null);
            if (obj != null) {
                Collection<DBObjProperty> properties = this._factory.createObjPropertyDAO().findAll(obj);
                if (properties != null) {
                    obj.setProperties(properties);
                } else {
                    obj = null;
                }
            }
            if (obj != null) {
                Collection<DBObjModel> models = this._factory.createObjModelDAO().findAll(obj);
                if (models != null) {
                    obj.setModels(models);
                } else {
                    obj = null;
                }
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObject::find(" + id + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultObject::find(" + id + ")");
        }
        return obj;
    }

    protected boolean refresh(DBObject obj) {
        boolean result = false;
        try {
            long time = obj.getTimeUpdate();
            obj = this.load(obj.getID(), obj);
            if (obj != null && obj.getTimeUpdate() != time) {
                result = true;
                this._cacheWrap.remove(obj);
                Collection<DBObjProperty> properties = this._factory.createObjPropertyDAO().findAll(obj);
                if (properties != null) {
                    obj.setProperties(properties);
                }
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObject::refresh(" + obj.getID() + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultObject::refresh(" + obj.getID() + ")");
        }
        return result;
    }

    @Override
    public IWrap getWrap(DBObject object) {
        if (Boolean.getBoolean("cecilia.db.doa.NoCacheWrap")) {
            return null;
        }
        IWrap wrap = this._cacheWrap.get(object);
        ++this._statNbrGet;
        if (wrap != null) {
            DefaultFactory._LOG.finest("getWrap(" + object.getFolder().getRefPath() + ") => Exist");
            ++this._statNbrGetTrue;
        } else {
            DefaultFactory._LOG.finest("getWrap(" + object.getFolder().getRefPath() + ") => Null");
        }
        return wrap;
    }

    @Override
    public boolean putWrap(DBObject object, IWrap wrap) {
        ++this._statNbrPut;
        IWrap oldWrap = this._cacheWrap.put(object, wrap);
        if (oldWrap != null) {
            ++this._statNbrPutOld;
            DefaultFactory._LOG.finest("putWrap(" + object.getFolder().getRefPath() + ", " + (wrap == null ? "Null" : "Exist") + ") : Crush old wrap");
        } else {
            DefaultFactory._LOG.finest("putWrap(" + object.getFolder().getRefPath() + ", " + (wrap == null ? "Null" : "Exist") + ")");
        }
        return true;
    }

    @Override
    public void clearWraps() {
        this._cacheWrap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(DBObject obj, DBSession session) {
        if (!session.isCurrent()) {
            DefaultFactory._LOG.warning("Impossible de verrouiller un objet avec une session non courante");
            return false;
        }
        DBSession curSession = obj.getLockedSession();
        if (curSession != null) {
            if (curSession.equals(session)) {
                DefaultFactory._LOG.info("Objet deja verouille par la meme session");
                return true;
            }
            DefaultFactory._LOG.warning("Objet deja verouille par une autre session : " + curSession);
            return false;
        }
        DefaultFactory._LOG.finer("Verrouillage en BdD de '" + obj.getFolder().getRefPath() + "' par " + session.getUser().getLogin());
        int nbrUpdate = -1;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.OBJECTS + " SET obj_ses_id = ? WHERE obj_id = ? AND obj_ses_id IS NULL");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, session.getID());
                prepare.setLong(2, obj.getID());
                nbrUpdate = prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            if (nbrUpdate == 1) {
                obj.setLocked(session);
                this._factory.createFolderDAO().updateTimeUpdate(obj.getFolder());
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObject::lock(" + obj.getID() + "," + session + ")");
        }
        if (nbrUpdate != 1) {
            DefaultFactory._LOG.warning("Probleme rencontre lors du verouillage de l'objet : nbrUpdate=" + nbrUpdate);
        }
        return nbrUpdate == 1;
    }

    @Override
    public boolean unlock(DBObject obj, DBSession session) {
        if (!session.isCurrent()) {
            DefaultFactory._LOG.warning("Impossible de deverrouiller un objet avec une session non courante");
            return false;
        }
        DBSession curSession = obj.getLockedSession();
        if (curSession == null) {
            DefaultFactory._LOG.warning("Impossible de deverrouiller un objet deja deverrouiller");
            return false;
        }
        if (!curSession.equals(session)) {
            DefaultFactory._LOG.info("Objet verrouille par une autre session : " + curSession);
            return false;
        }
        return this.doUnlock(obj, session);
    }

    @Override
    public boolean unlock(DBObject obj, DBUser user) {
        DBSession curSession = obj.getLockedSession();
        if (curSession == null) {
            DefaultFactory._LOG.warning("Impossible de deverrouiller un objet deja deverrouiller");
            return false;
        }
        if (curSession.isActive()) {
            DefaultFactory._LOG.info("Objet verrouille par une session encore active : " + curSession);
            return false;
        }
        if (!curSession.getUser().equals(user)) {
            DefaultFactory._LOG.info("Objet verrouille par un autre utilisateur : " + curSession);
            return false;
        }
        return this.doUnlock(obj, curSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUnlock(DBObject obj, DBSession session) {
        DefaultFactory._LOG.finer("D\u00e9verrouillage en BdD de '" + obj.getFolder().getRefPath() + "' par " + session.getUser().getLogin());
        int nbrUpdate = -1;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.OBJECTS + " SET obj_ses_id = NULL WHERE obj_id = ? AND obj_ses_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                prepare.setLong(2, session.getID());
                nbrUpdate = prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            if (nbrUpdate == 1) {
                obj.setUnlocked();
                this._factory.createFolderDAO().updateTimeUpdate(obj.getFolder());
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObject::lock(" + obj.getID() + "," + session + ")");
        }
        if (nbrUpdate != 1) {
            DefaultFactory._LOG.warning("Probleme rencontre lors du deverouillage de l'objet : nbrUpdate=" + nbrUpdate);
        }
        return nbrUpdate == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFreeze(DBObject obj, boolean freeze) {
        boolean oldFreeze = obj.isFreeze();
        if (oldFreeze == freeze) {
            DefaultFactory._LOG.warning("L'objet est deja " + (freeze ? "fige" : "normal"));
            return false;
        }
        int nbrUpdate = -1;
        try {
            if (freeze) {
                obj.setBinFlag(2);
            } else {
                obj.unsetBinFlag(2);
            }
            PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.OBJECTS + " SET obj_flags = ? WHERE obj_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getFlags());
                prepare.setLong(2, obj.getID());
                nbrUpdate = prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObject::setFreeze(" + obj.getID() + "," + freeze + ")");
        }
        return nbrUpdate == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFreeze(DBObject obj) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT obj_flags FROM " + SQLTable.OBJECTS + " WHERE obj_id = ? ", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (!resultSet.first()) return false;
                    int flag = resultSet.getInt(1);
                    boolean bl = (flag & 2) != 0;
                    return bl;
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObject::isFreeze(" + obj.getID() + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isLockBy(DBObject obj, DBSession session) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT obj_ses_id FROM " + SQLTable.OBJECTS + " WHERE obj_id = ? ", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (!resultSet.first()) return false;
                    boolean bl = resultSet.getLong(1) == session.getID();
                    return bl;
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObject::isLockBy(" + obj.getID() + ")");
        }
        return false;
    }

    public void logStats() {
        if (this._statNbrGet == 0) {
            return;
        }
        DefaultFactory._LOG.fine("Cache wrap:[" + this._statNbrGet + ";" + this._statNbrGetTrue + ";" + this._statNbrPut + ";" + this._statNbrPutOld + "]");
    }
}

