/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.xml;

import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IWrap;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.db.dao.xml.DAOImportXmlFactory;
import com.dassault.cecilia.db.dao.xml.DAOImportXmlRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DAOImportXmlObject
extends DAOObject {
    protected DAOImportXmlFactory _factory = null;
    Map<Long, DBObject> _cacheObject = new HashMap<Long, DBObject>();
    Map<DBObject, IWrap> _cacheWrap = new HashMap<DBObject, IWrap>();

    public DAOImportXmlObject(DAOImportXmlFactory factory) {
        this._factory = factory;
    }

    @Override
    public DBObject create(DBObject obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean delete(DBObject obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean update(DBObject obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBObject find(long id) {
        return this._cacheObject.get(id);
    }

    @Override
    public IWrap getWrap(DBObject object) {
        if (object == null) {
            DAOImportXmlFactory._LOG.finest("getWrap(null) => ???");
            return null;
        }
        IWrap wrap = this._cacheWrap.get(object);
        if (wrap != null) {
            DAOImportXmlFactory._LOG.finest("getWrap(" + object.getFolder().getRefPath() + ") => Exist");
        } else {
            DAOImportXmlFactory._LOG.finest("getWrap(" + object.getFolder().getRefPath() + ") => Null");
        }
        return wrap;
    }

    @Override
    public boolean putWrap(DBObject object, IWrap wrap) {
        IWrap oldWrap = this._cacheWrap.put(object, wrap);
        if (oldWrap != null) {
            DAOImportXmlFactory._LOG.finest("putWrap(" + object.getFolder().getRefPath() + ", " + (wrap == null ? "Null" : "Exist") + ") : Crush old wrap");
        } else {
            DAOImportXmlFactory._LOG.finest("putWrap(" + object.getFolder().getRefPath() + ", " + (wrap == null ? "Null" : "Exist") + ")");
        }
        this._cacheObject.put(object.getID(), object);
        Collection<DBRelation> dbRelations = wrap.getUseRelations();
        if (dbRelations != null && !dbRelations.isEmpty()) {
            DAOImportXmlRelation daoRelation = this._factory.createRelationDAO();
            daoRelation.putUseRelation(object.getFolder(), dbRelations);
        }
        return true;
    }

    @Override
    public void clearWraps() {
        DAOImportXmlFactory._LOG.severe("Clear Wraps in DAOImportXML !!");
    }

    @Override
    public boolean lock(DBObject obj, DBSession session) {
        if (obj.isLocked()) {
            return false;
        }
        obj.setLocked(session);
        return true;
    }

    @Override
    public boolean unlock(DBObject obj, DBSession session) {
        if (!obj.isLocked()) {
            return false;
        }
        if (obj.getLockedSession().equals(session)) {
            obj.setUnlocked();
            return true;
        }
        return false;
    }

    @Override
    public boolean unlock(DBObject obj, DBUser user) {
        if (!obj.isLocked()) {
            return false;
        }
        if (obj.getLockedSession().getUser().getID() == user.getID()) {
            obj.setUnlocked();
            return true;
        }
        return false;
    }

    @Override
    public boolean setFreeze(DBObject obj, boolean freeze) {
        return false;
    }

    @Override
    public boolean isFreeze(DBObject obj) {
        return obj.isBinFlag(2);
    }

    @Override
    public boolean isLockBy(DBObject obj, DBSession session) {
        if (!obj.isLocked()) {
            return false;
        }
        return obj.getLockedSession().equals(session);
    }
}

