/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.xml;

import com.dassault.cecilia.db.DBObjModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBObjModelBytes
extends DBObjModel {
    private static Logger _LOG = Logger.getLogger(DBObjModelBytes.class.getPackage().getName());
    byte[] _bytes;

    public DBObjModelBytes(byte[] stream) {
        this._bytes = stream;
    }

    public DBObjModelBytes(DBObjModel src) {
        super(src);
        if (src instanceof DBObjModelBytes) {
            DBObjModelBytes srcBytes = (DBObjModelBytes)src;
            this._bytes = new byte[srcBytes._bytes.length];
            System.arraycopy(srcBytes._bytes, 0, this._bytes, 0, this._bytes.length);
        } else {
            InputStream stream = src.getStreamToSave();
            if (stream != null && stream instanceof ByteArrayInputStream) {
                int size = (int)src.getSize();
                this._bytes = new byte[size];
                ByteArrayInputStream input = (ByteArrayInputStream)stream;
                try {
                    int len = input.read(this._bytes);
                    if (len != size) {
                        _LOG.info("La taille du buffer semble plus petite que la taille declare");
                    }
                    if (input.read(new byte[16]) > 0) {
                        _LOG.severe("La taille du buffer semble plus grande que la taille declare : risque de perte de donnee");
                    }
                }
                catch (IOException e) {
                    _LOG.log(Level.WARNING, "Exception lors de la copie d'un DBObjModel: " + src, e);
                }
            }
        }
    }

    byte[] getBytes() {
        return this._bytes;
    }

    @Override
    public long getSize() {
        return this._bytes.length;
    }
}

