/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ccf.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.CTextFieldWithCallback;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.general.law.gui.LawPanel;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapFrameEdit;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CCFFrameEdit
extends DBWrapFrameEdit {
    double[] _verifyFactors;
    LawPanel _ctrlLaw;
    JComboBox _ctrlCCFType;
    JLabel[] _ctrlCCFLabels;
    JTextFieldForCCF[] _ctrlCCFArgs;

    @Override
    protected String getDBLabel() {
        return ResMsgArbor.getString("VOC_CCF_MODEL");
    }

    @Override
    public CCF getDBWrap() {
        return (CCF)super.getDBWrap();
    }

    public CCFFrameEdit(CCF dbCcf, CeciliaAppl appl) {
        super(dbCcf.getCopy(), appl);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createCenterPanel(), "Center");
        this.getContentPane().add(this.createAndPlugLogsButtonAt(this.createSaveAndClosePanel()), "South");
        this.pack();
        this.refreshControl();
        this.setModified(false);
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (this._ctrlLaw.isModified()) {
            return true;
        }
        CCF.CCFType sel = (CCF.CCFType)((Object)this._ctrlCCFType.getSelectedItem());
        if (sel != null) {
            int limit = 4;
            if (sel == CCF.CCFType.BETA) {
                limit = 1;
            }
            for (int i = 0; i < limit; ++i) {
                if (!this._ctrlCCFArgs[i].isModified()) continue;
                return true;
            }
        }
        return this.getDBWrap().isModified();
    }

    @Override
    public void setModified(boolean value) {
        super.setModified(value);
        this._ctrlLaw.setModified(value);
        this.getDBWrap().setModified(value);
        for (int i = 0; i < 4; ++i) {
            this._ctrlCCFArgs[i].setText(this._ctrlCCFArgs[i].getText());
        }
    }

    @Override
    public boolean verifyData() {
        CCF.CCFType sel = (CCF.CCFType)((Object)this._ctrlCCFType.getSelectedItem());
        if (sel == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.getString("MSG_ERR_VALUE_SELECT"), ResMsgVoc.getString("VOC_ERROR"), 0);
            this._ctrlCCFType.requestFocus();
            return false;
        }
        int limit = 4;
        if (sel == CCF.CCFType.BETA) {
            limit = 1;
        }
        this._verifyFactors = new double[limit];
        for (int i = 0; i < limit; ++i) {
            double factor = Double.NaN;
            String txtFactor = this._ctrlCCFArgs[i].getText();
            if (!txtFactor.isEmpty()) {
                try {
                    factor = Double.parseDouble(txtFactor);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (Double.isNaN(factor)) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("MSG_ERR_BAD_VALUE_FRM", this._ctrlCCFLabels[i].getText()), ResMsgVoc.getString("VOC_ERROR"), 0);
                this._ctrlCCFArgs[i].requestFocus();
                return false;
            }
            this._verifyFactors[i] = factor;
        }
        if (!this._ctrlLaw.validateParams(null)) {
            return false;
        }
        if (!this.verifyDescription()) {
            return false;
        }
        return super.verifyData();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        this.getDBWrap().setType((CCF.CCFType)((Object)this._ctrlCCFType.getSelectedItem()));
        this.getDBWrap().setFactors(this._verifyFactors);
        this.getDBWrap().setLaw(this._ctrlLaw.getLaw());
        if (!this.doSave()) {
            return false;
        }
        this._ctrlName.setText(this.getDBFolder().getParent().getName());
        return true;
    }

    @Override
    protected void refreshControl() {
        super.refreshControl();
        this._ctrlCCFType.setSelectedItem((Object)this.getDBWrap().getType());
        double[] factors = this.getDBWrap().getFactors();
        int limit = 4;
        if (factors.length < limit) {
            limit = factors.length;
        }
        if (this.getDBWrap().getType() == CCF.CCFType.BETA) {
            limit = 1;
        }
        for (int i = 0; i < limit; ++i) {
            this._ctrlCCFArgs[i].setText(Double.toString(factors[i]));
        }
        this._ctrlLaw.setLaw(this.getDBWrap().getLaw());
    }

    private Component createCenterPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.add(this.createPathCtrl(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createDescriptionCtrl(), ResMsgVoc.getString("VOC_DESCRIPTION")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createCCFCtrl(), ResMsgVoc.getString("VOC_MODEL")), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createLawCtrl(), ResMsgVoc.getString("VOC_LAW")), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        return result;
    }

    @Override
    protected Component createDescriptionCtrl() {
        if (this._ctrlDescription == null) {
            this._ctrlDescription = new JTextArea(5, 40);
        }
        return super.createDescriptionCtrl();
    }

    private Collection<DBRelation> getWorkingRelation() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        this._ctrlLaw.getLaw().addRelation(this.getDBFolder(), "WORKING", relations);
        return relations;
    }

    private Component createLawCtrl() {
        CECFactory cecFactory = this.getApplication().getDAOFactory();
        this._ctrlLaw = new LawPanel(cecFactory.getLawManager(), this.getApplication());
        this._ctrlLaw.setPreferredSize(new Dimension(200, 150));
        this._ctrlLaw.addDependsListener(new DependsListener(){

            @Override
            public void changeDepends() {
                CCFFrameEdit.this.getDBWrap().updateDependTimeUpdt(CCFFrameEdit.this.getApplication().getDAOFactory(), CCFFrameEdit.this.getWorkingRelation());
            }
        });
        return this._ctrlLaw;
    }

    private Component createCCFCtrl() {
        this._ctrlCCFType = new JComboBox();
        this._ctrlCCFType.addItem(CCF.CCFType.BETA);
        this._ctrlCCFType.addItem(CCF.CCFType.MGL);
        this._ctrlCCFType.addItem(CCF.CCFType.ALPHA);
        this._ctrlCCFType.setRenderer(CCF.CCFType.getListRenderer());
        this._ctrlCCFType.setEditable(false);
        this._ctrlCCFType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCF.CCFType sel = (CCF.CCFType)((Object)CCFFrameEdit.this._ctrlCCFType.getSelectedItem());
                boolean bBeta = sel == CCF.CCFType.BETA;
                for (int i = 0; i < 4; ++i) {
                    CCFFrameEdit.this._ctrlCCFLabels[i].setText(sel.getLabelOfArg(i));
                    if (i <= 0) continue;
                    CCFFrameEdit.this._ctrlCCFLabels[i].setVisible(!bBeta);
                    CCFFrameEdit.this._ctrlCCFArgs[i].setVisible(!bBeta);
                }
                CCFFrameEdit.this.setModified(true);
            }
        });
        JPanel ctrlArgs = new JPanel(new GridBagLayout());
        this._ctrlCCFLabels = new JLabel[4];
        this._ctrlCCFArgs = new JTextFieldForCCF[4];
        for (int i = 0; i < 4; ++i) {
            this._ctrlCCFLabels[i] = new JLabel(CCF.CCFType.MGL.getLabelOfArg(i));
            this._ctrlCCFArgs[i] = new JTextFieldForCCF(12);
            ctrlArgs.add((Component)this._ctrlCCFLabels[i], new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            ctrlArgs.add((Component)this._ctrlCCFArgs[i], new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 13, 2, new Insets(2, 5, 2, 5), 0, 0));
        }
        ctrlArgs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelCCF = new JPanel(new GridBagLayout());
        panelCCF.add((Component)new JLabel(ResMsgArbor.getString("DBCCF_TYPE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 5, 2), 0, 0));
        panelCCF.add((Component)this._ctrlCCFType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(2, 2, 5, 2), 0, 0));
        panelCCF.add((Component)new JScrollPane(ctrlArgs), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 11, 1, new Insets(5, 2, 5, 2), 0, 0));
        return panelCCF;
    }

    class JTextFieldForCCF
    extends CTextFieldWithCallback {
        public JTextFieldForCCF(int col) {
            super(col);
        }

        @Override
        protected void notifyChange() {
            CCFFrameEdit.this.setModified(true);
        }
    }
}

