/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.dsf;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.dsf.io.DSFHandlerXml;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventVar;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.DefReader;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableExtern;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DSFEquation
extends FTEquationAbstract {
    private static Logger _LOG = Logger.getLogger(DSFEquation.class.getPackage().getName());
    DSFLink _dsfLink = new DSFLink();
    String _strEventName = "Event_" + this.getDBFolder().getParent().getName();
    private static final String __EmptyLabel = "";
    FTEvent _ftEvent = new FTEvent();
    FTEquationAbstract _ftEquation;
    FTVariable _dsfTop;
    DSFVariable _dsfVar = new DSFVariable();
    List<FTVariableAbstract> _listVarsGlobal;
    Map<String, FTVariableAbstract> _mapDictionary = null;
    DBLogs _logsInstanciate = null;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FTVariableAbstract getVariable(String name) {
        if (this._mapDictionary == null) {
            DBFolder dBFolder = this._dbFolder;
            synchronized (dBFolder) {
                this._mapDictionary = new HashMap<String, FTVariableAbstract>();
                for (FTVariableAbstract ftVar : this._listVarsGlobal) {
                    this._mapDictionary.put(ftVar.getName(), ftVar);
                }
            }
        }
        return this._mapDictionary.get(name);
    }

    @Override
    public List<FTVariableAbstract> getAllVariables() {
        return this._listVarsGlobal;
    }

    public DSFEquation(DBFolder folder) {
        super(folder);
        this._dsfTop = new FTVariable().setName(this.getDBFolder().getParent().getName()).setDefinition(new FTDefinition(FTDefinition.Type.OR, this._dsfVar));
        this._dsfTop.setRoot(true);
        this._ftEquation = null;
        this._listVarsGlobal = new ArrayList<FTVariableAbstract>(100);
        this._listVarsGlobal.add(this._dsfTop);
        this._listVarsGlobal.add(this._dsfVar);
    }

    @Override
    protected FTGlobEventVar createGEVar(DBFolder dbFolder, FTVariableAbstract ftVar) {
        FTGlobEventVar gEvt = new FTGlobEventVar(dbFolder, ftVar.getName());
        gEvt.setVariable(ftVar);
        if (ftVar instanceof DSFVariable) {
            gEvt.setEvent(ftVar.getEvent());
        }
        return gEvt;
    }

    @Override
    public DSFEquation getCopy() {
        DSFEquation dest = new DSFEquation(this._dbFolder);
        dest.copy(this);
        return dest;
    }

    @Override
    protected void copy(DBLogsWrap src) {
        super.copy(src);
        if (src instanceof DSFEquation) {
            DSFEquation srcDsf = (DSFEquation)src;
            if (srcDsf._ftEvent != null) {
                this._ftEvent = srcDsf._ftEvent.getCopy();
            }
            if (srcDsf._ftEquation != null) {
                this._ftEquation = srcDsf._ftEquation.getCopy();
            }
        }
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(ResMsgVoc.getString("VOC_DSF")).append("] ");
        return sb.toString();
    }

    public FTEvent getEvent() {
        return this._ftEvent;
    }

    public FTEquationAbstract getSubTree() {
        return this._ftEquation;
    }

    public DSFEquation setSubTree(FTEquationAbstract value) {
        this._ftEquation = value;
        return this;
    }

    @Override
    public short getFamilyFlag() {
        return 3;
    }

    @Override
    protected String getNature() {
        return "dsf.def";
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("cec.dsf").append(">\n");
        if (this._ftEvent != null) {
            this._ftEvent.toXML(out, indent);
        }
        if (this._ftEquation != null && this._ftEquation.getDBFolder() != null) {
            DBObjectXmlUtility.writeDBFolder(out.append(indent).append("  "), this._ftEquation.getDBFolder(), "dsf.link");
        }
        out.append(indent).append("</").append("cec.dsf").append(">\n");
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        if (this._ftEvent != null) {
            this._ftEvent.addRelation(this._dbFolder, "DSF_V", relations);
        }
        if (this._ftEquation != null && this._ftEquation.getDBFolder() != null) {
            relations.add(new DBRelation(this._dbFolder, "DSF_V", this._ftEquation.getDBFolder(), "TREE_V"));
        }
        return relations;
    }

    @Override
    public boolean readFromDAO(DAOFactory cecFactory) {
        if (!(cecFactory instanceof CECFactory)) {
            _LOG.severe("Le DAOFactory n'est pas un CECFactory");
            return false;
        }
        DBLogs.DBLogsManager logMng = this.createReadLogsManager(cecFactory.getUserLogin());
        if (!this.readLogs(cecFactory)) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_STRUCTURAL"));
            return false;
        }
        DBObjModel model = this.getDefaultObjModel(cecFactory);
        if (model != null ? !this.readFromDBObjModel(model, (CECFactory)cecFactory, logMng) : (model = this._dbFolder.getObject().getModel("tree.def")) != null && !this.readFromDBObjModel(model, (CECFactory)cecFactory, logMng)) {
            return false;
        }
        this.prepareDependTimeUpdt(cecFactory, null);
        return true;
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String nature = model.getNature();
        if ("tree.def".equals(nature)) {
            String format = model.getFormat();
            if ("ARBOR".equals(format)) {
                InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
                if (istream == null) {
                    logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                    return false;
                }
                byte[] ibyte = DAOObjModel.convertFromCompressedByte(istream);
                if (ibyte == null) {
                    logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                    return false;
                }
                String def = new String(ibyte);
                return this.readRaw(def, cecFactory, logMng);
            }
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", nature, format));
            return false;
        }
        String format = model.getFormat();
        if ("ZML".equals(format) || "XML".equals(format)) {
            InputStream istream = this.getBinaryStream(model, cecFactory, logMng);
            if (istream == null) {
                return false;
            }
            if ("ZML".equals(format)) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            return this.readXml(istream, cecFactory, logMng);
        }
        logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
        return false;
    }

    private boolean readRaw(String def, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result;
        block5: {
            block6: {
                block7: {
                    FTVariable var;
                    DefReader reader = new DefReader(cecFactory, logMng);
                    result = reader.readDef(new StringReader(def));
                    if (!result) break block5;
                    result = false;
                    Collection<FTVariable> vars = reader.getVariables();
                    if (vars == null || vars.size() != 1 || (var = vars.iterator().next()).getEvent() == null) break block6;
                    this._ftEvent = var.getEvent();
                    if (this._ftEvent == null || this._ftEvent.getModelLaw() == null) {
                        logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgArbor.getString("MSG_ERR_DSF_NO_FRB"));
                    }
                    if (var.getLink() == null) break block7;
                    FTEquationAbstract ftEqu = var.getLink().getSubTree();
                    if (ftEqu == null) break block6;
                    this._ftEquation = ftEqu;
                }
                result = true;
            }
            if (!result) {
                _LOG.warning("Le flux 'tree.def' a bien ete lu, mais les informations n'ont pas ete recuperes");
            }
        }
        return result;
    }

    private boolean readXml(InputStream input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        DSFHandlerXml saxHanlder = new DSFHandlerXml(logMng, null, cecFactory);
        try {
            this.readXml(input, saxHanlder);
            this._ftEvent = saxHanlder.getEvent();
            this._ftEquation = saxHanlder.getSubTree();
            result = true;
        }
        catch (IOException e) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC"));
        }
        return result;
    }

    public void printEqu(Appendable out) throws IOException {
        throw new IOException("Unimplemented fonction");
    }

    @Override
    public DBLogs getInstanciateLogs() {
        return this._logsInstanciate;
    }

    @Override
    public boolean instanciate(boolean force, DBUser dbUser) {
        if (!force && this._logsInstanciate != null) {
            return !this._logsInstanciate.withLogs(DBLogs.DBLevel.WARNING);
        }
        this._logsInstanciate = new DBLogs();
        this._mapDictionary = null;
        this._listVarsGlobal.clear();
        this._listVarsGlobal.add(this._dsfTop);
        this._listVarsGlobal.add(this._dsfVar);
        if (this._ftEquation != null) {
            if (this._ftEquation.getDBFolder().getAccessRight(dbUser) == DBAccess.Right.INTEGRATE) {
                this.addInstanciateLog(this._logsInstanciate, this.getDBFolder(), DBLogs.DBLevel.INFO, ResMsgArbor.msgFormat("_MSG_INSTANCE_DSF_INTEGRATE", this._ftEquation.getRefPath(), this._dsfVar.getExportName(), this.getRefPath()));
            } else if (!this._ftEquation.instanciate(false, dbUser)) {
                this.addInstanciateLog(this._logsInstanciate, this._ftEquation.getDBFolder(), DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("_MSG_INSTANCE_DSF", this._ftEquation.getRefPath(), this.getRefPath()));
            } else {
                if (this._ftEquation.getInstanciateLogs().withLogs(DBLogs.DBLevel.INFO)) {
                    for (DBLogs.Log dbLog : this._ftEquation.getInstanciateLogs().getLogs(DBLogs.DBLevel.INFO)) {
                        this._logsInstanciate.addLog(dbLog);
                    }
                }
                List<FTVariableExtern> subVars = this._ftEquation.instanciateVariables(__EmptyLabel);
                for (FTVariableExtern subVar : subVars) {
                    if (subVar.getName().equals(this._dsfVar.getName())) {
                        this.addInstanciateLog(this._logsInstanciate, this.getDBFolder(), DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("_MSG_DSF_NAME_CHILD", subVar.getName()));
                        break;
                    }
                    if (subVar.isRoot()) {
                        this._dsfVar.setDefinition(subVar.getDefinition());
                        continue;
                    }
                    this._listVarsGlobal.add(subVar);
                }
            }
        }
        if (this._logsInstanciate.withLogs(DBLogs.DBLevel.WARNING)) {
            this._mapDictionary = null;
            this._listVarsGlobal.clear();
            this._listVarsGlobal.add(this._dsfTop);
            this._listVarsGlobal.add(this._dsfVar);
        }
        return !this._logsInstanciate.withLogs(DBLogs.DBLevel.WARNING);
    }

    @Override
    public List<FTVariableExtern> instanciateVariables(String append) {
        return this.instanciateVariables(this._listVarsGlobal, append);
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        this._ftEvent.update(daoFactory, logMng, this._strEventName);
        if (this._ftEquation != null) {
            this._ftEquation = (FTEquationAbstract)DBWrap.createOrFind(daoFactory, this._ftEquation.getDBFolder(), logMng, FTEquationAbstract.class);
            if (this._ftEquation == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        List<Function<DBWrap, CompareResult>> list = super.getFieldsToCompare(factoryWrap, forImport);
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                FTEvent event1 = DSFEquation.this.getEvent();
                FTEvent event2 = ((DSFEquation)wrap).getEvent();
                DBModelLaw btp1 = event1 != null ? event1.getModelLaw() : null;
                DBModelLaw btp2 = event1 != null ? event2.getModelLaw() : null;
                return new CompareResultString(ResMsgVoc.getString("VOC_EVENT"), btp1 != null ? btp1.getRefPath() : DSFEquation.__EmptyLabel, btp2 != null ? btp2.getRefPath() : DSFEquation.__EmptyLabel);
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                FTEquationAbstract subtree1 = DSFEquation.this.getSubTree();
                FTEquationAbstract subtree2 = ((DSFEquation)wrap).getSubTree();
                return new CompareResultString(ResMsgVoc.getString("VOC_LINK"), subtree1 != null ? subtree1.getRefPath() : DSFEquation.__EmptyLabel, subtree2 != null ? subtree2.getRefPath() : DSFEquation.__EmptyLabel);
            }
        });
        return list;
    }

    class DSFVariable
    extends FTVariableAbstract {
        FTDefinition _ftDefinition = null;

        DSFVariable() {
        }

        @Override
        public String getName() {
            return DSFEquation.this._strEventName;
        }

        @Override
        public String getLabel() {
            String result = DSFEquation.this.getDBFolder().getDescription();
            if (result == null) {
                return DSFEquation.__EmptyLabel;
            }
            return result;
        }

        @Override
        public FTEvent getEvent() {
            return DSFEquation.this._ftEvent;
        }

        @Override
        public FTLink getLink() {
            if (DSFEquation.this._ftEquation != null) {
                return DSFEquation.this._dsfLink;
            }
            return null;
        }

        @Override
        public FTDefinition.Type getType() {
            return FTDefinition.Type.VAR;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public boolean isRoot() {
            return false;
        }

        @Override
        public boolean isIntern() {
            return true;
        }

        @Override
        public FTDefinition getDefinition() {
            return this._ftDefinition;
        }

        @Override
        public DSFVariable setDefinition(FTDefinition value) {
            this._ftDefinition = value;
            return this;
        }

        @Override
        public FTVariableAbstract getCopy(CopyUtility util) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAbstract() {
            StringBuilder sb = new StringBuilder();
            sb.append("[DSF] ").append(this.getLink().getSubTree().getDBFolder().getRefPath());
            return sb.toString();
        }
    }

    class DSFLink
    extends FTLink {
        DSFLink() {
        }

        @Override
        public FTEquationAbstract getSubTree() {
            return DSFEquation.this._ftEquation;
        }

        @Override
        public String getGeneric() {
            return DSFEquation.__EmptyLabel;
        }
    }
}

