/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.dsf.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.GenerateDepFolders;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationPanelSelect;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.folder.DBFolderPropertiesPanel;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.attrib.gui.DBAttribValuesTablePanel;
import com.dassault.cecilia.dbobj.general.event.gui.EventModifierLawPanel;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.modellaw.gui.DBModelLawPanelSelect;
import com.dassault.cecilia.dbobj.wrap.DBWrapThreadSave;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapFrameEdit;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapSaveAsDlg;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapSaveAsDlgWithVirtual;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.folders.ProjectFolderCreateTreeVersionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DSFEquationFrameEdit
extends DBWrapFrameEdit {
    private static final Logger _LOG = Logger.getLogger(DSFEquationFrameEdit.class.getPackage().getName());
    int _typeModifier;
    Param _valueParam;
    ArrayList<DBAttrib.Value> _currentAttribs;
    private DependsListener _updateDepends = new DependsListener(){

        @Override
        public void changeDepends() {
            DSFEquationFrameEdit.this.getDBWrap().updateDependTimeUpdt(DSFEquationFrameEdit.this.getApplication().getDAOFactory(), DSFEquationFrameEdit.this.getWorkingRelation());
        }
    };
    DBModelLawPanelSelect _ctrlPanelModelEvent;
    EventModifierLawPanel _ctrlModifierPanel;
    DBAttribValuesTablePanel _ctrlAttribs;
    FTEquationPanelSelect _ctrlPanelSubTree;

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_DSF");
    }

    @Override
    public DSFEquation getDBWrap() {
        return (DSFEquation)super.getDBWrap();
    }

    public DSFEquationFrameEdit(DSFEquation dbDsf, CeciliaAppl appl) {
        super(dbDsf.getCopy(), appl);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createCenterPanel(), "Center");
        this.getContentPane().add(this.createAndPlugLogsButtonAt(this.createSaveAndClosePanel()), "South");
        this.pack();
        this.refreshControl();
        this.setModified(false);
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (this._ctrlPanelModelEvent.isModified()) {
            return true;
        }
        if (this._ctrlPanelSubTree.isModified()) {
            return true;
        }
        if (this._ctrlAttribs.isModified()) {
            return true;
        }
        return this._ctrlModifierPanel.isModified();
    }

    @Override
    public void setModified(boolean value) {
        super.setModified(value);
        this._ctrlPanelModelEvent.setModified(value);
        this._ctrlPanelSubTree.setModified(value);
        this._ctrlAttribs.setModified(value);
        this._ctrlModifierPanel.setModified(value);
    }

    @Override
    public boolean verifyData() {
        boolean simpleExp;
        FTEquationAbstract ftEquation;
        DBModelLaw dbModelLaw = this._ctrlPanelModelEvent.getModelLaw();
        if (dbModelLaw == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlPanelModelEvent), ResMsgArbor.getString("MSG_ERR_DSF_NO_FRB"), this.getTitle(), 0);
            this._ctrlPanelModelEvent.requestFocus();
            return false;
        }
        if (this._ctrlPanelSubTree.isInput() && (ftEquation = this._ctrlPanelSubTree.getEquation()) == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlPanelSubTree), ResMsgArbor.getString("MSG_ERR_DSF_NO_SUBTREE"), this.getTitle(), 0);
            this._ctrlPanelSubTree.requestFocus();
            return false;
        }
        Law law = this._ctrlPanelModelEvent.getModelLaw().getLaw();
        boolean bl = simpleExp = law.getID() == 0 && law.getModifierLaw() == null;
        if (!this._ctrlModifierPanel.verifyParameters(this._typeModifier, simpleExp, this.getTitle())) {
            return false;
        }
        if (!this.verifyDescription()) {
            return false;
        }
        return super.verifyData();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        DBModelLaw dbModelLaw = this._ctrlPanelModelEvent.getModelLaw();
        if (dbModelLaw == null) {
            _LOG.warning("DSFEquationFrameEdit::Save sans modele de loi: " + this.getDBWrap().getDBFolder().getRefPath());
            return false;
        }
        this.getDBWrap().getEvent().setModelLaw(dbModelLaw);
        if (this._ctrlPanelSubTree.isInput()) {
            FTEquationAbstract ftEquation = this._ctrlPanelSubTree.getEquation();
            if (ftEquation == null) {
                _LOG.warning("DSFEquationFrameEdit::Save sans sous-arbre: " + this.getDBWrap().getDBFolder().getRefPath());
                return false;
            }
            this.getDBWrap().setSubTree(ftEquation);
        } else {
            this.getDBWrap().setSubTree(null);
        }
        this._ctrlModifierPanel.affectEvent(this.getDBWrap().getEvent());
        this.getDBWrap().getEvent().removeAllAttributes();
        for (DBAttrib.Value attrib : this._currentAttribs) {
            this.getDBWrap().getEvent().addAttribute(attrib);
        }
        if (!this.doSave()) {
            return false;
        }
        this._ctrlName.setText(this.getDBFolder().getParent().getName());
        return true;
    }

    @Override
    protected boolean doSave() {
        DBWrapThreadSave thSave = new DBWrapThreadSave(this.getDBWrap(), this.getDescription(), this.getApplication(), this._ctrlSave){

            @Override
            protected void setModif(boolean value) {
                DSFEquationFrameEdit.this.setModified(value);
            }

            @Override
            protected boolean writeToDAO() {
                if (!super.writeToDAO()) {
                    return false;
                }
                Collection<DBGlobEvent> events = DSFEquationFrameEdit.this.getDBWrap().createGlobalEvents(DSFEquationFrameEdit.this.getDBFolder());
                return DSFEquationFrameEdit.this.getApplication().getDAOFactory().createGlobEventDAO().insertAll(DSFEquationFrameEdit.this.getDBFolder(), events);
            }
        };
        return this.doSave(thSave);
    }

    @Override
    protected DBWrapSaveAsDlg saveAsPrepareDialog() {
        return new DBWrapSaveAsDlgWithVirtual(JOptionCecilia.getWindowOf(this), this.getApplication(), this.getDBFolder().getFamily()){

            @Override
            protected DBFolderPropertiesPanel createVersionPanel() {
                return new ProjectFolderCreateTreeVersionPanel();
            }
        };
    }

    @Override
    protected DBFolder[] saveAsPrepareFolders(DBWrapSaveAsDlg dlg) {
        if (!dlg.isVersionCreation()) {
            return DBFactory.createModel(dlg.getSelectFolder(), this.getApplication().getDBUser(), dlg.getNewName(), "1.0", this.getDBFolder().getFamily(), this.getDBFolder().getFamilyFlag(), (short)0);
        }
        return super.saveAsPrepareFolders(dlg);
    }

    @Override
    protected void refreshControl() {
        super.refreshControl();
        FTEvent evt = this.getDBWrap().getEvent();
        this._valueParam = evt.getInspected();
        if (this._valueParam != null) {
            this._typeModifier = 1;
            this._valueParam = this._valueParam.getCopy();
        } else {
            this._valueParam = evt.getInflightTested();
            if (this._valueParam != null) {
                this._typeModifier = 2;
                this._valueParam = this._valueParam.getCopy();
            } else {
                this._typeModifier = 0;
            }
        }
        this._currentAttribs = new ArrayList();
        for (DBAttrib.Value attrib : evt.getAttributes()) {
            this._currentAttribs.add(attrib.getCopy());
        }
        this._ctrlPanelModelEvent.setModelLaw(evt.getModelLaw());
        this._ctrlModifierPanel.setModifier(this._typeModifier, this._valueParam);
        this._ctrlAttribs.setItems(this._currentAttribs);
        this._ctrlPanelSubTree.setEquation(this.getDBWrap().getSubTree());
    }

    private Collection<DBRelation> getWorkingRelation() {
        FTEquationAbstract ftEquation;
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        DBFolder srcFolder = this.getDBFolder();
        String srcType = "WORKING";
        DBModelLaw dbModelLaw = this._ctrlPanelModelEvent.getModelLaw();
        if (dbModelLaw != null) {
            relations.add(new DBRelation(srcFolder, srcType, dbModelLaw.getDBFolder(), "LAW_MODEL"));
        }
        if (this._ctrlPanelSubTree.isInput() && (ftEquation = this._ctrlPanelSubTree.getEquation()) != null) {
            relations.add(new DBRelation(srcFolder, srcType, ftEquation.getDBFolder(), "TREE_V"));
        }
        Param param = null;
        param = this._ctrlModifierPanel.getInflightParam();
        if (param != null) {
            param.addRelation(srcFolder, srcType, relations);
        }
        if ((param = this._ctrlModifierPanel.getInspectedParam()) != null) {
            param.addRelation(srcFolder, srcType, relations);
        }
        for (DBAttrib.Value attrib : this._currentAttribs) {
            relations.add(new DBRelation(srcFolder, srcType, attrib.getKey().getDBFolder(), "ATTRIBUTE"));
        }
        return relations;
    }

    private Component createCenterPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.add(this.createPathCtrl(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createDescriptionCtrl(), ResMsgVoc.getString("VOC_DESCRIPTION")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createModelLawPanel(), ResMsgVoc.getString("VOC_FRB")), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createSubTreePanel(), ResMsgVoc.getString("VOC_TREE")), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        return result;
    }

    @Override
    protected Component createDescriptionCtrl() {
        if (this._ctrlDescription == null) {
            this._ctrlDescription = new JTextArea(5, 40);
        }
        return super.createDescriptionCtrl();
    }

    protected Component createModelLawPanel() {
        JPanel distribPanel = new JPanel(new GridBagLayout());
        this._ctrlPanelModelEvent = new DBModelLawPanelSelect(this.getApplication(), true);
        this._ctrlPanelModelEvent.addDependsListener(this._updateDepends);
        this._ctrlModifierPanel = new EventModifierLawPanel(this.getApplication());
        this._ctrlModifierPanel.addDependsListener(this._updateDepends);
        distribPanel.add((Component)this._ctrlPanelModelEvent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        distribPanel.add((Component)this._ctrlModifierPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        distribPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_DISTRIBUTION")));
        Window window = SwingUtilities.getWindowAncestor(this);
        this._ctrlAttribs = new DBAttribValuesTablePanel(window, this.getApplication());
        this._ctrlAttribs.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_ATTRIBUTES")));
        this._ctrlAttribs.addDependsListener(this._updateDepends);
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)distribPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        result.add((Component)this._ctrlAttribs, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        return result;
    }

    protected Component createSubTreePanel() {
        this._ctrlPanelSubTree = new FTEquationPanelSelect(this.getApplication(), true);
        this._ctrlPanelSubTree.setFilterDSF(true).setFilterTree(true);
        GenerateDepFolders depsFolder = new GenerateDepFolders(this.getApplication().getDAOFactory()){

            @Override
            protected boolean dontTreatThisFamily(DBFolder.Family family) {
                return family != DBFolder.Family.PROJECT;
            }
        };
        depsFolder.setDirection(Generate.Direction.UP);
        depsFolder.prepare(this.getDBFolder(), this.getDBFolder(), null);
        Set<DBFolder> dependFolders = depsFolder.getDepends(false);
        HashSet<DBFolder> excludeFolders = new HashSet<DBFolder>();
        for (DBFolder dependFolder : dependFolders) {
            if (dependFolder.isVersion()) {
                excludeFolders.add(dependFolder.getParent());
                List<DBFolder> children = dependFolder.getParent().getChildren();
                if (children == null) {
                    children = this.getApplication().getDAOFactory().createFolderDAO().findChildren(dependFolder.getParent());
                }
                for (DBFolder dbChild : children) {
                    excludeFolders.add(dbChild);
                }
                continue;
            }
            excludeFolders.add(dependFolder);
        }
        this._ctrlPanelSubTree.defineExcludeFolders(excludeFolders);
        this._ctrlPanelSubTree.addDependsListener(this._updateDepends);
        return this._ctrlPanelSubTree;
    }

    @Override
    protected boolean withUpdateEdit() {
        return true;
    }

    @Override
    protected void updateEdit() {
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getApplication().getDBUser().getLogin(), this.getDBWrap().getLogs());
        this.getDBWrap().update(this.getApplication().getDAOFactory(), logMng);
        this.refreshControl();
        this.getDBWrap().prepareDependTimeUpdt(this.getApplication().getDAOFactory(), this.getDBWrap().getUseRelations());
        this.updateLogs(this.getDBWrap().getUseRelations(), oldLevel, oldNbr);
    }
}

