/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventAbstract;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventDelegate;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.Filter;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public class FTGlobEventUtility {
    private FTGlobEventUtility() {
    }

    public static ArrayList<FTGlobEventAbstract> computeSynthesis(List<FTGlobEventAbstract> input, Filter<FTGlobEventAbstract> filter) {
        TreeMap<String, ArrayList<Integer>> _groups = new TreeMap<String, ArrayList<Integer>>();
        for (int i = 0; i < input.size(); ++i) {
            FTGlobEventAbstract item = input.get(i);
            if (filter != null && !filter.filter(item)) continue;
            ArrayList<Integer> group = (ArrayList<Integer>)_groups.get(item.getName());
            if (group == null) {
                group = new ArrayList<Integer>();
                _groups.put(item.getName(), group);
            }
            group.add(i);
        }
        ArrayList<FTGlobEventAbstract> output = new ArrayList<FTGlobEventAbstract>(input.size() + 1);
        for (String name : _groups.keySet()) {
            List group = (List)_groups.get(name);
            int idx = (Integer)group.get(0);
            FTGlobEventAbstract first = input.get(idx);
            output.add(first);
            for (int i = 1; i < group.size(); ++i) {
                idx = (Integer)group.get(i);
                FTGlobEventAbstract next = input.get(idx);
                FTGlobEventDelegate copy = new FTGlobEventDelegate(next);
                copy.setName("");
                if (first.getProject().equals(next.getProject())) {
                    copy.setProject("");
                } else {
                    copy.setProject(next.getProject());
                }
                if (copy.getProject().equals("") && first.getSystem().equals(next.getSystem())) {
                    copy.setSystem("");
                } else {
                    copy.setSystem(next.getSystem());
                }
                if (copy.getSystem().equals("") && first.getTree().equals(next.getTree()) && first.getVersion().equals(next.getVersion())) {
                    copy.setTree("");
                    copy.setVersion("");
                } else {
                    copy.setTree(next.getTree());
                    copy.setVersion(next.getVersion());
                }
                if (!first.getProject().equals(next.getProject())) {
                    first = next;
                }
                output.add(copy);
            }
        }
        return output;
    }

    public static List<FTGlobEventAbstract> computeFilter(List<FTGlobEventAbstract> input, Filter<FTGlobEventAbstract> filter) {
        if (filter == null) {
            return input;
        }
        ArrayList<FTGlobEventAbstract> output = new ArrayList<FTGlobEventAbstract>(input.size() / 2);
        for (int i = 0; i < input.size(); ++i) {
            FTGlobEventAbstract item = input.get(i);
            if (!filter.filter(item)) continue;
            output.add(item);
        }
        return output;
    }

    public static void exportToXML(Appendable out, Collection<FTGlobEventAbstract> input, Filter<FTGlobEventAbstract> filter) throws IOException {
        out.append("<?xml version=\"1.0\"?>\n");
        out.append("<event-global-list-export version='1.0'>\n");
        for (FTGlobEventAbstract item : input) {
            if (filter != null && !filter.filter(item)) continue;
            out.append("  <item");
            out.append(" project='").append(XMLWriter.toXML((String)item.getProject())).append("'");
            out.append(" system='").append(XMLWriter.toXML((String)item.getSystem())).append("'");
            out.append(" treeName='").append(XMLWriter.toXML((String)item.getTree())).append("'");
            out.append(" treeVersion='").append(XMLWriter.toXML((String)item.getVersion())).append("'");
            out.append(" name='").append(XMLWriter.toXML((String)item.getName())).append("'");
            if (item.getType() == DBGlobEvent.Type.BASIC) {
                out.append(" isTerminal='true'");
            }
            if (item.getType() == DBGlobEvent.Type.ROOT) {
                out.append(" isRoot='true'");
            }
            String value = null;
            value = item.getComment();
            if (value != null && value.length() > 0) {
                out.append(" comments='").append(XMLWriter.toXML((String)value)).append("'");
            }
            if (item.getLaw() != null) {
                out.append(" law='").append(XMLWriter.toXML((String)item.getLaw().toString())).append("'");
            }
            if (item.getState() != null) {
                out.append(" state='").append(XMLWriter.toXML((String)item.getState().toString().toLowerCase())).append("'");
            }
            if (item.getStyle() != null) {
                out.append(" style='").append(XMLWriter.toXML((String)item.getStyle().toString().toLowerCase())).append("'");
            }
            if ((value = item.getGenericSuffix()) != null && value.length() > 0) {
                out.append(" genericExtention='").append(XMLWriter.toXML((String)value)).append("'");
            }
            if (item.getLink() == DBGlobEvent.Link.TREE) {
                out.append(" isSubTree='true'");
            }
            if (item.getLink() == DBGlobEvent.Link.DSF) {
                out.append(" isDSF='true'");
            }
            if (item.getStyle() == FTEvent.Style.UNLINK) {
                out.append(" isUnlinkSubTree='true'");
            }
            if (item.getSubTree() != null) {
                out.append(" nameSubTree='").append(XMLWriter.toXML((String)item.getSubTree().getRefPath())).append("'");
            }
            if (item.getModelLaw() != null) {
                out.append(" isLinkToFRB='true'");
                out.append(" FRB='").append(XMLWriter.toXML((String)item.getModelLaw().getRefPath())).append("'");
            }
            if (item.getInspected() != null) {
                out.append(" isInspected='true'");
                out.append(" inspectedPeriodicity='").append(XMLWriter.toXML((String)item.getInspected().toString())).append("'");
            }
            if (item.getInflightTested() != null) {
                out.append(" isInflightTested='true'");
                out.append(" expositionTime='").append(XMLWriter.toXML((String)item.getInflightTested().toString())).append("'");
            }
            if (item.getAttributes() != null && item.getAttributes().size() > 0) {
                out.append(">\n");
                for (DBAttrib.Value attrValue : item.getAttributes()) {
                    DBFolder dbFolder = attrValue.getKey().getDBFolder();
                    out.append("   <attribute");
                    out.append(" path='").append(XMLWriter.toXML((String)dbFolder.getRefPath())).append("'");
                    out.append(" name='").append(XMLWriter.toXML((String)dbFolder.getParent().getName())).append("'");
                    out.append(" version='").append(XMLWriter.toXML((String)dbFolder.getName())).append("'");
                    out.append(" type='").append(Integer.toString(attrValue.getKey().getType().getIndex())).append("'");
                    if (attrValue.getValue() != null) {
                        out.append(" value='").append(attrValue.getValue().toString()).append("'");
                    }
                    out.append("/>\n");
                }
                out.append("  </item >\n");
                continue;
            }
            out.append("/>\n");
        }
        out.append("</event-global-list-export>\n");
    }

    public static void exportToXMLForMEL(Appendable out, Collection<FTGlobEventAbstract> input, Filter<FTGlobEventAbstract> filter) throws IOException {
        out.append("<?xml version=\"1.0\"?>\n");
        out.append("<EXPORT>\n");
        out.append("\t<EVENT_SET>\n");
        HashSet<String> done = new HashSet<String>();
        for (FTGlobEventAbstract item : input) {
            String name;
            if (filter != null && !filter.filter(item) || done.contains(name = item.getEvtName())) continue;
            done.add(name);
            out.append("\t\t<EVENT NAME=\"" + name + "\"/>\n");
        }
        out.append("\t</EVENT_SET>\n");
        out.append("</EXPORT>\n");
    }
}

