/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;

public class FTGlobEventVar
extends FTGlobEvent {
    public FTGlobEventVar(DBFolder dbFolder, String name) {
        super(dbFolder, name);
    }

    public FTGlobEventVar setVariable(FTVariableAbstract ftVar) {
        this._name = ftVar.getName();
        this._commentLong = ftVar.getLabel();
        this._commentShort = this._commentLong.length() > 255 ? this._commentLong.substring(0, 255) : this._commentLong;
        this._link = DBGlobEvent.Link.NONE;
        FTLink ftLink = ftVar.getLink();
        if (ftLink != null) {
            this._dbSubTree = ftLink.getSubTree().getDBFolder();
            if (ftLink.isDSF()) {
                this._link = DBGlobEvent.Link.DSF;
            } else {
                this._link = DBGlobEvent.Link.TREE;
                this._genericSuffix = ftLink.getGeneric();
            }
        }
        this._type = ftVar.isRoot() ? DBGlobEvent.Type.ROOT : (ftVar.isLeaf() && this._link == DBGlobEvent.Link.NONE ? DBGlobEvent.Type.BASIC : DBGlobEvent.Type.GATE);
        this._genericFlag = ftVar.isGeneric();
        switch (this._type) {
            case GATE: 
            case ROOT: {
                FTDefinition ftDefine = ftVar.getDefinition();
                if (ftDefine == null) break;
                this._definition = ftDefine.toStringWithLexcalOrder();
                break;
            }
            case BASIC: {
                this.setEvent(ftVar.getEvent());
            }
        }
        return this;
    }

    public void setEvent(FTEvent ftEvent) {
        this._type = DBGlobEvent.Type.BASIC;
        this._state = ftEvent.getState();
        this._style = ftEvent.getStyle();
        this._distrib = ftEvent.getLaw();
        this._inflight_tested = ftEvent.getInflightTested();
        this._inspected = ftEvent.getInspected();
        this._dbModelLaw = ftEvent.getModelLaw() == null ? null : ftEvent.getModelLaw().getDBFolder();
        this._attributes = ftEvent.getAttributes();
        this._dbCCF = ftEvent.getCCF() == null ? null : ftEvent.getCCF().getDBFolder();
    }

    public DBGlobEvent getDBGlobEvent() {
        DBGlobEvent dbGEvt = new DBGlobEvent(this._dbFolder.getObject());
        dbGEvt.setName(this._name);
        dbGEvt.setComment(this._commentShort);
        dbGEvt.setType(this._type);
        dbGEvt.setLink(this._link);
        dbGEvt.setLOb(this.getDataXML());
        return dbGEvt;
    }
}

