/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.ExpInfo;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsFactory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.cecilia.pref.PrintPreviewPrefsDlg;
import com.dassault.cecilia.core.cecilia.print.ListProcessorJavaInteractive;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugModel;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventAbstract;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventUtility;
import com.dassault.cecilia.dbobj.faulttree.egli.export.ExpEGLTable;
import com.dassault.cecilia.dbobj.faulttree.egli.gui.EventGlobalListModel;
import com.dassault.cecilia.dbobj.faulttree.egli.gui.EventGlobalListTable;
import com.dassault.cecilia.dbobj.faulttree.egli.pref.EGLDisplayPreferencies;
import com.dassault.cecilia.dbobj.faulttree.egli.pref.EGLPrintPreferencies;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.Filter;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.TypeFilter;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractInternalFrame;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractTableModel;
import com.dassault.cecilia.dbobj.wrap.PageableThread;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class EventGlobalListFrame
extends ItemAbstractInternalFrame
implements Preferencies.PreferenciesListener,
PlugModel {
    private static Logger _LOG = Logger.getLogger(EventGlobalListFrame.class.getPackage().getName());
    private CeciliaAppl _application;
    private RowSorter<TableModel> _sorterTable;
    private JComboBox _selecteur;
    private JCheckBox _synthesisChk;
    private JLabel _labelQuantite;
    private JLabel _quantite;
    JButton _filtersDlg;
    private JPopupMenu _popupMenu;
    private JMenuItem _itemExportForMEL;
    private JMenuItem _itemExportXML;
    List<FTGlobEventAbstract> _data;
    static JFileChooser _dlgChoose = null;

    public EventGlobalListFrame(List<FTGlobEventAbstract> data, CeciliaAppl appl) {
        super(ResIcoArbor.getImageIcon("LIST_ITEM_PI"), ResMsgObj.getString("EGL_LABEL"), ResMsgObj.getString("EGL_TITLE"));
        this._application = appl;
        this.setFrameIcon(ResIcoArbor.getImageIcon("LIST_ITEM_PI"));
        this._data = data;
        this.build();
        this.refreshFilterSelected();
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize.width / 2, screenSize.height / 2);
        this.setVisible(false);
    }

    protected CeciliaAppl getAppl() {
        return this._application;
    }

    protected ItemAbstractTableModel createModel() {
        EventGlobalListModel modelTable = new EventGlobalListModel(this._data, false);
        PluginWithOptions prefs = this.getAppl().getPreferencies().getOptions(EGLDisplayPreferencies.PREF_KEY);
        if (prefs == null || !(prefs instanceof EGLDisplayPreferencies)) {
            prefs = new EGLDisplayPreferencies();
            this.getAppl().getPreferencies().addOptions(prefs);
            prefs.refreshOptions(this.getAppl().getPlugable());
        }
        List<PrefFieldBoolean> listPrefs = ((PrefFieldsCategory)prefs).getBooleanFields();
        modelTable.getColumnModel().setOptionnalFields(PrefFieldsFactory.clone(listPrefs));
        return modelTable;
    }

    EventGlobalListModel getModel() {
        return (EventGlobalListModel)this._modelTable;
    }

    protected JTable createTable(ItemAbstractTableModel model) {
        EventGlobalListTable table = new EventGlobalListTable(model, this.getAppl());
        this._sorterTable = new TableRowSorter<ItemAbstractTableModel>(model);
        table.setRowSorter(this._sorterTable);
        table.setAutoResizeMode(0);
        table.doLayout();
        return table;
    }

    EventGlobalListTable getTable() {
        return (EventGlobalListTable)this._table;
    }

    private void refreshFilterSelected() {
        Filter filter;
        Object selectedItem = this._selecteur.getSelectedItem();
        Filter filter2 = filter = selectedItem != null && selectedItem instanceof Filter ? (Filter)selectedItem : null;
        if (filter != null) {
            filter.selectFilter(this._selecteur);
        }
        this._filtersDlg.setEnabled(filter != null && filter.withDialog());
        this.getModel().setFilter(filter);
    }

    @Override
    protected void build() {
        this.makePopupMenu();
        this._modelTable = this.createModel();
        this._table = this.createTable(this._modelTable);
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel panelList = new JPanel(new GridBagLayout());
        this._selecteur = new JComboBox();
        this._synthesisChk = new JCheckBox(ResMsgObj.getString("EGL_SYNTHESE"));
        this._filtersDlg = new JButton(ResMsgVoc.getString("VOC_FILTER"));
        JButton fieldsDlg = new JButton(ResMsgVoc.getString("VOC_FIELDS"));
        int idxX = 0;
        this._selecteur.addItem(EventGlobalListModel.FilterEGLFactory.createItem(TypeFilter.ALL));
        this._selecteur.addItem(EventGlobalListModel.FilterEGLFactory.createItem(TypeFilter.ROOTS));
        this._selecteur.addItem(EventGlobalListModel.FilterEGLFactory.createItem(TypeFilter.GATES));
        this._selecteur.addItem(EventGlobalListModel.FilterEGLFactory.createItem(TypeFilter.LEAVES));
        this._selecteur.addItem(EventGlobalListModel.FilterEGLFactory.createItem(TypeFilter.SUBTREE));
        this._selecteur.addItem(EventGlobalListModel.FilterEGLFactory.createItem(TypeFilter.DSF));
        this._selecteur.addItem(EventGlobalListModel.FilterEGLFactory.createItem(TypeFilter.INSPECTED));
        this._selecteur.addItem(EventGlobalListModel.FilterEGLFactory.createItem(TypeFilter.INFLYTESTED));
        this._selecteur.addItem(EventGlobalListModel.FilterEGLFactory.createItem(TypeFilter.FILTERED));
        this._selecteur.setSelectedIndex(PlugableUtility.getIntOpt(this.getAppl().getPlugable(), EGLDisplayPreferencies.PREF_FILTER_SELECT, 0));
        this._selecteur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EventGlobalListFrame.this.refreshFilterSelected();
                    }
                });
            }
        });
        panelList.add((Component)this._selecteur, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._filtersDlg.setEnabled(false);
        panelList.add((Component)this._filtersDlg, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._filtersDlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = EventGlobalListFrame.this._selecteur.getSelectedItem();
                if (selectedItem == null) {
                    return;
                }
                if (!(selectedItem instanceof Filter)) {
                    return;
                }
                Filter filter = (Filter)selectedItem;
                if (!filter.withDialog()) {
                    return;
                }
                if (!filter.displayDialog(EventGlobalListFrame.this._selecteur)) {
                    return;
                }
                EventGlobalListFrame.this._modelTable.refresh(true, false);
            }
        });
        JPanel panelQuantite = new JPanel(new GridBagLayout());
        this._labelQuantite = new JLabel(ResMsgVoc.getString("VOC_QUANTITY"));
        panelQuantite.add((Component)this._labelQuantite, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 2), 0, 0));
        this._quantite = new JLabel(ResMsgCore.msgFormat("MSG_X_ON_Y", "X", "Y"));
        panelQuantite.add((Component)this._quantite, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 0), 0, 0));
        this._modelTable.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                EventGlobalListFrame.this._quantite.setText(ResMsgCore.msgFormat("MSG_X_ON_Y", EventGlobalListFrame.this._modelTable.getRowCount(), EventGlobalListFrame.this._modelTable.getFullRowCount()));
            }
        });
        panelList.add((Component)panelQuantite, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        JLabel glue = new JLabel();
        panelList.add((Component)glue, new GridBagConstraints(idxX++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        panelList.add((Component)this._synthesisChk, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._synthesisChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventGlobalListFrame.this.getModel().setSynthesis(EventGlobalListFrame.this._synthesisChk.isSelected());
                EventGlobalListFrame.this._itemExportForMEL.setEnabled(!EventGlobalListFrame.this._synthesisChk.isSelected());
                EventGlobalListFrame.this._table.setRowSorter(EventGlobalListFrame.this._synthesisChk.isSelected() ? null : EventGlobalListFrame.this._sorterTable);
            }
        });
        panelList.add((Component)fieldsDlg, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(10, 10, 10, 10), 0, 0));
        fieldsDlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<PrefFieldBoolean> originItems = EventGlobalListFrame.this._modelTable.getColumnModel().getOptionnalFields();
                List<PrefFieldBoolean> copyItems = PrefFieldsFactory.clone(originItems);
                if (!PrefFieldsFactory.displayDlgChangeFields(EventGlobalListFrame.this._table, copyItems)) {
                    return;
                }
                boolean change = PrefFieldsFactory.copySelected(copyItems, originItems);
                if (change) {
                    EventGlobalListFrame.this._modelTable.getColumnModel().resetFilterIndexes();
                    EventGlobalListFrame.this._modelTable.refresh(false, true);
                }
            }
        });
        JScrollPane scrollTableItem = new JScrollPane(this._table);
        scrollTableItem.setComponentPopupMenu(this._popupMenu);
        scrollTableItem.setVerticalScrollBarPolicy(22);
        panelList.add((Component)scrollTableItem, new GridBagConstraints(0, 1, idxX, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)panelList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    public void toDoWhenBeOpened() {
        super.toDoWhenBeOpened();
        this.getAppl().getPreferencies().addPreferenciesListener(this);
    }

    @Override
    public void changePreferencies(Preferencies prefs) {
        this.getTable().changePreferencies(prefs);
    }

    @Override
    public void toDoWhenBeClosed() {
        this.getAppl().getPreferencies().removePreferenciesListener(this);
        super.toDoWhenBeClosed();
    }

    @Override
    public void toDoWhenActivated() {
        super.toDoWhenActivated();
        this.getAppl().getTopWindow().setEnabledAction("PRINT", true);
        this.getAppl().getTopWindow().setEnabledAction("PRINT_PREVIEW", true);
    }

    @Override
    public void toDoWhenDeActivated() {
        super.toDoWhenDeActivated();
        this.getAppl().getTopWindow().setEnabledAction("PRINT", false);
        this.getAppl().getTopWindow().setEnabledAction("PRINT_PREVIEW", false);
    }

    public List getPrintExportOptionnalFields() {
        PluginWithOptions prefs = this.getAppl().getPreferencies().getOptions(EGLPrintPreferencies.PREF_KEY);
        if (prefs == null || !(prefs instanceof EGLPrintPreferencies)) {
            prefs = new EGLPrintPreferencies();
            this.getAppl().getPreferencies().addOptions(prefs);
            prefs.refreshOptions(this.getAppl().getPlugable());
        }
        List<PrefFieldBoolean> listPrefs = ((PrefFieldsCategory)prefs).getBooleanFields();
        return listPrefs;
    }

    protected void exportXML(File input) {
        block6: {
            if (this._synthesisChk.isSelected()) {
                return;
            }
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new FileWriter(input));
                FTGlobEventUtility.exportToXML(out, this.getModel().getAllGlobEvent(), null);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (input.delete()) break block6;
                input.deleteOnExit();
            }
        }
    }

    protected void exportXMLForMEL(File input) {
        block7: {
            if (this._synthesisChk.isSelected()) {
                return;
            }
            int[] rowView = this._table.getSelectedRows();
            ArrayList<FTGlobEventAbstract> egl = new ArrayList<FTGlobEventAbstract>(rowView.length);
            for (int i = 0; i < rowView.length; ++i) {
                egl.add(this.getModel().getItem(this._sorterTable.convertRowIndexToModel(rowView[i])));
            }
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new FileWriter(input));
                FTGlobEventUtility.exportToXMLForMEL(out, egl, null);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (input.delete()) break block7;
                input.deleteOnExit();
            }
        }
    }

    private void makePopupMenu() {
        this._popupMenu = new JPopupMenu();
        this._itemExportForMEL = new JMenuItem(ResMsgObj.getString("EGL_EXPORT_MEL"));
        this._itemExportForMEL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File input = EventGlobalListFrame.this.displayDlgFile();
                if (input == null) {
                    return;
                }
                EventGlobalListFrame.this.exportXMLForMEL(input);
            }
        });
        this._popupMenu.add(this._itemExportForMEL);
        this._itemExportXML = new JMenuItem(ResMsgObj.getString("EGL_EXPORT_XML"));
        this._itemExportXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File input = EventGlobalListFrame.this.displayDlgFile();
                if (input == null) {
                    return;
                }
                EventGlobalListFrame.this.exportXML(input);
            }
        });
        this._popupMenu.add(this._itemExportXML);
    }

    protected JFileChooser getDlgChooser(String propertyDefaultPath) {
        if (_dlgChoose == null) {
            File pdir;
            _dlgChoose = new JFileChooser();
            FileFilterExtention defaultFilter = new FileFilterExtention(ResMsgCore.getString("FILE_TYPE_XML"), ".xml");
            _dlgChoose.addChoosableFileFilter(defaultFilter);
            _dlgChoose.setFileFilter(defaultFilter);
            _dlgChoose.setFileSelectionMode(0);
            File dir = new File(".");
            if (propertyDefaultPath != null && !(pdir = new File(propertyDefaultPath)).isDirectory()) {
                dir = pdir;
            }
            _dlgChoose.setCurrentDirectory(dir);
        }
        return _dlgChoose;
    }

    protected File displayDlgFile() {
        JFileChooser dlg = this.getDlgChooser(this.getAppl().getPlugable().getOption("plugable.option.path"));
        if (dlg.showSaveDialog(this) != 0) {
            return null;
        }
        File file = FileFilterExtention.addDefaultExtention(dlg);
        if (file == null) {
            return null;
        }
        this.getAppl().getPlugable().setOption("plugable.option.path", file.getParentFile().getAbsolutePath());
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("FILE_MSG_EXIST_FRM", file), this.getTitle(), 0)) {
            return file;
        }
        return null;
    }

    @Override
    public String getInfo(String key) {
        return null;
    }

    @Override
    public IModel getModel(String key) {
        if (!key.equals("docbook.file") && !key.equals("word.file")) {
            return null;
        }
        JChooserFileUtility.Type type = ExpBookUtility.convertModelKey(key);
        if (type == null) {
            return null;
        }
        File file = ExpBookUtility.selectFile(type, this.getAppl().getPlugable(), this, null, "EventGlobalList");
        if (file == null) {
            return null;
        }
        ExpBook book = this.prepareBook(this.getAppl().getPageFormat(), this.getAppl().getPreferencies());
        if (ExpBookUtility.realiseExport(book, file, this)) {
            return new IModel.DefaultModel(key, file);
        }
        return null;
    }

    protected ExpBook prepareBook(PageFormat format, Preferencies prefs) {
        ExpBook expBook = new ExpBook(this.getAppl().getDAOFactory());
        expBook.setPageFormat(format);
        expBook.setPreferencies(prefs);
        ExpInfo info = new ExpInfo(ResMsgObj.getString("EGL_TITLE"));
        info.setDate(new Date());
        info.setAuthor(this.getAppl().getDBUser().getName());
        expBook.setInfo(info);
        ExpSection section = new ExpSection(){

            @Override
            public String getTitle() {
                return ResMsgArbor.getString("KEY_1145");
            }
        };
        ExpEGLTable table = new ExpEGLTable(this._data);
        table.setSynthesis(this._synthesisChk.isSelected());
        table.setFilter(this.getModel().getFilter());
        section.add(table);
        expBook.add(section);
        return expBook;
    }

    protected Pageable createPageable(final PageFormat format, final Preferencies pref) {
        PageableThread thread = new PageableThread(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Pageable doCreatePageable() {
                ExpBook book = EventGlobalListFrame.this.prepareBook(format, pref);
                ListProcessorJavaInteractive printable = null;
                try (SrbInputStream scribe = new SrbInputStream("");){
                    book.writeScribe(scribe);
                }
                printable = new ListProcessorJavaInteractive(scribe);
                printable.processScribeFile();
                printable.computePageCount(format);
                return printable;
            }
        };
        thread.realiseDo();
        return thread.getPageable();
    }

    @Override
    public boolean preview() {
        Pageable fgPageable = this.createPageable(this.getDefaultPageFormat(), this.getAppl().getPreferencies());
        if (fgPageable == null) {
            return false;
        }
        PrintPreviewPrefsDlg dlg = new PrintPreviewPrefsDlg(JOptionCecilia.getWindowOf(this), fgPageable, this.getAppl(), new PrefFieldsCategory[]{(PrefFieldsCategory)this.getAppl().getPreferencies().getOptions(EGLPrintPreferencies.PREF_KEY)}){

            @Override
            public void updatePreferencies() {
                this.setBook(EventGlobalListFrame.this.createPageable(this.getFormat(), this.getPreferencies()));
            }
        };
        dlg.setLocationRelativeTo(JOptionCecilia.getWindowOf(this));
        dlg.setVisible(true);
        return true;
    }

    @Override
    public PageFormat getDefaultPageFormat() {
        return this.getAppl().getPageFormat();
    }

    static /* synthetic */ Logger access$1400() {
        return _LOG;
    }
}

