/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.action.UndoManager;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.TreeInfoCompute;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTComputeParameters;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquationBasic;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.SelectionPackage;
import com.dassault.cecilia.dbobj.faulttree.ft.export.XPortCfgTree;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationDatumUtility;
import com.dassault.cecilia.dbobj.faulttree.ft.io.FTEquationHandlerXml;
import com.dassault.cecilia.dbobj.faulttree.ft.io.MCSResultHandler;
import com.dassault.cecilia.dbobj.faulttree.ft.io.RAWConfigReader;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolConvert;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareFTEventResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultCheckSum;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.print.PageFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class FTEquation
extends FTEquationBasic {
    private static Logger _LOG = Logger.getLogger(FTEquation.class.getPackage().getName());
    String _criticityLevel = null;
    FTComputeParameters _ftParameters;
    public static final String PROP_COMPUTE_NO_LOCAL_CACHE = "cecilia.ft.compute.NoLocalCache";
    public static final int PROP_DEF_ARBOR_UNDO_LIMIT = 10;
    public static final String PROP_ARBOR_UNDO_LIMIT = "cecilia.ft.gui.UndoLimit";
    UndoManager _undoMng;
    List<FTConfig> _lstConfigs;
    Map<String, TreeInfoCompute> _infoComputes = new LinkedHashMap<String, TreeInfoCompute>();
    List<SelectionPackage.ChangeSelectionListener<FTVariableAbstract>> _changeSelectionListeners = new ArrayList<SelectionPackage.ChangeSelectionListener<FTVariableAbstract>>();
    List<ChangeListener> _changeEventsListeners = new ArrayList<ChangeListener>();
    private String _initialConfMBSA;
    private String _userGenerationMBSA;
    private String _lastModifDataMBSA;
    private String _modelPathMBSA;
    private String _targetMBSA;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public String getCriticityLevel() {
        return this._criticityLevel;
    }

    public FTEquation setCriticityLevel(String value) {
        this._criticityLevel = value;
        return this;
    }

    public FTComputeParameters getComputeParameters() {
        return this._ftParameters;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.getComputeParameters().setLastCRC(null);
    }

    public UndoManager getUndoManager() {
        return this._undoMng;
    }

    public List<FTConfig> getConfigs() {
        return this._lstConfigs;
    }

    public void setConfigs(List<FTConfig> cfgs) {
        this._lstConfigs = cfgs;
    }

    public FTConfig getConfig(String name) {
        for (int i = 0; i < this._lstConfigs.size(); ++i) {
            FTConfig cfg = this._lstConfigs.get(i);
            if (!cfg.getName().equals(name)) continue;
            return cfg;
        }
        return null;
    }

    public boolean addConfig(FTConfig cfg) {
        if (this.getConfig(cfg.getName()) != null) {
            return false;
        }
        this._lstConfigs.add(cfg);
        return true;
    }

    public FTEquation(DBFolder folder) {
        super(folder);
        this._ftParameters = new FTComputeParameters();
        this._lstConfigs = new ArrayList<FTConfig>();
        this._undoMng = new UndoManager(Integer.getInteger(PROP_ARBOR_UNDO_LIMIT, 10));
    }

    @Override
    public FTEquation getCopy() {
        FTEquation dest = new FTEquation(this._dbFolder);
        dest.copy(this);
        return dest;
    }

    @Override
    protected void copy(DBLogsWrap src) {
        super.copy(src);
        if (!(src instanceof FTEquation)) {
            return;
        }
        FTEquation ftEquSrc = (FTEquation)src;
        this._lstConfigs.clear();
        for (int i = 0; i < ftEquSrc._lstConfigs.size(); ++i) {
            FTConfig ftCfgSrc = ftEquSrc._lstConfigs.get(i);
            this._lstConfigs.add(ftCfgSrc.getCopy());
        }
        this._criticityLevel = ftEquSrc._criticityLevel;
        this._initialConfMBSA = ftEquSrc._initialConfMBSA;
        this._userGenerationMBSA = ftEquSrc._userGenerationMBSA;
        this._lastModifDataMBSA = ftEquSrc._lastModifDataMBSA;
        this._modelPathMBSA = ftEquSrc._modelPathMBSA;
        this._targetMBSA = ftEquSrc._targetMBSA;
        this._ftParameters = ftEquSrc._ftParameters.getCopy();
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(ResMsgArbor.getString("CFG_DLG_DSF_SUBTREE")).append("] ");
        sb.append(ResMsgArbor.getString("VOC_ROOT")).append(": ").append(this._ftTopEvent.getName());
        return sb.toString();
    }

    @Override
    public void prepareDependTimeUpdt(DAOFactory daoFactory, Collection<DBRelation> dbRelations) {
        super.prepareDependTimeUpdt(daoFactory, dbRelations);
        this.addProjectToDependTime();
    }

    @Override
    public void updateDependTimeUpdt(DAOFactory daoFactory, Collection<DBRelation> dbRelations) {
        super.updateDependTimeUpdt(daoFactory, dbRelations);
        this.addProjectToDependTime();
    }

    private final void addProjectToDependTime() {
        if (this._criticityLevel == null) {
            return;
        }
        DBFolder dbProject = this.getProjectFolder();
        if (dbProject.getObject() == null) {
            return;
        }
        if (this._dependFolders == null) {
            this._dependFolders = new LinkedHashMap();
        }
        this._dependFolders.put(dbProject, dbProject.getTimeUpdate());
    }

    private final DBFolder getProjectFolder() {
        DBFolder tmp = this.getDBFolder();
        while (!tmp.getParent().isSystem()) {
            tmp = tmp.getParent();
        }
        return tmp;
    }

    @Override
    public short getFamilyFlag() {
        return 2;
    }

    @Override
    protected String getNature() {
        return "tree.def";
    }

    @Override
    protected void toXML_others(Appendable out, String indent) throws IOException {
        super.toXML_others(out, indent);
        if (!this._lstConfigs.isEmpty()) {
            out.append(indent).append("<").append("ft.configs").append(">\n");
            String subindent = indent + "  ";
            for (FTConfig ftCfg : this._lstConfigs) {
                ftCfg.toXML(out, subindent);
            }
            out.append(indent).append("</").append("ft.configs").append(">\n");
        }
        if (this._criticityLevel != null) {
            out.append(indent).append("<").append("ft.criticity").append(' ').append("value='").append(this._criticityLevel).append('\'').append("/>\n");
        }
        if (this._ftParameters != null) {
            this._ftParameters.toXML(out, indent);
        }
        this.toXML_MBSA(out, indent);
    }

    @Override
    public Set<DBRelation> getUseRelations() {
        Collection relations = super.getUseRelations();
        for (FTConfig ftCfg : this._lstConfigs) {
            ftCfg.addRelation(this._dbFolder, "TREE_V", (Set<DBRelation>)relations);
        }
        return relations;
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String format = model.getFormat();
        if ("ARBOR".equals(format)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            InflaterInputStream def = new InflaterInputStream(istream, new Inflater());
            DBObjModel modelDag = this._dbFolder.getObject().getModel("tree.dag");
            if (modelDag == null) {
                this.logMsg("Le DBFolder/DBObject n'a pas de modele ayant la bonne nature 'tree.dag'", Level.INFO);
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_STRUCTURAL"));
                return false;
            }
            InputStream istream2 = cecFactory.createObjModelDAO().getBinaryStream(modelDag);
            if (istream2 == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            InflaterInputStream dag = new InflaterInputStream(istream2, new Inflater());
            if (!this.readRaw(dag, def, cecFactory, logMng)) {
                return false;
            }
            this._lstConfigs = new ArrayList<FTConfig>();
            for (DBObjModel current : this._dbFolder.getObject().getModels()) {
                if (!current.getNature().startsWith("dsf.config")) continue;
                new RAWConfigReader().read(current, cecFactory, this, logMng);
            }
            Collections.sort(this._lstConfigs, new Comparator<FTConfig>(){

                @Override
                public int compare(FTConfig o1, FTConfig o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            return true;
        }
        return super.readFromDBObjModel(model, cecFactory, logMng);
    }

    private boolean readRaw(InputStream dag, InputStream def, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result;
        EquBoolConvert ftConvert = new EquBoolConvert(cecFactory, logMng, this.isBigTree());
        if (this.isBigTree()) {
            ftConvert.setProcessLeaves(false);
        }
        if (result = ftConvert.readDag(new InputStreamReader(dag))) {
            result = ftConvert.readDef(new InputStreamReader(def));
        }
        if (result) {
            ftConvert.prepareEquation(this);
        }
        return result;
    }

    @Override
    protected boolean readXml(InputStream input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        FTEquationHandlerXml saxHanlder = new FTEquationHandlerXml(logMng, null, cecFactory);
        try {
            this.readXml(input, saxHanlder);
            if (!this.isBigTree()) {
                for (FTVariable var : saxHanlder.getVariables()) {
                    var.setExportName(null);
                }
            }
            this.setVariables(saxHanlder.getVariables(), logMng, true);
            if (!this.withLoopDefinition()) {
                this._lstConfigs = new ArrayList<FTConfig>(saxHanlder.getConfigs());
                for (int i = 0; i < this._lstConfigs.size(); ++i) {
                    this._lstConfigs.get(i).validateConfig(this._dbFolder, this.getWorkingRelations(), cecFactory, true);
                }
                this._ftParameters.setParameters(saxHanlder.getParameters());
                this.setCriticityLevel(saxHanlder.getCriticityLevel());
                this.setInitialConfMBSA(saxHanlder.getMBSAInitialConf());
                this.setUserGenerationMBSA(saxHanlder.getMBSAUserGeneration());
                this.setLastModifDataMBSA(saxHanlder.getMBSALastModifiedDateModel());
                this.setModelePathMBSA(saxHanlder.getMBSAModelPath());
                this.setTargetMBSA(saxHanlder.getMBSATarget());
                result = true;
            } else {
                this.getJavaLog().severe("Looped equation !!");
            }
        }
        catch (IOException e) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC"));
        }
        return result;
    }

    public void clearInfoComputes() {
        for (TreeInfoCompute icompute : this._infoComputes.values()) {
            icompute.clean();
        }
        this._infoComputes.clear();
    }

    public Map<String, TreeInfoCompute> getInfoComputes() {
        return this._infoComputes;
    }

    public void addChangeSelectionListener(SelectionPackage.ChangeSelectionListener<FTVariableAbstract> listener) {
        if (!this._changeSelectionListeners.contains(listener)) {
            this._changeSelectionListeners.add(listener);
        }
    }

    public void removeChangeSelectionListener(SelectionPackage.ChangeSelectionListener<FTVariableAbstract> listener) {
        this._changeSelectionListeners.remove(listener);
    }

    public void fireChangeSelection(SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> event, Component owner) {
        event.setOwner(owner);
        for (SelectionPackage.ChangeSelectionListener<FTVariableAbstract> listener : this._changeSelectionListeners) {
            listener.changeSelection(event);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this._changeEventsListeners.contains(listener)) {
            this._changeEventsListeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeEventsListeners.remove(listener);
    }

    public void fireChangeEvents(Collection<? extends FTVariableAbstract> vars, Component source) {
        for (ChangeListener listener : this._changeEventsListeners) {
            listener.changeEvents(vars, source);
        }
    }

    public void fireChangeDefinitions(Collection<FTVariable> vars, Component source) {
        for (ChangeListener listener : this._changeEventsListeners) {
            listener.changeDefinitions(vars, source);
        }
    }

    public void loadMCSAbstract(InputStream inputStream) throws IOException {
        MCSResultHandler handler = null;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            handler = new MCSResultHandler(this);
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(inputStream, (DefaultHandler)handler);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append("SAX Parser Exception\n");
            sb.append(e.getMessage());
            throw new IOException(sb.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCurrentResults(DBUser dbUser, CECFactory daoFactory) {
        FTComputeParameters parameters = this.getComputeParameters();
        String strConfig = parameters.getConfigName();
        if (strConfig == null) {
            return;
        }
        if (strConfig.isEmpty()) {
            return;
        }
        FTConfig ftConfig = this.getConfig(strConfig);
        if (ftConfig == null ? !strConfig.equals("Default") : !ftConfig.verifyRight(dbUser, daoFactory)) {
            return;
        }
        String lastCRC = parameters.getLastCRC();
        if (lastCRC == null) {
            return;
        }
        if (lastCRC.isEmpty()) {
            return;
        }
        String strType = "MCS.Abstract";
        TreeInfoCompute icompute = this.findInfoCompute(daoFactory.createObjModelDAO(), strType, strConfig, lastCRC);
        if (icompute == null) {
            return;
        }
        File file = icompute.getInputFiles().get("result.abstract");
        if (file != null) {
            InputStream inStream = null;
            try {
                inStream = new BufferedInputStream(new FileInputStream(file));
                this.loadMCSAbstract(inStream);
            }
            catch (IOException e) {
                _LOG.log(Level.SEVERE, "Error during load 'result.abstract'", e);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        _LOG.log(Level.INFO, "Error during close 'result.abstract'", e);
                    }
                }
            }
        }
    }

    public TreeInfoCompute findInfoCompute(DAOObjModel daoObjModel, String strType, String strConfig, String crcDag) {
        String mapKey = strType + "." + strConfig;
        TreeInfoCompute icompute = null;
        if (!Boolean.getBoolean(PROP_COMPUTE_NO_LOCAL_CACHE)) {
            icompute = this.getInfoComputes().get(mapKey);
        }
        if (icompute == null) {
            String nature = DBObjModel.constructNature("tree.compute", strConfig, strType);
            DBObjModel modelXTra = this._dbFolder.getObject().getModel(nature);
            if (modelXTra == null) {
                _LOG.finest(StringUtilities.STR((String[])new String[]{"Pas de resultat sauvegarde : ", this._dbFolder.getRefPath(), ", ", strType, ", ", strConfig}));
            } else if (crcDag != null && !modelXTra.getCRC().equals(crcDag)) {
                _LOG.fine(StringUtilities.STR((String[])new String[]{"CRC different pour les resultats sauvegardes : ", this._dbFolder.getRefPath(), ", ", strType, ", ", strConfig, ", ", modelXTra.getCRC()}));
            } else {
                InputStream stream = daoObjModel.getBinaryStream(modelXTra);
                if (stream == null) {
                    _LOG.warning(StringUtilities.STR((String[])new String[]{"Probleme de lecture DAO pour les resultats sauvegardes : ", this._dbFolder.getRefPath(), ", ", strType, ", ", strConfig, ", ", modelXTra.getCRC()}));
                } else {
                    try {
                        icompute = new TreeInfoCompute(stream);
                        if (strType.endsWith(".Abstract")) {
                            boolean fullData = false;
                            String realNature = DBObjModel.constructNature("tree.compute", strConfig, strType.substring(0, strType.length() - ".Abstract".length()));
                            DBObjModel realModel = this._dbFolder.getObject().getModel(realNature);
                            if (realModel == null) {
                                _LOG.info(StringUtilities.STR((String[])new String[]{"Pas de resultat sauvegarde 'complet' associe a l'abstract : ", this._dbFolder.getRefPath(), ", ", strType, ", ", strConfig}));
                            } else if (crcDag != null && !realModel.getCRC().equals(crcDag)) {
                                _LOG.info(StringUtilities.STR((String[])new String[]{"CRC different pour les resultats sauvegardes 'complet' associe a l'abstract : ", this._dbFolder.getRefPath(), ", ", strType, ", ", strConfig, ", ", modelXTra.getCRC()}));
                            } else {
                                fullData = true;
                            }
                            icompute.getParameters().put("FullData", Boolean.toString(fullData));
                        }
                        this.getInfoComputes().put(mapKey, icompute);
                    }
                    catch (IOException ex) {
                        _LOG.log(Level.WARNING, StringUtilities.STR((String[])new String[]{"probleme lors de la lecture des resultats sauvegardes : ", this._dbFolder.getRefPath(), ", ", strType, ", ", strConfig}), ex);
                    }
                }
            }
        }
        return icompute;
    }

    public IModel exportDocbookModel(String key, CeciliaAppl appl, XPortCfgTree.TypeExport config, File file, PageFormat pageFormat, int levelGSR) {
        ExpBook book = new ExpBook(appl.getDAOFactory());
        if (pageFormat == null) {
            book.setPageFormat(appl.getPageFormat());
        } else {
            book.setPageFormat(pageFormat);
        }
        book.setPreferencies(appl.getPreferencies());
        XPortCfgTree xport = new XPortCfgTree();
        xport.setTypeExport(config);
        if (levelGSR > 0) {
            xport.configLevelGSR(levelGSR);
        }
        xport.configBook(book, this);
        if (ExpBookUtility.realiseExport(book, file, appl.getTopWindow())) {
            return new IModel.DefaultModel(key, file);
        }
        return null;
    }

    public List<CriticityCriterion> getProjectCriticities(CeciliaAppl appl) {
        ArrayList<CriticityCriterion> criterions = new ArrayList<CriticityCriterion>();
        DBFolder treeFolder = this.getDBFolder().getParent();
        if (treeFolder == null) {
            return criterions;
        }
        DBFolder systemFolder = treeFolder.getParent();
        if (systemFolder == null) {
            return criterions;
        }
        DBFolder projectFolder = systemFolder.getParent();
        if (projectFolder == null) {
            return criterions;
        }
        DBProject project = (DBProject)appl.getDAOFactory().findOrCreateWrap(projectFolder);
        if (project == null) {
            return criterions;
        }
        criterions.addAll(project.getCriticityCriterium());
        return criterions;
    }

    public CriticityCriterion getCurrentCriterion(CeciliaAppl appl) {
        if (this.getCriticityLevel() == null) {
            return null;
        }
        List<CriticityCriterion> criticities = this.getProjectCriticities(appl);
        for (CriticityCriterion criticity : criticities) {
            String name = criticity.getName();
            if (!this.getCriticityLevel().equals(name)) continue;
            return criticity;
        }
        return null;
    }

    protected List<Function<DBWrap, CompareResult>> getParticularFieldsToCompare(DAOFactory factory) {
        ArrayList<Function<DBWrap, CompareResult>> list = new ArrayList<Function<DBWrap, CompareResult>>();
        return list;
    }

    @Override
    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        List<Function<DBWrap, CompareResult>> list = super.getFieldsToCompare(factoryWrap, forImport);
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                String crit1 = FTEquation.this.getCriticityLevel();
                String crit2 = ((FTEquation)wrap).getCriticityLevel();
                return new CompareResultString(ResMsgVoc.getString("VOC_CRITICITY"), crit1, crit2);
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                Function<FTEquation, String> func = ft -> {
                    List<FTConfig> configs = ft.getConfigs();
                    StringBuilder sb = new StringBuilder();
                    for (FTConfig config : configs) {
                        sb.append(config.getName()).append('\n');
                    }
                    String configNames = sb.toString();
                    String defConf = null;
                    for (FTConfig conf : configs) {
                        if (!conf.isDefault()) continue;
                        defConf = conf.getName();
                    }
                    return defConf != null ? configNames.replace(defConf + '\n', "*" + defConf + '\n') : configNames;
                };
                return new CompareResultString(ResMsgVoc.getString("VOC_CONFIGURATION"), func.apply(FTEquation.this), func.apply((FTEquation)wrap));
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                FTComputeParameters parameters1 = FTEquation.this.getComputeParameters();
                FTComputeParameters parameters2 = ((FTEquation)wrap).getComputeParameters();
                return new CompareResultString(ResMsgVoc.getString("VOC_PARAMETERS"), parameters1 != null ? parameters1.getAbstract() : "", parameters2 != null ? parameters2.getAbstract() : "");
            }
        });
        if (!forImport) {
            list.add(new Function<DBWrap, CompareResult>(){

                @Override
                public CompareResult apply(DBWrap wrap) {
                    long cs1 = FTEquation.this.getChecksumResult();
                    long cs2 = ((FTEquation)wrap).getChecksumResult();
                    return new CompareResultCheckSum(ResMsgVoc.getString("VOC_RESULTS"), cs1, cs2);
                }
            });
        }
        list.addAll(this.getParticularFieldsToCompare(factoryWrap));
        return list;
    }

    @Override
    public DBComparaisons getCompareConflict(DAOFactory factoryWrap, DBWrap wrap, boolean forImport) {
        DBComparaisons compare = super.getCompareConflict(factoryWrap, wrap, forImport);
        CompareUtils.addConflictInDBWrap(compare, this, wrap, var -> ((FTVariableAbstract)var).getName(), equ -> ((FTEquation)equ).getAllVariables(), CompareFTEventResult.class);
        return compare;
    }

    private long getChecksumResult() {
        CeciliaAppl appl = (CeciliaAppl)CeciliaAppl.getInstance();
        FTEquationDatumUtility datumUtility = new FTEquationDatumUtility(this, appl.getTopWindow(), appl);
        long sumCheckSum = 0L;
        DBObject obj = this.getDBFolder().getObject();
        for (DBObjModel model : obj.getModels()) {
            String nature = model.getNature();
            if (nature == null || !nature.toLowerCase().startsWith("Tree.Compute.".toLowerCase())) continue;
            sumCheckSum += this.getCheckSum(appl, datumUtility, nature);
        }
        return sumCheckSum;
    }

    private long getCheckSum(CeciliaAppl appl, FTEquationDatumUtility datumUtility, String nature) {
        long sumCheckSum = 0L;
        String confType = nature.substring("Tree.Compute.".length(), nature.length());
        String conf = confType.substring(0, confType.indexOf(46));
        String type = confType.substring(confType.indexOf(46) + 1, confType.length());
        StringBuilder sb = new StringBuilder();
        sb.append("Tree.Compute.");
        sb.append(type);
        sb.append('@');
        sb.append(conf);
        TreeInfoCompute cmpt = datumUtility.getDatum(sb.toString());
        if (cmpt == null) {
            return sumCheckSum;
        }
        DBLogs.DefaultManager mng = new DBLogs.DefaultManager(appl.getDBUser().getLogin(), new DBLogs());
        ArrayList<File> resultFiles = new ArrayList<File>();
        for (Map.Entry<String, File> entry : cmpt.getInputFiles().entrySet()) {
            if (entry.getKey() == null || !entry.getKey().startsWith("result")) continue;
            resultFiles.add(entry.getValue());
        }
        try {
            for (File resultFile : resultFiles) {
                sumCheckSum += this.getCheckSumFile(mng, new FileInputStream(resultFile));
            }
            return sumCheckSum;
        }
        catch (IOException error) {
            return 0L;
        }
    }

    public String getInitialConfMBSA() {
        return this._initialConfMBSA;
    }

    public boolean withMBSAExportFields() {
        return this.getInitialConfMBSA() != null || this.getModelePathMBSA() != null || this.getTargetMBSA() != null;
    }

    public void setInitialConfMBSA(String initialConfMBSA) {
        this._initialConfMBSA = initialConfMBSA;
    }

    public String getUserGenerationMBSA() {
        return this._userGenerationMBSA;
    }

    public void setUserGenerationMBSA(String userGenerationMBSA) {
        this._userGenerationMBSA = userGenerationMBSA;
    }

    public String getLastModifDataMBSA() {
        return this._lastModifDataMBSA;
    }

    public void setLastModifDataMBSA(String lastModifDataMBSA) {
        this._lastModifDataMBSA = lastModifDataMBSA;
    }

    public String getModelePathMBSA() {
        return this._modelPathMBSA;
    }

    public void setModelePathMBSA(String modelePathMBSA) {
        this._modelPathMBSA = modelePathMBSA;
    }

    public String getTargetMBSA() {
        return this._targetMBSA;
    }

    public void setTargetMBSA(String targetMBSA) {
        this._targetMBSA = targetMBSA;
    }

    public void toXML_MBSA(Appendable out, String indent) throws IOException {
        if (this._initialConfMBSA == null && this._userGenerationMBSA == null && this._lastModifDataMBSA == null && this._modelPathMBSA == null && this._targetMBSA == null) {
            return;
        }
        out.append(indent);
        out.append('<');
        out.append("ft.mbsafields");
        if (this._initialConfMBSA != null) {
            this.writeAttribute(out, "mbsaInitialConf", this._initialConfMBSA);
        }
        if (this._userGenerationMBSA != null) {
            this.writeAttribute(out, "mbsaUserGeneration", this._userGenerationMBSA);
        }
        if (this._lastModifDataMBSA != null) {
            this.writeAttribute(out, "mbsaLastModif", this._lastModifDataMBSA);
        }
        if (this._modelPathMBSA != null) {
            this.writeAttribute(out, "mbsaModelPath", this._modelPathMBSA);
        }
        if (this._targetMBSA != null) {
            this.writeAttribute(out, "mbsaTarget", this._targetMBSA);
        }
        out.append("/>\n");
    }

    private final void writeAttribute(Appendable out, String att, String value) throws IOException {
        out.append(' ').append(att).append("=\"").append(value).append('\"');
    }

    public static interface ChangeListener {
        public void changeEvents(Collection<? extends FTVariableAbstract> var1, Component var2);

        public void changeDefinitions(Collection<FTVariable> var1, Component var2);
    }
}

