/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import java.io.IOException;
import java.util.List;

public class ExpFTConfigs
extends ExpSection {
    List<FTConfig> _ftConfigs;

    public ExpFTConfigs(List<FTConfig> ftConfigs) {
        this._ftConfigs = ftConfigs;
    }

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        boolean withConfigs = false;
        if (this._ftConfigs.size() > 1) {
            withConfigs = true;
        } else if (this._ftConfigs.size() == 1) {
            FTConfig ftDefault = this._ftConfigs.get(0);
            if (!ftDefault.getLabel().isEmpty()) {
                withConfigs = true;
            } else if (!ftDefault.getDSFItems().isEmpty()) {
                withConfigs = true;
            } else if (!ftDefault.getCCFItems().isEmpty()) {
                withConfigs = true;
            }
        }
        if (!withConfigs) {
            return;
        }
        super.writeDocbook(output);
    }

    @Override
    public String getTitle() {
        return ResMsgArbor.getString("CFG_DLG_TITLE");
    }

    @Override
    protected void writeContentDocbook(DBKOutput output) throws IOException {
        super.writeContentDocbook(output);
        if (Boolean.getBoolean("cecilia.exp.docbook.ft.configs.withouttable")) {
            output.write("<itemizedlist spacing='compact'>\n", false);
            output.addIndent(1);
            for (int i = 0; i < this._ftConfigs.size(); ++i) {
                FTConfig ftConfig = this._ftConfigs.get(0);
                output.write("<listitem><para>\n", false);
                output.addIndent(1);
                output.write("<simpara>", false);
                if (ftConfig.isDefault()) {
                    output.write("<emphasis>", false);
                }
                output.write(ftConfig.getName(), true);
                if (ftConfig.isDefault()) {
                    output.write("</emphasis>\n", false);
                }
                output.write("</simpara>\n", false);
                if (!ftConfig.getLabel().isEmpty()) {
                    output.write("<simpara>", false);
                    output.write(ftConfig.getLabel(), true);
                    output.write("</simpara>\n", false);
                }
                if (!ftConfig.getDSFItems().isEmpty() || !ftConfig.getCCFItems().isEmpty()) {
                    output.write("<simpara>", false);
                    output.write(ftConfig.toString(), true);
                    output.write("</simpara>\n", false);
                }
                output.addIndent(-1);
                output.write("</para></listitem>\n", false);
            }
            output.addIndent(-1);
            output.write("</itemizedlist>\n", false);
        } else {
            ExpTableFTConfigs expTable = new ExpTableFTConfigs(this._ftConfigs);
            expTable.setContainer(this);
            expTable.writeDocbook(output);
        }
    }

    static class ExpTableFTConfigs
    extends ExpTable {
        List<FTConfig> _ftConfigs;

        public ExpTableFTConfigs(List<FTConfig> ftConfigs) {
            this._ftConfigs = ftConfigs;
        }

        @Override
        protected int getColumnCount() {
            return 3;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_COMMENT");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_CONFIGURATIONS");
                }
            }
            return "???";
        }

        @Override
        protected int getRowCount() {
            return this._ftConfigs.size();
        }

        @Override
        protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
            FTConfig ftConfig = this._ftConfigs.get(row);
            switch (col) {
                case 0: {
                    if (ftConfig.isDefault()) {
                        output.write("<emphasis>", false);
                    }
                    output.write(ftConfig.getName(), true);
                    if (!ftConfig.isDefault()) break;
                    output.write("</emphasis>", false);
                    break;
                }
                case 1: {
                    output.write(ftConfig.getLabel(), true);
                    break;
                }
                case 2: {
                    if (Boolean.getBoolean("cecilia.exp.docbook.use.sbr")) {
                        output.write("\n", false);
                        output.addIndent(1);
                        boolean firstline = false;
                        for (FTConfig.DSFConfigItem dSFConfigItem : ftConfig.getDSFItems()) {
                            if (!dSFConfigItem.isEnable() && !dSFConfigItem.isOnlyFRB()) continue;
                            if (firstline) {
                                output.write("<sbr/>\n", false);
                            }
                            output.write(ResMsgArbor.getString("CFG_DLG_DSF"), true);
                            output.write("[", true);
                            output.write(dSFConfigItem.getDBFolder().getRefPath(), true);
                            output.write("] ", true);
                            output.write(ResMsgArbor.getString(dSFConfigItem.isFRB() ? "CFG_DLG_DSF_FRB" : "CFG_DLG_DSF_SUBTREE"), true);
                            firstline = true;
                        }
                        int j = 0;
                        for (FTConfig.CCFConfigItem ccfCfg : ftConfig.getCCFItems()) {
                            if (!ccfCfg.isEnable()) continue;
                            if (j == 0) {
                                if (firstline) {
                                    output.write("<sbr/>\n", false);
                                }
                                output.write(ResMsgArbor.getString("CFG_DLG_CCF"), true);
                                output.write(" : ", true);
                                firstline = true;
                            } else if (j % 3 == 0) {
                                if (firstline) {
                                    output.write("<sbr/>\n", false);
                                }
                                output.write(ResMsgArbor.getString("CFG_DLG_CCF"), true);
                                output.write(" : ", true);
                                firstline = true;
                            } else {
                                output.write(", ", true);
                            }
                            output.write(ccfCfg.getDBFolder().getRefPath(), true);
                            ++j;
                        }
                        output.addIndent(-1);
                        break;
                    }
                    output.write("\n", false);
                    output.addIndent(1);
                    boolean withInfo = false;
                    if (!withInfo) {
                        for (FTConfig.DSFConfigItem dSFConfigItem : ftConfig.getDSFItems()) {
                            if (!dSFConfigItem.isEnable() && !dSFConfigItem.isOnlyFRB()) continue;
                            withInfo = true;
                            break;
                        }
                    }
                    if (!withInfo) {
                        for (FTConfig.CCFConfigItem cCFConfigItem : ftConfig.getCCFItems()) {
                            if (!cCFConfigItem.isEnable()) continue;
                            withInfo = true;
                            break;
                        }
                    }
                    if (withInfo) {
                        output.write("<itemizedlist spacing='compact' mark='none'>\n", false);
                        output.addIndent(1);
                        for (FTConfig.DSFConfigItem dSFConfigItem : ftConfig.getDSFItems()) {
                            if (!dSFConfigItem.isEnable() && !dSFConfigItem.isOnlyFRB()) continue;
                            output.write("<listitem>", false);
                            output.write(ResMsgArbor.getString("CFG_DLG_DSF"), true);
                            output.write("[", true);
                            output.write(dSFConfigItem.getDBFolder().getRefPath(), true);
                            output.write("] ", true);
                            output.write(ResMsgArbor.getString(dSFConfigItem.isFRB() ? "CFG_DLG_DSF_FRB" : "CFG_DLG_DSF_SUBTREE"), true);
                            output.write("</listitem>\n", false);
                        }
                        int j = 0;
                        for (FTConfig.CCFConfigItem ccfCfg : ftConfig.getCCFItems()) {
                            if (!ccfCfg.isEnable()) continue;
                            if (j == 0) {
                                output.write("<listitem>", false);
                                output.write(ResMsgArbor.getString("CFG_DLG_CCF"), true);
                                output.write(" : ", true);
                            } else if (j % 3 == 0) {
                                output.write("</listitem>\n", false);
                                output.write("<listitem>", false);
                                output.write(ResMsgArbor.getString("CFG_DLG_CCF"), true);
                                output.write(" : ", true);
                            } else {
                                output.write(", ", true);
                            }
                            output.write(ccfCfg.getDBFolder().getRefPath(), true);
                            ++j;
                        }
                        if (j > 0) {
                            output.write("</listitem>\n", false);
                        }
                        output.addIndent(-1);
                        output.write("</itemizedlist>\n", false);
                    }
                    output.addIndent(-1);
                    break;
                }
            }
        }

        @Override
        protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idx) {
            FTConfig ftConfig = this._ftConfigs.get(row);
            switch (col) {
                case 0: {
                    buffer.append(ftConfig.getName());
                    break;
                }
                case 1: {
                    buffer.append(ftConfig.getLabel());
                    break;
                }
                case 2: {
                    boolean firstline = false;
                    for (FTConfig.DSFConfigItem dsfCfg : ftConfig.getDSFItems()) {
                        if (!dsfCfg.isEnable() && !dsfCfg.isOnlyFRB()) continue;
                        if (firstline) {
                            buffer.append(", ");
                        }
                        buffer.append(ResMsgArbor.getString("CFG_DLG_DSF"));
                        buffer.append("[");
                        buffer.append(dsfCfg.getDBFolder().getRefPath());
                        buffer.append("] ");
                        buffer.append(ResMsgArbor.getString(dsfCfg.isFRB() ? "CFG_DLG_DSF_FRB" : "CFG_DLG_DSF_SUBTREE"));
                        firstline = true;
                    }
                    int j = 0;
                    for (FTConfig.CCFConfigItem ccfCfg : ftConfig.getCCFItems()) {
                        if (!ccfCfg.isEnable()) continue;
                        if (j == 0) {
                            if (firstline) {
                                buffer.append(", ");
                            }
                            buffer.append(ResMsgArbor.getString("CFG_DLG_CCF"));
                            buffer.append(" : ");
                            firstline = true;
                        } else if (j % 3 == 0) {
                            if (firstline) {
                                buffer.append(", ");
                            }
                            buffer.append(ResMsgArbor.getString("CFG_DLG_CCF"));
                            buffer.append(" : ");
                            firstline = true;
                        } else {
                            buffer.append(", ");
                        }
                        buffer.append(ccfCfg.getDBFolder().getRefPath());
                        ++j;
                    }
                    break;
                }
            }
        }
    }
}

