/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmd;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTUtilCmdChangeGeneric;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.gui.FTEventsDlgEdit;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;

public class FTCmdEventsEdit
extends FTCmd {
    String _names;
    ArrayList<FTVariable> _selectVars;
    ArrayList<FTEvent> _selectEvents;
    ArrayList<FTEvent> _previousEvents;
    ArrayList<String> _previousLabel;
    FTEventsDlgEdit _dlg;
    Component _source;
    FTUtilCmdChangeGeneric _utilGeneric;

    public FTCmdEventsEdit(CeciliaAppl appl, FTEquationFrame frame, String names, Collection<FTVariable> selectVars, Component source) {
        super(appl, frame);
        this._names = names;
        this._selectVars = new ArrayList<FTVariable>(selectVars);
        int size = this._selectVars.size();
        this._selectEvents = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this._selectEvents.add(this._selectVars.get(i).getEvent());
        }
        this._utilGeneric = null;
    }

    @Override
    protected boolean prepareDo() {
        FTUtilCmdChangeGeneric utilGeneric;
        if (!super.prepareDo()) {
            return false;
        }
        this._dlg = FTEventsDlgEdit.getInstance(SwingUtilities.getWindowAncestor(this.getSource()), this.getAppl(), ResMsgObj.getString("TITLE_EVENTS") + " : " + this._names.toString());
        this._dlg.setForBigTree(this.getSource().getDBWrap().isBigTree());
        this._dlg.setEvents(this._selectEvents);
        this._dlg.setVisible(true);
        if (!this._dlg.getResult()) {
            return false;
        }
        if (this._dlg.changeGeneric() && (utilGeneric = new FTUtilCmdChangeGeneric(this._ftEquation, this._selectVars, this._dlg.getGeneric())).prepareDo()) {
            this._utilGeneric = utilGeneric;
            this._selectVars.addAll(utilGeneric.getChangeVars());
        }
        return true;
    }

    @Override
    protected void firstDo() {
        this._previousEvents = new ArrayList(this._selectEvents.size());
        this._previousLabel = new ArrayList(this._selectEvents.size());
        for (int i = 0; i < this._selectEvents.size(); ++i) {
            FTEvent ftEvt = this._selectEvents.get(i);
            this._previousEvents.add(ftEvt.getCopy());
            this._previousLabel.add(ftEvt.getLabel());
        }
        this.redo();
        this.getSource().addHisto(this);
    }

    @Override
    public void redo() {
        this._dlg.affectEvents(this._selectEvents);
        if (this._utilGeneric != null) {
            this._utilGeneric.redo();
        }
        this._ftEquation.clearResults();
        this.refreshEvents();
        this._ftEquation.updateDependTimeUpdt(this.getAppl().getDAOFactory(), this._ftEquation.getWorkingRelations());
    }

    @Override
    public void undo() {
        for (int i = 0; i < this._selectEvents.size(); ++i) {
            FTEvent ftEvt = this._selectEvents.get(i);
            ftEvt.copy(this._previousEvents.get(i));
            ftEvt.setLabel(this._previousLabel.get(i));
        }
        if (this._utilGeneric != null) {
            this._utilGeneric.undo();
        }
        this._ftEquation.clearResults();
        this.refreshEvents();
        this._ftEquation.updateDependTimeUpdt(this.getAppl().getDAOFactory(), this._ftEquation.getWorkingRelations());
    }

    protected void refreshEvents() {
        this._ftEquation.fireChangeEvents(this._selectVars, this._source);
        this._ftEquation.setModified(true);
    }
}

