/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.obj;

import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FTDefinition {
    private static Logger _LOG = Logger.getLogger(FTDefinition.class.getPackage().getName());
    public static final String PROP_ARALIA4_PATCHXOR = "cecilia.ft.PatchXor";
    Type _type;
    ArrayList<FTVariableAbstract> _args;
    boolean _bGSR;
    int _atLeast;

    private static ImageIcon getImageIcon(String key) {
        return ResIcoArbor.getImageIcon(key, ResIcoArbor.getDpiScaledValue((int)40));
    }

    private FTDefinition(Type type, int size) {
        this._type = type;
        this._args = new ArrayList(size);
        this._bGSR = false;
        this._atLeast = 1;
    }

    public FTDefinition(Type type, FTVariableAbstract ... args) {
        this(type, Arrays.asList(args));
    }

    public FTDefinition(Type type, Collection<? extends FTVariableAbstract> args) {
        this._type = type;
        this._args = new ArrayList<FTVariableAbstract>(args);
        this._bGSR = false;
        this._atLeast = 1;
    }

    public Type getType() {
        return this._type;
    }

    public FTDefinition setType(Type value) {
        this._type = value;
        return this;
    }

    public boolean isGSR() {
        return this._bGSR;
    }

    public FTDefinition setGSR(boolean value) {
        this._bGSR = value;
        return this;
    }

    public Collection<FTVariableAbstract> getArgs() {
        return this._args;
    }

    public FTDefinition setArgs(Collection<FTVariableAbstract> args) {
        this._args = new ArrayList<FTVariableAbstract>(args);
        return this;
    }

    public int getAtLeast() {
        return this._atLeast;
    }

    public FTDefinition setAtLeast(int value) {
        this._atLeast = value;
        return this;
    }

    public FTDefinition getCopy(CopyUtility util) {
        FTDefinition result = new FTDefinition(this._type, this._args.size());
        result._bGSR = this._bGSR;
        result._atLeast = this._atLeast;
        for (int i = 0; i < this._args.size(); ++i) {
            result._args.add(this._args.get(i).getCopy(util));
        }
        return result;
    }

    private void writeEqu(Appendable out, boolean withPatch, boolean lexicalOrder) throws IOException {
        switch (this._type) {
            case AND: 
            case OR: {
                Iterator<FTVariableAbstract> i;
                out.append("( ");
                if (lexicalOrder) {
                    ArrayList<FTVariableAbstract> sort = new ArrayList<FTVariableAbstract>(this._args);
                    Collections.sort(sort, FTVariableAbstract.getComparatorName());
                    i = sort.iterator();
                } else {
                    i = this._args.iterator();
                }
                while (i.hasNext()) {
                    out.append(i.next().getExportName());
                    if (!i.hasNext()) continue;
                    out.append(" ").append(this._type.getDagSep()).append(" ");
                }
                out.append(" )");
                break;
            }
            case XOR: 
            case NXOR: {
                Iterator<FTVariableAbstract> i;
                if (withPatch && Boolean.getBoolean(PROP_ARALIA4_PATCHXOR)) {
                    ArrayList<String> sons = new ArrayList<String>(this._args.size());
                    for (FTVariableAbstract ftArg : this._args) {
                        sons.add(ftArg.getExportName());
                    }
                    if (lexicalOrder) {
                        Collections.sort(sons);
                    }
                    if (this._type == Type.NXOR) {
                        out.append("-");
                    }
                    out.append("(");
                    FTDefinition.ecrireXORAralia4(out, sons);
                    out.append(")");
                    break;
                }
                out.append("( ");
                if (lexicalOrder) {
                    ArrayList<FTVariableAbstract> sort = new ArrayList<FTVariableAbstract>(this._args);
                    Collections.sort(sort, FTVariableAbstract.getComparatorName());
                    i = sort.iterator();
                } else {
                    i = this._args.iterator();
                }
                while (i.hasNext()) {
                    out.append(i.next().getExportName());
                    if (!i.hasNext()) continue;
                    out.append(" ").append(this._type.getDagSep()).append(" ");
                }
                out.append(" )");
                break;
            }
            case NAND: 
            case NOR: {
                Iterator<FTVariableAbstract> i;
                out.append("-( ");
                if (lexicalOrder) {
                    ArrayList<FTVariableAbstract> sort = new ArrayList<FTVariableAbstract>(this._args);
                    Collections.sort(sort, FTVariableAbstract.getComparatorName());
                    i = sort.iterator();
                } else {
                    i = this._args.iterator();
                }
                while (i.hasNext()) {
                    out.append(i.next().getExportName());
                    if (!i.hasNext()) continue;
                    out.append(" ").append(this._type.getDagSep()).append(" ");
                }
                out.append(" )");
                break;
            }
            case ITE: {
                Iterator<FTVariableAbstract> i = this._args.iterator();
                out.append("( ");
                out.append(i.next().getExportName());
                out.append(" ? ");
                out.append(i.next().getExportName());
                out.append(" : ");
                out.append(i.next().getExportName());
                out.append(" )");
                break;
            }
            case KOFN: {
                Iterator<FTVariableAbstract> i;
                out.append("@(").append(Integer.toString(this._atLeast)).append(", [");
                if (lexicalOrder) {
                    ArrayList<FTVariableAbstract> sort = new ArrayList<FTVariableAbstract>(this._args);
                    Collections.sort(sort, FTVariableAbstract.getComparatorName());
                    i = sort.iterator();
                } else {
                    i = this._args.iterator();
                }
                while (i.hasNext()) {
                    out.append(i.next().getExportName());
                    if (!i.hasNext()) continue;
                    out.append(", ");
                }
                out.append("] )");
                break;
            }
            case NOT: {
                Iterator<FTVariableAbstract> i = this._args.iterator();
                out.append("-");
                out.append(i.next().getExportName());
            }
        }
    }

    public void writeEqu(Appendable out) throws IOException {
        this.writeEqu(out, true, false);
    }

    public String toString() {
        StringBuilder out = new StringBuilder(256);
        try {
            this.writeEqu(out, false, false);
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "A priori impossible!", e);
        }
        return out.toString();
    }

    public String toStringWithLexcalOrder() {
        StringBuilder out = new StringBuilder(256);
        try {
            this.writeEqu(out, false, true);
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "A priori impossible!", e);
        }
        return out.toString();
    }

    public void toXML(Appendable out, String indent, long id) throws IOException {
        out.append(indent).append("<").append("ft.equ");
        out.append(" ").append("id").append("='").append(Long.toString(id)).append("'");
        out.append(" ").append("type").append("='").append(this.getType().toXML()).append("'");
        if (this.getType() == Type.KOFN) {
            out.append(" ").append("atLeast").append("='").append(Integer.toString(this._atLeast)).append("'");
        }
        if (this.isGSR()) {
            out.append(" ").append("isGSR").append("='true'");
        }
        if (this.getType() != Type.VAR) {
            out.append(" ").append("children").append("='");
            Iterator<FTVariableAbstract> i = this._args.iterator();
            while (i.hasNext()) {
                out.append(Long.toString(i.next().getInternalID()));
                if (!i.hasNext()) continue;
                out.append(",");
            }
            out.append("'");
        }
        out.append("/>\n");
    }

    private boolean doIsEquivalentToWithoutOrder(FTDefinition other) {
        Iterator<FTVariableAbstract> iterThis = this.getArgs().iterator();
        ArrayList<FTVariableAbstract> others = new ArrayList<FTVariableAbstract>(other.getArgs());
        while (iterThis.hasNext()) {
            FTVariableAbstract varThis = iterThis.next();
            boolean find = false;
            for (int i = 0; !find && i < others.size(); ++i) {
                if (!varThis.getName().equals(others.get(i).getName())) continue;
                find = true;
                others.remove(i);
            }
            if (find) continue;
            return false;
        }
        return true;
    }

    private boolean doIsEquivalentTo(FTDefinition other) {
        if (this == other) {
            return true;
        }
        if (!this.getType().equals((Object)other.getType())) {
            return false;
        }
        if (this.getType() == Type.KOFN && this.getAtLeast() != other.getAtLeast()) {
            return false;
        }
        if (this.getArgs().size() != other.getArgs().size()) {
            return false;
        }
        switch (this.getType()) {
            case AND: 
            case OR: 
            case NAND: 
            case NOR: 
            case KOFN: {
                return this.doIsEquivalentToWithoutOrder(other);
            }
            case XOR: 
            case NXOR: {
                if (this.getArgs().size() != 2) break;
                return this.doIsEquivalentToWithoutOrder(other);
            }
        }
        Iterator<FTVariableAbstract> iterThis = this.getArgs().iterator();
        Iterator<FTVariableAbstract> iterOther = other.getArgs().iterator();
        while (iterThis.hasNext()) {
            FTVariableAbstract varThis = iterThis.next();
            FTVariableAbstract varOther = iterOther.next();
            if (varThis.getName().equals(varOther.getName())) continue;
            return false;
        }
        return true;
    }

    public boolean isEquivalentTo(FTDefinition other, StringBuilder out) {
        if (other == null) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_DEFINE_NULL", "<define>", "<null>"));
            return false;
        }
        if (!this.doIsEquivalentTo(other)) {
            try {
                out.append(ResMsgArbor.getString("MSG_EQUI_DEFINE"));
                this.writeEqu(out);
                out.append(" <> ");
                other.writeEqu(out);
            }
            catch (IOException ioe) {
                _LOG.log(Level.WARNING, "Print equation with exception", ioe);
            }
            return false;
        }
        return true;
    }

    private static void ecrireXORAralia4_rec(List<String> results, ArrayList<String> sons, String header, boolean pair, int idx) {
        if (idx == sons.size()) {
            if (!pair) {
                results.add(header);
            }
        } else {
            String son = sons.get(idx);
            if (header.length() > 0) {
                header = header + " & ";
            }
            FTDefinition.ecrireXORAralia4_rec(results, sons, header + son, pair, idx + 1);
            FTDefinition.ecrireXORAralia4_rec(results, sons, header + "-" + son, !pair, idx + 1);
        }
    }

    public static void ecrireXORAralia4(Appendable out, ArrayList<String> sons) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        FTDefinition.ecrireXORAralia4_rec(results, sons, "", sons.size() % 2 == 0, 0);
        Iterator iEqu = results.iterator();
        while (iEqu.hasNext()) {
            out.append("(" + (String)iEqu.next() + ")");
            if (!iEqu.hasNext()) continue;
            out.append("|");
        }
    }

    static /* synthetic */ ImageIcon access$000(String x0) {
        return FTDefinition.getImageIcon(x0);
    }

    public static enum Type {
        VAR("", null, "", 0, 0),
        AND(ResMsgArbor.getString("VOC_AND"), FTDefinition.access$000("PAND"), "&", 2),
        NAND(ResMsgArbor.getString("VOC_NAND"), FTDefinition.access$000("PNAND"), "&", 2),
        OR(ResMsgArbor.getString("VOC_OR"), FTDefinition.access$000("POR"), "|", 1),
        NOR(ResMsgArbor.getString("VOC_NOR"), FTDefinition.access$000("PNOR"), "|", 2),
        XOR(ResMsgArbor.getString("VOC_XOR"), FTDefinition.access$000("PXOR"), "#", 2, 2),
        NXOR(ResMsgArbor.getString("VOC_NXOR"), FTDefinition.access$000("PNXOR"), "=", 2, 2),
        NOT(ResMsgArbor.getString("VOC_NOT"), FTDefinition.access$000("PNOT"), "-", 1, 1),
        ITE(ResMsgArbor.getString("VOC_ITE"), FTDefinition.access$000("PITE"), ",", 3, 3),
        KOFN(ResMsgArbor.getString("VOC_KOFN"), FTDefinition.access$000("PN"), ",", 1);

        String _label;
        Icon _icon;
        int _min;
        int _max;
        String _sep;
        String _xml;
        static ListCellRenderer _renderer;
        static Object _lockerRenderer;

        private Type(String label, Icon icon, String sep, int min) {
            this(label, icon, sep, min, Integer.MAX_VALUE);
        }

        private Type(String label, Icon icon, String sep, int min, int max) {
            this._label = label;
            this._icon = icon;
            this._sep = sep;
            this._min = min;
            this._max = max;
            this._xml = this.toString().toLowerCase();
        }

        public String getLabel() {
            return this._label;
        }

        protected Icon getIcon() {
            return this._icon;
        }

        public int getMinArg() {
            return this._min;
        }

        public int getMaxArg() {
            return this._max;
        }

        public String getDagSep() {
            return this._sep;
        }

        public String toXML() {
            return this._xml;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ListCellRenderer getListRenderer() {
            if (_renderer == null) {
                Object object = _lockerRenderer;
                synchronized (object) {
                    DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                            if (value instanceof Type) {
                                Type type = (Type)((Object)value);
                                this.setText(type.getLabel());
                                Icon icon = type.getIcon();
                                if (icon != null) {
                                    this.setIcon(icon);
                                }
                            }
                            return this;
                        }
                    };
                    if (_renderer == null) {
                        _renderer = renderer;
                    }
                }
            }
            return _renderer;
        }

        static {
            _lockerRenderer = new Object();
        }
    }
}

