/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.obj;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.event.Event;
import com.dassault.cecilia.dbobj.general.law.FctParamSelect;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import java.awt.Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FTEvent
extends Event {
    private static Logger _LOG = Logger.getLogger(FTEvent.class.getPackage().getName());
    State _state = State.DEFAULT;
    Style _style = Style.BASIC;
    Map<IF, Double> _IFs = new HashMap<IF, Double>();
    CCF _dbCCF = null;
    FTVariableAbstract _var;

    @Override
    public String getLabel() {
        if (this._var != null) {
            return this._var.getLabel();
        }
        _LOG.fine("Call getLabel without FTVariable");
        return "";
    }

    @Override
    public void setLabel(String value) {
        if (this._var != null) {
            if (this._var.isIntern() && this._var instanceof FTVariable) {
                ((FTVariable)this._var).setLabel(value);
            } else {
                _LOG.fine("Call setLabel with external FTVariable");
            }
        } else {
            _LOG.fine("Call setLabel without FTVariable");
        }
    }

    public FTVariableAbstract getVariable() {
        return this._var;
    }

    public FTEvent setVariable(FTVariableAbstract value) {
        this._var = value;
        return this;
    }

    public State getState() {
        return this._state;
    }

    public FTEvent setState(State value) {
        this._state = value;
        return this;
    }

    public Style getStyle() {
        return this._style;
    }

    public FTEvent setStyle(Style value) {
        this._style = value;
        return this;
    }

    public double getIF(IF impf) {
        Double result = this._IFs.get((Object)impf);
        if (result == null) {
            return Double.NaN;
        }
        return result;
    }

    public FTEvent clearIFs() {
        this._IFs.clear();
        return this;
    }

    public FTEvent addIF(IF impf, double value) {
        this._IFs.put(impf, value);
        return this;
    }

    public CCF getCCF() {
        return this._dbCCF;
    }

    public FTEvent setCCF(CCF value) {
        this._dbCCF = value;
        return this;
    }

    public FTEvent getCopy() {
        FTEvent other = new FTEvent();
        other.copy(this);
        return other;
    }

    @Override
    public void copy(Event src) {
        super.copy(src);
        this._state = ((FTEvent)src)._state;
        this._style = ((FTEvent)src)._style;
        this._dbCCF = ((FTEvent)src)._dbCCF;
        this._IFs = new HashMap<IF, Double>(((FTEvent)src)._IFs);
    }

    public void toXML(Appendable out, String indent) throws IOException {
        if (this._state != State.DEFAULT) {
            out.append(indent).append("  <").append("ft.state");
            out.append(" ").append("value").append("='").append(this._state == State.TRUE ? "true" : "false").append("'");
            out.append("/>\n");
        }
        if (this._style != Style.BASIC) {
            out.append(indent).append("  <").append("ft.style");
            out.append(" ").append("value").append("='").append(this._style.getXMLCode()).append("'");
            out.append("/>\n");
        }
        for (Map.Entry<IF, Double> entryIF : this._IFs.entrySet()) {
            out.append(indent).append("  <").append("ft.impfactor");
            out.append(" ").append("type").append("='").append(entryIF.getKey().getXMLCode()).append("'");
            out.append(" ").append("value").append("='").append(entryIF.getValue().toString()).append("'");
            out.append("/>\n");
        }
        if (this._dbCCF != null && this._dbCCF.getDBFolder() != null) {
            out.append(indent).append("  ");
            DBObjectXmlUtility.writeDBFolder(out, this._dbCCF.getDBFolder(), "ft.ccf");
        }
        this.toXML_Content(out, indent, null, true);
    }

    public boolean isEquivalentTo(FTEvent other, StringBuilder out) {
        if (other == null) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_EVENT_NULL", "<event>", "<null>"));
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!this.getState().equals((Object)other.getState())) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_STATE", this.getState().getLabel(), other.getState().getLabel()));
            return false;
        }
        if (!this.getStyle().equals((Object)other.getStyle())) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_STYLE", this.getStyle().getLabel(), other.getStyle().getLabel()));
            return false;
        }
        if (this.getModelLaw() != null) {
            if (!this.getModelLaw().equals(other.getModelLaw())) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_LAWMODEL", this.getModelLaw().getRefPath(), other.getModelLaw() == null ? "[]" : other.getModelLaw().getRefPath()));
                return false;
            }
        } else if (other.getModelLaw() != null) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_LAWMODEL", "[]", other.getModelLaw().getRefPath()));
            return false;
        }
        if (this.getOccurrence() != null) {
            if (other.getOccurrence() == null) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_LAW", this.getOccurrence().toString(), "[]"));
                return false;
            }
            if (!this.getOccurrence().toString().equals(other.getOccurrence().toString())) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_LAW", this.getOccurrence().toString(), other.getOccurrence().toString()));
                return false;
            }
        } else if (other.getOccurrence() != null) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_LAW", "[]", other.getOccurrence().toString()));
            return false;
        }
        if (this.getInspected() != null) {
            if (other.getInspected() == null) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_INSPECTED", this.getInspected().toString(), "[]"));
                return false;
            }
            if (!this.getInspected().toString().equals(other.getInspected().toString())) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_INSPECTED", this.getInspected().toString(), other.getInspected().toString()));
                return false;
            }
        } else if (other.getInspected() != null) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_INSPECTED", "[]", other.getInspected().toString()));
            return false;
        }
        if (this.getInflightTested() != null) {
            if (other.getInflightTested() == null) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_INFLIGHT", this.getInflightTested().toString(), "[]"));
                return false;
            }
            if (!this.getInflightTested().toString().equals(other.getInflightTested().toString())) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_INFLIGHT", this.getInflightTested().toString(), other.getInflightTested().toString()));
                return false;
            }
        } else if (other.getInflightTested() != null) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_INFLIGHT", "[]", other.getInflightTested().toString()));
            return false;
        }
        boolean equivAttribs = true;
        if (this.getAttributeCount() != other.getAttributeCount()) {
            equivAttribs = false;
        }
        Iterator<DBAttrib.Value> iterAttrib = this.getAttributes().iterator();
        while (equivAttribs && iterAttrib.hasNext()) {
            DBAttrib.Value dbAttrib = iterAttrib.next();
            DBAttrib.Value dbOther = other.getAttribute(dbAttrib.getKey());
            if (dbOther == null) {
                equivAttribs = false;
                continue;
            }
            if (dbOther.equals(dbAttrib)) continue;
            equivAttribs = false;
        }
        if (!equivAttribs) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_ATTRIBUTS", this.getAttributesAsDisplayedString(), other.getAttributesAsDisplayedString()));
            return false;
        }
        if (this.getCCF() != null) {
            if (other.getCCF() == null) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_CCF", this.getCCF().getRefPath(), "[]"));
                return false;
            }
            if (!this.getCCF().equals(other.getCCF())) {
                out.append(ResMsgArbor.msgFormat("_MSG_EQUI_CCF", this.getCCF().getRefPath(), other.getCCF().getRefPath()));
                return false;
            }
        } else if (other.getCCF() != null) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_CCF", "[]", other.getCCF().getRefPath()));
            return false;
        }
        return true;
    }

    @Override
    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        super.addRelation(dbSrcFolder, typeSrcRelation, relations);
        if (this._dbCCF != null && this._dbCCF.getDBFolder() != null) {
            relations.add(new DBRelation(dbSrcFolder, typeSrcRelation, this._dbCCF.getDBFolder(), "CCF_MODEL"));
        }
    }

    @Override
    public Set<Param> recupParams(Set<Param> result, FctParamSelect fctSelect) {
        return super.recupParams(result, fctSelect);
    }

    @Override
    public void update(CECFactory cecFactory, DBLogs.DBLogsManager logMng, String name) {
        DBWrap dbWrap;
        super.update(cecFactory, logMng, name);
        if (this._dbCCF != null && this._dbCCF.getDBFolder() != null && (dbWrap = DBWrap.createOrFind(cecFactory, this._dbCCF.getDBFolder(), logMng, CCF.class)) != null) {
            this._dbCCF = (CCF)dbWrap;
        }
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        if (this.getLabel() != null) {
            sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_DESCRIPTION"), this.getLabel()));
        }
        sb.append(super.getAbstract()).append('\n');
        if (this.getCCF() != null) {
            sb.append(CompareUtils.getTextForCompare(ResMsgArbor.getString("VOC_CCF"), this.getCCF().getDBFolder().getRefPath()));
        }
        if (this.getState() != null) {
            sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_STATE"), this.getState().getLabel()));
        }
        if (this.getStyle() != null) {
            sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_STYLE"), this.getStyle().getLabel()));
        }
        if (this._IFs != null && !this._IFs.isEmpty()) {
            sb.append(ResMsgArbor.getString("EVENT_IMPORTANCE_FACTORS")).append(" : ");
            for (Map.Entry<IF, Double> IF2 : this._IFs.entrySet()) {
                sb.append('(').append(IF2.getKey().getLabel()).append("->").append(IF2.getValue()).append(") ");
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static enum Style {
        BASIC(ResMsgArbor.getString("FTEVT_STYLE_BASIC")),
        EXTERNAL(ResMsgArbor.getString("FTEVT_STYLE_EXTERNAL")),
        UNDEVELOPED(ResMsgArbor.getString("FTEVT_STYLE_UNDEVELOPED")),
        CONDITIONNING(ResMsgArbor.getString("FTEVT_STYLE_CONDITIONNING")),
        UNLINK(ResMsgArbor.getString("FTEVT_STYLE_UNLINK"));

        String _xml;
        String _strLabel;

        private Style(String strLabel) {
            this._strLabel = strLabel;
            this._xml = this.toString().toLowerCase();
        }

        public String getXMLCode() {
            return this._xml;
        }

        public String getLabel() {
            return this._strLabel;
        }

        public static ListCellRenderer getListRenderer() {
            return new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof Style) {
                        this.setText(((Style)((Object)value)).getLabel());
                    }
                    return this;
                }
            };
        }
    }

    public static enum State {
        DEFAULT(ResMsgArbor.getString("VOC_NORMAL")),
        TRUE(ResMsgArbor.getString("VOC_TRUE")),
        FALSE(ResMsgArbor.getString("VOC_FALSE"));

        String _strLabel;
        String _xml;
        static ListCellRenderer _renderer;
        static Object _lockerRenderer;

        private State(String strLabel) {
            this._strLabel = strLabel;
            this._xml = this.toString().toLowerCase();
        }

        public String getLabel() {
            return this._strLabel;
        }

        public String getXMLCode() {
            return this._xml;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ListCellRenderer getListRenderer() {
            if (_renderer == null) {
                Object object = _lockerRenderer;
                synchronized (object) {
                    DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                            if (value instanceof State) {
                                this.setText(((State)((Object)value)).getLabel());
                            }
                            return this;
                        }
                    };
                    if (_renderer == null) {
                        _renderer = renderer;
                    }
                }
            }
            return _renderer;
        }

        static {
            _lockerRenderer = new Object();
        }
    }

    public static enum IF {
        CPr(ResMsgArbor.getString("VOC_CPR")),
        MIF(ResMsgArbor.getString("VOC_MIF")),
        DIF(ResMsgArbor.getString("VOC_DIF")),
        CIF(ResMsgArbor.getString("VOC_CIF")),
        RAW(ResMsgArbor.getString("VOC_RAW")),
        RRW(ResMsgArbor.getString("VOC_RRW"));

        String _xml;
        String _strLabel;

        private IF(String strLabel) {
            this._strLabel = strLabel;
            this._xml = this.toString().toLowerCase();
        }

        public String getXMLCode() {
            return this._xml;
        }

        public String getLabel() {
            return this._strLabel;
        }
    }
}

