/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm;

import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTable;
import com.dassault.cecilia.dbobj.fmea.ihm.TableToolTip;
import com.dassault.cecilia.dbobj.fmea.ihm.dialog.ExternalFmeaReferencePanel;
import com.dassault.cecilia.dbobj.fmea.model.DictionnaryManager;
import com.dassault.cecilia.dbobj.fmea.model.Fmea;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaExternalRefAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableModel;
import com.dassault.cecilia.dbobj.fmea.model.FmeaValueAttribute;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;

public class FmeaDBTable
extends FmeaTable {
    protected TableCellPopupMenu cellPopupMenu;
    private MouseListener doubleClickListener;
    private MouseListener cellPopupMenuMouseListener;
    CeciliaAppl _appl;

    public FmeaDBTable(CeciliaAppl appl, DictionnaryManager dicoMgr) {
        super(dicoMgr);
        this._appl = appl;
    }

    public FmeaDBTable(CeciliaAppl appl, Fmea fmea, DictionnaryManager dicoMgr) {
        super(fmea, dicoMgr);
        this._appl = appl;
    }

    @Override
    public void setFmea(Fmea fmea) {
        this._dicoMgr = fmea.getModel().getDicoMgr();
        super.setFmea(fmea);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.doubleClickListener = new DoubleClickListener();
        this.addMouseListener(this.doubleClickListener);
        this.cellPopupMenuMouseListener = new CellPopupMenuMouseAdapter();
        this.addMouseListener(this.cellPopupMenuMouseListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.removeMouseListener(this.doubleClickListener);
        this.removeMouseListener(this.cellPopupMenuMouseListener);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        boolean b = super.isCellEditable(row, column);
        if (!b) {
            return false;
        }
        int modelRow = this.convertRowIndexToFmeaModel(row);
        int modelCol = this.convertColumnIndexToModel(column);
        FmeaAttribute attribute = this.getFmeaTableModel().getAttributeAt(modelRow, modelCol);
        return !(attribute instanceof FmeaExternalRefAttribute);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip defaultTooltip = super.createToolTip();
        TableToolTip tooltip = new TableToolTip();
        tooltip.setComponent(this);
        tooltip.setFont(defaultTooltip.getFont());
        tooltip.setBackground(Color.GREEN);
        return tooltip;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        FmeaTable table = (FmeaTable)event.getSource();
        if (!table.isEnabled()) {
            return null;
        }
        Point p = event.getPoint();
        int row = table.convertRowIndexToFmeaModel(table.rowAtPoint(p));
        int col = table.convertColumnIndexToModel(this.columnAtPoint(p));
        FmeaTableModel model = table.getFmeaTableModel();
        FmeaAttribute att = model.getAttributeAt(row, col);
        if (!(att instanceof FmeaExternalRefAttribute)) {
            return null;
        }
        return "" + row + " " + col;
    }

    private void editLinksToExternalFmeas(FmeaTable tbl, int row, int col) {
        if (row == -1 || col == -1) {
            return;
        }
        int mdlCol = tbl.convertColumnIndexToModel(col);
        int mdlRow = tbl.convertRowIndexToFmeaModel(row);
        FmeaAttribute attribute = tbl.getFmeaTableModel().getAttributeAt(mdlRow, mdlCol);
        String title = Messages.getString("FmeaDBTable.2");
        ExternalFmeaReferencePanel dlg = new ExternalFmeaReferencePanel((Frame)this._appl.getTopWindow(), title);
        dlg.setSource(this._dbFolder);
        dlg.setApplication(this._appl);
        if (attribute instanceof FmeaExternalRefAttribute) {
            dlg.setReferences(((FmeaExternalRefAttribute)attribute).getExternalReferences());
        }
        dlg.setVisible(true);
        dlg.dispose();
        if (dlg.canceled()) {
            return;
        }
        FmeaExternalRefAttribute refAttribute = new FmeaExternalRefAttribute(dlg.getReferences());
        tbl.getFmeaTableModel().setAttributeAt(refAttribute, mdlRow, mdlCol);
        this.fireChangeDepends();
    }

    class TableCellPopupMenu
    extends JPopupMenu {
        private int viewRow;
        private int viewCol;

        TableCellPopupMenu(int row, int col) {
            this.viewRow = row;
            this.viewCol = col;
            this.initItems();
        }

        void initItems() {
            JMenuItem link = new JMenuItem(Messages.getString("FmeaDBTable.3"));
            JMenuItem unlink = new JMenuItem(Messages.getString("FmeaDBTable.4"));
            this.add(link);
            this.add(unlink);
            final int mdlRow = FmeaDBTable.this.convertRowIndexToFmeaModel(this.viewRow);
            final int mdlCol = FmeaDBTable.this.convertColumnIndexToModel(this.viewCol);
            FmeaTableModel model = FmeaDBTable.this.getFmeaTableModel();
            FmeaAttribute attribute = model.getAttributeAt(mdlRow, mdlCol);
            link.setEnabled(true);
            unlink.setEnabled(attribute instanceof FmeaExternalRefAttribute);
            link.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FmeaDBTable.this.editLinksToExternalFmeas(FmeaDBTable.this, TableCellPopupMenu.this.viewRow, TableCellPopupMenu.this.viewCol);
                }
            });
            unlink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FmeaTableModel fmeaModel = FmeaDBTable.this.getFmeaTableModel();
                    FmeaAttribute fmeaAttribute = fmeaModel.getAttributeAt(mdlRow, mdlCol);
                    if (fmeaAttribute instanceof FmeaValueAttribute) {
                        return;
                    }
                    fmeaAttribute = new FmeaValueAttribute(fmeaAttribute.getValue());
                    fmeaModel.setAttributeAt(fmeaAttribute, mdlRow, mdlCol);
                    FmeaDBTable.this.fireChangeDepends();
                }
            });
        }
    }

    public class DoubleClickListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            FmeaTable tbl = (FmeaTable)e.getSource();
            int row = tbl.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = tbl.getColumnModel().getColumnIndexAtX(e.getX());
            int modelRow = FmeaDBTable.this.convertRowIndexToFmeaModel(row);
            int modelCol = FmeaDBTable.this.convertColumnIndexToModel(col);
            FmeaAttribute attribute = FmeaDBTable.this.getFmeaTableModel().getAttributeAt(modelRow, modelCol);
            if (!(attribute instanceof FmeaExternalRefAttribute)) {
                return;
            }
            FmeaDBTable.this.editLinksToExternalFmeas(FmeaDBTable.this, row, col);
        }
    }

    class CellPopupMenuMouseAdapter
    extends MouseAdapter {
        CellPopupMenuMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.treatMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.treatMouseEvent(e);
        }

        public void treatMouseEvent(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            FmeaTable tbl = (FmeaTable)e.getSource();
            int row = tbl.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = tbl.columnAtPoint(new Point(e.getX(), e.getY()));
            if (row == -1 || col == -1) {
                return;
            }
            int mdlCol = tbl.convertColumnIndexToModel(col);
            FmeaColumnDefinition colDef = tbl.getFmeaTableModel().getColumnDefinition(mdlCol);
            if (!colDef.isLinkedToAttribute()) {
                return;
            }
            if (!(colDef.getAttributeDefinition().getType() instanceof FmeaAttributeDefinition.Number)) {
                return;
            }
            FmeaDBTable.this.cellPopupMenu = new TableCellPopupMenu(row, col);
            if (FmeaDBTable.this.cellPopupMenu.getComponentCount() == 0) {
                return;
            }
            FmeaDBTable.this.cellPopupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }
}

