/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm;

import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.dialog.ExternalFmeaReferenceUtility;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FmeaDataReferencePanel
extends JPanel {
    private JLabel _lb_fmeaPath;
    private JTextField _tf_fmeaPath;
    private JButton _b_fmeaBrowse;
    private JLabel _lb_entity;
    private JTextField _tf_entity;
    private JLabel _lb_attribute;
    private JTextField _tf_attribute;
    private JLabel _lb_value;
    private JTextField _tf_value;
    static final DecimalFormat __formatter = new DecimalFormat("0.000E00", new DecimalFormatSymbols(Locale.ENGLISH));
    private ExternalFmeaReference _reference;
    private boolean _enabled = true;
    CeciliaAppl _application;
    List<DependsListener> _listeners = new ArrayList<DependsListener>();

    public FmeaDataReferencePanel(CeciliaAppl application) {
        this._application = application;
        this.init();
    }

    public void setEditable(boolean editable) {
        this._b_fmeaBrowse.setVisible(editable);
    }

    public ExternalFmeaReference getReference() {
        return this._reference;
    }

    public void setReference(ExternalFmeaReference reference) {
        this._reference = reference;
        this._tf_fmeaPath.setText(reference.getDBFolder().getRefPath());
        this._tf_entity.setText(reference.getFmeaEntName() + "." + reference.getFmeaEntValue());
        this._tf_attribute.setText(reference.getFmeaAttName());
        this._tf_value.setText(__formatter.format(reference.getFmeaAttValue()));
    }

    public JTextField getFmeaPathTextField() {
        return this._tf_fmeaPath;
    }

    public JTextField getTf_attribute() {
        return this._tf_attribute;
    }

    public void setTf_attribute(JTextField tf_attribute) {
        this._tf_attribute = tf_attribute;
    }

    public JTextField getTf_entity() {
        return this._tf_entity;
    }

    public void setTf_entity(JTextField tf_entity) {
        this._tf_entity = tf_entity;
    }

    public JTextField getTf_fmeaPath() {
        return this._tf_fmeaPath;
    }

    public void setTf_fmeaPath(JTextField tf_fmeaPath) {
        this._tf_fmeaPath = tf_fmeaPath;
    }

    public JTextField getTf_value() {
        return this._tf_value;
    }

    public void setTf_value(JTextField tf_value) {
        this._tf_value = tf_value;
    }

    public void update() {
        if (this._reference == null) {
            this._tf_fmeaPath.setText("");
            this._tf_entity.setText("");
            this._tf_attribute.setText("");
            this._tf_value.setText("");
        } else {
            this._tf_fmeaPath.setText(this._reference.getDBFolder().getRefPath());
            this._tf_entity.setText(this._reference.getFmeaEntName() + "." + this._reference.getFmeaEntValue());
            this._tf_attribute.setText(this._reference.getFmeaAttName());
            this._tf_value.setText(__formatter.format(this._reference.getFmeaAttValue()));
        }
    }

    public void update(ParamFMEA param) {
        this._reference = new ExternalFmeaReference(param.getDBFolder(), param.getDefineEntity(), param.getNameEntity(), param.getValueEntity(), param.getDefineAttribute(), param.getNameAttribute(), param.getValueAttribute());
        this._tf_fmeaPath.setText(this._reference.getDBFolder().getRefPath());
        this._tf_entity.setText(this._reference.getFmeaEntName() + "." + this._reference.getFmeaEntValue());
        this._tf_attribute.setText(this._reference.getFmeaAttName());
        this._tf_value.setText(__formatter.format(this._reference.getFmeaAttValue()));
    }

    public void clean() {
        this._reference = null;
        this.update();
    }

    public boolean checkFields() {
        return this._tf_fmeaPath.getText().length() != 0 && this._tf_entity.getText().length() != 0 && this._tf_attribute.getText().length() != 0 && this._tf_value.getText().length() != 0;
    }

    private void init() {
        this.initComponents();
        this.initPanel();
        this.initActions();
    }

    private void initComponents() {
        this._lb_fmeaPath = new JLabel(Messages.getString("FmeaDataReferencePanel.5"));
        this._tf_fmeaPath = new JTextField();
        this._tf_fmeaPath.setEditable(false);
        this._b_fmeaBrowse = new JButton("...");
        this._lb_entity = new JLabel(Messages.getString("FmeaDataReferencePanel.7"));
        this._tf_entity = new JTextField();
        this._tf_entity.setEditable(false);
        this._lb_attribute = new JLabel(Messages.getString("FmeaDataReferencePanel.8"));
        this._tf_attribute = new JTextField();
        this._tf_attribute.setEditable(false);
        this._lb_value = new JLabel(Messages.getString("FmeaDataReferencePanel.9"));
        this._tf_value = new JTextField();
        this._tf_value.setEditable(false);
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this._lb_fmeaPath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this._tf_fmeaPath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this._b_fmeaBrowse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this._lb_entity, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this._tf_entity, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this._lb_attribute, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this._tf_attribute, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this._lb_value, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this._tf_value, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
    }

    private void initActions() {
        this._b_fmeaBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FmeaDataReferencePanel.this.browseButtonAction(e);
            }
        });
    }

    private void browseButtonAction(ActionEvent e) {
        DBTableFMEA dbFMEA;
        ExternalFmeaReferenceUtility util = new ExternalFmeaReferenceUtility();
        util.setApplication(this._application);
        if (this._reference != null) {
            util.setFolderSelect(this._reference.getDBFolder());
        }
        if ((dbFMEA = util.selectFMEA(SwingUtilities.getWindowAncestor(this))) == null) {
            return;
        }
        List<ExternalFmeaReference> selecteds = util.selectReferencies(true, dbFMEA, this._reference);
        if (selecteds == null || selecteds.size() == 0) {
            return;
        }
        this._reference = selecteds.get(0);
        this._tf_fmeaPath.setText(this._reference.getDBFolder().getRefPath());
        this._tf_entity.setText(this._reference.getFmeaEntName() + "." + this._reference.getFmeaEntValue());
        this._tf_attribute.setText(this._reference.getFmeaAttName());
        this._tf_value.setText(__formatter.format(this._reference.getFmeaAttValue()));
        this.repaint();
        this.fireChangeDepends();
    }

    public void setModificationAllowed(boolean enabled) {
        this._enabled = enabled;
        this._b_fmeaBrowse.setEnabled(this._enabled);
    }

    public void addDependsListener(DependsListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removeDependsListener(DependsListener l) {
        this._listeners.remove(l);
    }

    protected void fireChangeDepends() {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).changeDepends();
        }
    }
}

