/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition;

import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.FmeaModelDefinitionPanel;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.TreeList;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaRelationDefinition;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class EntityPathDefinitionPanel
extends JPanel {
    private final TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
        }
    };
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            EntityPathDefinitionPanel.this._selectedPath = tree.getPathForLocation(e.getX(), e.getY());
            if (EntityPathDefinitionPanel.this._selectedPath == null) {
                return;
            }
            ArrayList<Object> entityPath = new ArrayList<Object>();
            for (int i = 1; i < EntityPathDefinitionPanel.this._selectedPath.getPathCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)EntityPathDefinitionPanel.this._selectedPath.getPathComponent(i);
                tree.addSelectionPath(new TreePath(node.getPath()));
                entityPath.add(node.getUserObject());
            }
            ((EntityPathDefinitionPanel)EntityPathDefinitionPanel.this).definitionPanel._fmea.getModel().setEntityPath(entityPath);
        }
    };
    private boolean _listenersInstalled = false;
    private static String __entityPath = "entity.gif";
    private final FmeaModelDefinitionPanel definitionPanel;
    TreeList _treeList;
    TreePath _selectedPath = null;
    JTree _tree;
    private JScrollPane _scpane;

    public EntityPathDefinitionPanel(FmeaModelDefinitionPanel panel) {
        super(new GridBagLayout());
        this.definitionPanel = panel;
        this.updateTreeList();
        this._tree = new JTree();
        this.populateTree();
        this._scpane = new JScrollPane(this._tree);
        this.add((Component)this._scpane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.installListeners();
    }

    public void setPanelEnabled(boolean enabled) {
        if (enabled) {
            this.installListeners();
        } else {
            this.uninstallListeners();
        }
    }

    private void installListeners() {
        if (this._listenersInstalled) {
            return;
        }
        this._listenersInstalled = true;
        this._tree.addTreeSelectionListener(this.treeSelectionListener);
        this._tree.addMouseListener(this.mouseListener);
    }

    private void uninstallListeners() {
        if (!this._listenersInstalled) {
            return;
        }
        this._listenersInstalled = false;
        this._tree.removeTreeSelectionListener(this.treeSelectionListener);
        this._tree.removeMouseListener(this.mouseListener);
    }

    public void updateContent() {
        this.updateTreeList();
        this.updateTree();
    }

    void addRelation(FmeaEntityDefinition entity, FmeaEntityDefinition relatedEntity) {
        this._treeList.addRelation(entity, relatedEntity);
        this.updateTree();
    }

    void removeRelation(FmeaEntityDefinition entity, FmeaEntityDefinition relatedEntity) {
        this._treeList.removeRelation(entity, relatedEntity);
        this.updateTree();
    }

    void addEntity(FmeaEntityDefinition entity) {
        this._treeList.addEntity(entity);
        this.updateTree();
    }

    void removeEntity(FmeaEntityDefinition entity) {
        this._treeList.removeEntity(entity);
        this.updateTree();
    }

    private void updateTreeList() {
        this._treeList = new TreeList();
        if (this.definitionPanel._entityData.length == 1) {
            FmeaEntityDefinition entityDef = (FmeaEntityDefinition)this.definitionPanel._entityData[0];
            this._treeList.addEntity(entityDef);
        }
        for (int i = 0; i < this.definitionPanel._relationData.length; ++i) {
            FmeaRelationDefinition relationDef = (FmeaRelationDefinition)this.definitionPanel._relationData[i];
            FmeaEntityDefinition entityDef1 = this.definitionPanel._fmea.getModel().getEntityDefinition(relationDef.getEntityDef1());
            FmeaEntityDefinition entityDef2 = this.definitionPanel._fmea.getModel().getEntityDefinition(relationDef.getEntityDef2());
            this._treeList.addRelation(entityDef1, entityDef2);
        }
    }

    private void updateTree() {
        this.populateTree();
    }

    private void populateTree() {
        Iterator itr = this._treeList.getRoots();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        while (itr.hasNext()) {
            root.add((DefaultMutableTreeNode)itr.next());
        }
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        model.setRoot(root);
        ImageIcon icon = new ImageIcon(this.getClass().getResource(__entityPath));
        DefaultTreeCellRenderer cellRenderer = (DefaultTreeCellRenderer)this._tree.getCellRenderer();
        cellRenderer.setClosedIcon(icon);
        cellRenderer.setOpenIcon(icon);
        cellRenderer.setLeafIcon(icon);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this.expandAllNodes(this._tree);
        DefaultMutableTreeNode node = root;
        for (int i = 0; i < this.definitionPanel._entityPathData.size(); ++i) {
            FmeaEntityDefinition entityDef = (FmeaEntityDefinition)this.definitionPanel._entityPathData.get(i);
            if ((node = this.getChild(node, entityDef)) == null) {
                this.definitionPanel._entityPathData.clear();
                break;
            }
            this._tree.addSelectionPath(new TreePath(node.getPath()));
        }
    }

    private DefaultMutableTreeNode getChild(DefaultMutableTreeNode node, FmeaEntityDefinition entityDef) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.getUserObject() != entityDef) continue;
            return child;
        }
        return null;
    }

    public void expandAllNodes(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAllNodes(tree, root);
    }

    private void expandAllNodes(JTree tree, TreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            tree.expandPath(new TreePath(model.getPathToRoot(child)));
            this.expandAllNodes(tree, child);
        }
    }
}

