/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.DictionnaryManager;
import com.dassault.cecilia.dbobj.fmea.model.DictionnaryStore;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaRelationDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableDefinition;
import com.dassault.cecilia.dbobj.fmea.model.SortData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class FmeaModel
extends FmeaObject
implements FmeaSerializable {
    private List _entityPath = new ArrayList();
    private Map<String, FmeaEntityDefinition> _entityDefs = new LinkedHashMap<String, FmeaEntityDefinition>();
    private Map<String, FmeaRelationDefinition> _relationDefs = new LinkedHashMap<String, FmeaRelationDefinition>();
    private FmeaTableDefinition _tableDef;
    private DictionnaryManager _dicoMgr = new DictionnaryStore();
    private SortData _sortData = null;

    public int getEntityPathLength() {
        return this._entityPath.size();
    }

    public FmeaEntityDefinition getEntityDefinitionFromPath(int i) {
        return this._entityPath.isEmpty() ? null : (FmeaEntityDefinition)this._entityPath.get(i);
    }

    public List getEntityPath() {
        return new ArrayList(this._entityPath);
    }

    public void setEntityPath(List entityPath) {
        this._entityPath = entityPath == null ? new ArrayList() : entityPath;
        this._changeNotifier.changed(this);
    }

    public void addToEntityPath(FmeaEntityDefinition entityDef) {
        if (!this._entityPath.isEmpty()) {
            FmeaEntityDefinition lastEntityDef = (FmeaEntityDefinition)this._entityPath.get(this._entityPath.size() - 1);
            lastEntityDef.setDefaultRelatedEntityDefinition(entityDef);
        }
        this._entityPath.add(entityDef);
        this._changeNotifier.changed(this);
    }

    public Object[] getEntityDefinitions() {
        Comparator<FmeaEntityDefinition> c = new Comparator<FmeaEntityDefinition>(){

            @Override
            public int compare(FmeaEntityDefinition o1, FmeaEntityDefinition o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        ArrayList<FmeaEntityDefinition> lst = new ArrayList<FmeaEntityDefinition>();
        lst.addAll(this._entityDefs.values());
        Collections.sort(lst, c);
        return lst.toArray();
    }

    public FmeaEntityDefinition getEntityDefinition(String key) {
        return this._entityDefs.get(key);
    }

    public FmeaEntityDefinition getEntityDefinitionWithName(String name) {
        for (FmeaEntityDefinition entityDef : this._entityDefs.values()) {
            if (!entityDef.getName().equals(name)) continue;
            return entityDef;
        }
        return null;
    }

    public void addEntityDefinition(FmeaEntityDefinition entityDef) {
        this._entityDefs.put(entityDef.getKey(), entityDef);
        if (this._entityDefs.size() == 1) {
            assert (this._entityPath.size() == 0);
            this._entityPath.add(entityDef);
        }
        entityDef.getChangeNotifier().addChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    public void removeEntityDefinition(FmeaEntityDefinition entityDef) {
        this._entityDefs.remove(entityDef.getKey());
        if (this._entityPath.contains(entityDef)) {
            this._entityPath = new ArrayList();
        }
        entityDef.getChangeNotifier().removeChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    public void changeEntityDefinitionName(String oldName, String newName) {
    }

    public Object[] getRelationDefinitions() {
        return this._relationDefs.values().toArray();
    }

    public FmeaRelationDefinition getRelationDefinition(String key) {
        return this._relationDefs.get(key);
    }

    public FmeaRelationDefinition getRelationDefinition(FmeaEntityDefinition entityDef1, FmeaEntityDefinition entityDef2) {
        for (FmeaRelationDefinition relationDef : this._relationDefs.values()) {
            if (!relationDef.getEntityDef1().equals(entityDef1.getKey()) || !relationDef.getEntityDef2().equals(entityDef2.getKey())) continue;
            return relationDef;
        }
        return null;
    }

    public boolean existRelationDefinition(FmeaEntityDefinition entityDef) {
        for (FmeaRelationDefinition relationDef : this._relationDefs.values()) {
            if (!relationDef.getEntityDef1().equals(entityDef.getKey()) && !relationDef.getEntityDef2().equals(entityDef.getKey())) continue;
            return true;
        }
        return false;
    }

    public void addRelationDefinition(FmeaRelationDefinition relationDef) {
        this._relationDefs.put(relationDef.getKey(), relationDef);
        relationDef.getChangeNotifier().addChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    public boolean checkValue(Object value, int row, int col) {
        return this.getTableDefinition().getColumnDefinition(col).checkValue(value);
    }

    public void removeRelationDefinition(FmeaRelationDefinition relationDef) {
        int pos1 = this._entityPath.indexOf(this.getEntityDefinition(relationDef.getEntityDef1()));
        int pos2 = this._entityPath.indexOf(this.getEntityDefinition(relationDef.getEntityDef2()));
        if (0 <= pos1 && pos1 < this._entityPath.size() - 1) {
            this._entityPath = new ArrayList();
        } else if (0 < pos2 && pos2 <= this._entityPath.size() - 1) {
            this._entityPath = new ArrayList();
        }
        this._relationDefs.remove(relationDef.getKey());
        relationDef.getChangeNotifier().removeChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    public FmeaTableDefinition getTableDefinition() {
        return this._tableDef;
    }

    public void setTableDefinition(FmeaTableDefinition tableDef) {
        if (this._tableDef != null) {
            this._tableDef.getChangeNotifier().removeChangeListener(this._changeNotifier);
        }
        this._tableDef = tableDef;
        this._tableDef.getChangeNotifier().addChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    public void setSortData(SortData sortData) {
        if (this._sortData != null) {
            this._sortData.getChangeNotifier().removeChangeListener(this._changeNotifier);
        }
        this._sortData = sortData;
        if (this._sortData != null) {
            this._sortData.getChangeNotifier().addChangeListener(this._changeNotifier);
        }
    }

    public SortData getSortData() {
        return this._sortData;
    }

    public DictionnaryManager getDicoMgr() {
        return this._dicoMgr;
    }

    public void setDicoMgr(DictionnaryManager dicoMgr) {
        this._dicoMgr = dicoMgr;
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        this.writeXML(w, true);
    }

    public void writeXML(FmeaBufferedWriter w, boolean withID) throws IOException {
        w.incTabCount();
        w.write("<FMEA_MODEL");
        String ID = this.getXMLAttribute("ID");
        if (withID && ID != null) {
            w.write(" ID=\"" + ID + "\"");
        }
        w.write(" COMMENT=\"" + this.getXMLAttribute("COMMENT") + "\"");
        w.writeln(">");
        for (FmeaEntityDefinition entityDef : this._entityDefs.values()) {
            entityDef.writeXML(w);
        }
        for (FmeaRelationDefinition relationDef : this._relationDefs.values()) {
            relationDef.writeXML(w);
        }
        w.incTabCount();
        w.writeln("<ENTITY_PATH>");
        Iterator<FmeaObject> it = this._entityPath.iterator();
        while (it.hasNext()) {
            w.incTabCount();
            w.write("<ENTITY_DEF_NAME NAME=\"");
            w.write(((FmeaEntityDefinition)it.next()).getKey());
            w.writeln("\"></ENTITY_DEF_NAME>");
            w.decTabCount();
        }
        w.writeln("</ENTITY_PATH>");
        w.decTabCount();
        this._tableDef.writeXML(w);
        this._dicoMgr.writeXML(w);
        if (this._sortData != null) {
            this._sortData.writeXML(w);
        }
        w.writeln("</FMEA_MODEL>");
        w.decTabCount();
        this.getChangeNotifier().setChanged(false);
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<FMEA_MODEL");
        String ID = this.getXMLAttribute("ID");
        out.append(" ID=\"" + ID + "\"");
        out.append(" COMMENT=\"" + this.getXMLAttribute("COMMENT") + "\"");
        out.append(">\n");
        String indent1 = indent + "  ";
        for (FmeaEntityDefinition entityDef : this._entityDefs.values()) {
            entityDef.toXML(out, indent1);
        }
        for (FmeaRelationDefinition relationDef : this._relationDefs.values()) {
            relationDef.toXML(out, indent1);
        }
        out.append(indent1).append("<ENTITY_PATH>\n");
        Iterator<FmeaObject> it = this._entityPath.iterator();
        while (it.hasNext()) {
            out.append(indent1).append("  <ENTITY_DEF_NAME NAME=\"");
            out.append(((FmeaEntityDefinition)it.next()).getKey());
            out.append("\"/>\n");
        }
        out.append(indent1).append("</ENTITY_PATH>\n");
        this._tableDef.toXML(out, indent1);
        this._dicoMgr.toXML(out, indent1);
        if (this._sortData != null) {
            this._sortData.toXML(out, indent1);
        }
        out.append(indent).append("</FMEA_MODEL>");
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }
}

