/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.util;

import com.dassault.cecilia.dbobj.fmea.util.ButtonTableCellRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SorterTableHeader
extends JTableHeader {
    protected ButtonTableCellRenderer sortingRenderer = new ButtonTableCellRenderer();
    private boolean sorting = false;
    protected boolean sortEnabled = true;

    public SorterTableHeader() {
        this.init();
        this.defineListeners();
    }

    public SorterTableHeader(TableColumnModel cm) {
        super(cm);
        this.init();
        this.defineListeners();
    }

    @Override
    public void setTable(JTable newTable) {
        super.setTable(newTable);
    }

    public ButtonTableCellRenderer getSortingRenderer() {
        return this.sortingRenderer;
    }

    public boolean getAscendingOrder() {
        return this.sortingRenderer.getAscendingOrder();
    }

    protected void init() {
        this.updateHeaderRenderers();
    }

    public void setSortEnabled(boolean enabled) {
        this.sortEnabled = enabled;
    }

    public boolean isSrotEnabled() {
        return this.sortEnabled;
    }

    protected void updateHeaderRenderers() {
        TableColumnModel cm = this.getColumnModel();
        this.sortingRenderer.setColumnCount(cm.getColumnCount());
        for (int col = 0; col < cm.getColumnCount(); ++col) {
            cm.getColumn(col).setHeaderRenderer(this.sortingRenderer);
        }
    }

    public void setColumnSorted(int column, boolean ascendingOrder) {
        this.sortingRenderer.deselectAllColumns();
        int col = this.getTable().convertColumnIndexToModel(column);
        this.sortingRenderer.setColumnSorted(col, ascendingOrder);
        this.paintImmediately(this.getHeaderRect(column));
    }

    private void defineListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SorterTableHeader.this.sortEnabled) {
                    return;
                }
                if (e.getClickCount() == 1 && e.getModifiersEx() == 1024) {
                    SorterTableHeader.this.sorting = true;
                    int viewColumn = SorterTableHeader.this.getColumnModel().getColumnIndexAtX(e.getX());
                    int col = SorterTableHeader.this.getTable().convertColumnIndexToModel(viewColumn);
                    if (col == -1) {
                        return;
                    }
                    SorterTableHeader.this.sortingRenderer.setColumnSelected(col, true);
                    SorterTableHeader.this.paintImmediately(SorterTableHeader.this.getHeaderRect(viewColumn));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!SorterTableHeader.this.sortEnabled) {
                    return;
                }
                SorterTableHeader.this.sortingRenderer.deselectAllColumns();
                if (e.getClickCount() == 1 && e.getModifiersEx() == 1024 && SorterTableHeader.this.sorting) {
                    int viewColumn = SorterTableHeader.this.getColumnModel().getColumnIndexAtX(e.getX());
                    int col = SorterTableHeader.this.getTable().convertColumnIndexToModel(viewColumn);
                    if (col == -1) {
                        return;
                    }
                    SorterTableHeader.this.sortingRenderer.setColumnSorted(col);
                    SorterTableHeader.this.paintImmediately(SorterTableHeader.this.getHeaderRect(viewColumn));
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!SorterTableHeader.this.sortEnabled) {
                    return;
                }
                SorterTableHeader.this.sorting = false;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        super.columnAdded(e);
        this.updateHeaderRenderers();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        super.columnRemoved(e);
        this.updateHeaderRenderers();
    }
}

