/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.list.ArrayListModel;
import com.dassault.cecilia.core.swing.list.ListPanel;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapFrameEdit;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListModel;

public class DBAttribFrameEdit
extends DBWrapFrameEdit {
    JRadioButton _ctrlTypeAlias;
    JRadioButton _ctrlTypeNumber;
    JRadioButton _ctrlTypeString;
    JRadioButton _ctrlTypeEnum;
    ArrayListModel<String> _enumsModel;
    EnumListPanel _enumsPanel;
    Component _enumsCtrl;

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_ATTRIBUTE");
    }

    @Override
    public DBAttrib getDBWrap() {
        return (DBAttrib)super.getDBWrap();
    }

    public DBAttribFrameEdit(DBAttrib dbAttrib, CeciliaAppl appl) {
        super(dbAttrib.getCopy(), appl);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createCenterPanel(), "Center");
        this.getContentPane().add(this.createAndPlugLogsButtonAt(this.createSaveAndClosePanel()), "South");
        this.pack();
        this.refreshControl();
        this.setModified(false);
    }

    @Override
    public boolean verifyData() {
        if (this._ctrlTypeEnum.isSelected() && this._enumsModel.getSize() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._enumsCtrl), ResMsgObj.getString("DBATTRIB_ENUM_EMPTY"), this.getTitle(), 0);
            this._enumsCtrl.requestFocus();
            return false;
        }
        if (!this.verifyDescription()) {
            return false;
        }
        return super.verifyData();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        if (this._ctrlTypeEnum.isSelected()) {
            this.getDBWrap().setType(AttrType.ENUM);
            this.getDBWrap().setEnums(this._enumsModel.getList());
        } else {
            this.getDBWrap().setEnums(null);
            if (this._ctrlTypeAlias.isSelected()) {
                this.getDBWrap().setType(AttrType.ALIAS);
            } else if (this._ctrlTypeNumber.isSelected()) {
                this.getDBWrap().setType(AttrType.NUMBER);
            } else if (this._ctrlTypeString.isSelected()) {
                this.getDBWrap().setType(AttrType.STRING);
            }
        }
        if (!this.doSave()) {
            return false;
        }
        this._ctrlName.setText(this.getDBFolder().getParent().getName());
        return true;
    }

    @Override
    protected void refreshControl() {
        super.refreshControl();
        switch (this.getDBWrap().getType()) {
            case ALIAS: {
                this._ctrlTypeAlias.setSelected(true);
                break;
            }
            case NUMBER: {
                this._ctrlTypeNumber.setSelected(true);
                break;
            }
            case STRING: {
                this._ctrlTypeString.setSelected(true);
                break;
            }
            case ENUM: {
                this._ctrlTypeEnum.setSelected(true);
            }
        }
        if (this.getDBWrap().getType() == AttrType.ENUM) {
            this._enumsModel.setList(this.getDBWrap().getEnums());
        } else {
            this._enumsModel.clear();
        }
        this.refreshType();
    }

    protected void refreshType() {
        this._enumsPanel.setEnabled(this._ctrlTypeEnum.isSelected());
    }

    private Component createCenterPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.add(this.createPathCtrl(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createDescriptionCtrl(), ResMsgVoc.getString("VOC_DESCRIPTION")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createTypeCtrl(), ResMsgVoc.getString("VOC_TYPE")), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        return result;
    }

    private Component createTypeCtrl() {
        JPanel type = new JPanel(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        this._ctrlTypeAlias = new JRadioButton(AttrType.ALIAS.getLabel());
        group.add(this._ctrlTypeAlias);
        this._ctrlTypeNumber = new JRadioButton(AttrType.NUMBER.getLabel());
        group.add(this._ctrlTypeNumber);
        this._ctrlTypeString = new JRadioButton(AttrType.STRING.getLabel());
        group.add(this._ctrlTypeString);
        this._ctrlTypeEnum = new JRadioButton(AttrType.ENUM.getLabel());
        group.add(this._ctrlTypeEnum);
        ActionListener changeType = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBAttribFrameEdit.this.refreshType();
                DBAttribFrameEdit.this.setModified(true);
            }
        };
        this._ctrlTypeAlias.addActionListener(changeType);
        this._ctrlTypeNumber.addActionListener(changeType);
        this._ctrlTypeString.addActionListener(changeType);
        this._ctrlTypeEnum.addActionListener(changeType);
        this._enumsModel = new ArrayListModel();
        this._enumsPanel = new EnumListPanel(this._enumsModel);
        AbstractButton enumsAdd = this._enumsPanel.getAction("ACTION_ADD").createButton(CeciliaAction.BorderStyle.NONE);
        AbstractButton enumsDel = this._enumsPanel.getAction("ACTION_DEL").createButton(CeciliaAction.BorderStyle.NONE);
        int posY = 0;
        type.add((Component)this._ctrlTypeAlias, new GridBagConstraints(0, posY, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0));
        type.add((Component)this._ctrlTypeNumber, new GridBagConstraints(0, ++posY, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0));
        type.add((Component)this._ctrlTypeString, new GridBagConstraints(0, ++posY, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0));
        type.add((Component)this._ctrlTypeEnum, new GridBagConstraints(0, ++posY, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0));
        type.add((Component)enumsAdd, new GridBagConstraints(1, posY, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        type.add((Component)enumsDel, new GridBagConstraints(2, posY, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 1, 1, 12), 0, 0));
        this._enumsCtrl = this._enumsPanel.getCtrlCollection();
        this._enumsCtrl.setPreferredSize(new Dimension(200, 60));
        int n = ++posY;
        ++posY;
        type.add(this._enumsCtrl, new GridBagConstraints(0, n, 3, 1, 1.0, 1.0, 17, 1, new Insets(2, 12, 2, 12), 0, 0));
        return type;
    }

    private String addEnumValue() {
        Object[] options = new Object[]{ResMsgVoc.getString("VOC_VALIDATE"), ResMsgVoc.getString("VOC_CANCEL")};
        JOptionPane pane = new JOptionPane(ResMsgObj.getString("DLG_ATTRIB_ENUM_TITLE"), 3, 0, null, options, options[0]);
        pane.setWantsInput(true);
        JDialog dialog = pane.createDialog(JOptionCecilia.getTopContainerOf(this), ResMsgObj.getString("DLG_ATTRIB_ENUM_ADD"));
        dialog.setVisible(true);
        dialog.dispose();
        if (pane.getValue().equals(options[1])) {
            return null;
        }
        String value = (String)pane.getInputValue();
        if (value.isEmpty()) {
            return null;
        }
        if (!DBAttrib.verifyEnum(value)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgObj.getString("DLG_ATTRIB_ENUM_ERR_VALUE"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return null;
        }
        boolean found = false;
        for (int i = 0; !found && i < this._enumsModel.getSize(); ++i) {
            String attval = this._enumsModel.getElementAt(i);
            if (!attval.equals(value)) continue;
            found = true;
        }
        if (found) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgObj.getString("DLG_ATTRIB_ENUM_ERR_KNOWN"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return null;
        }
        return value;
    }

    class EnumListPanel
    extends ListPanel {
        public EnumListPanel(ListModel model) {
            super(model, true, false);
        }

        @Override
        protected void addData(int idx) {
            String addEnum = DBAttribFrameEdit.this.addEnumValue();
            if (addEnum == null) {
                return;
            }
            DBAttribFrameEdit.this._enumsModel.insertAt(idx, addEnum);
            DBAttribFrameEdit.this.setModified(true);
        }

        @Override
        protected void delData(int[] idx) {
            if (idx.length == 0) {
                return;
            }
            for (int i = idx.length - 1; i >= 0; --i) {
                DBAttribFrameEdit.this._enumsModel.removeAt(idx[i]);
            }
            DBAttribFrameEdit.this.setModified(true);
        }
    }
}

