/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBAttributesHandlerXml
extends SAXWrapHandler
implements DBObjectXmlConstant {
    public static final String ELT_ATTRIBUTES = "attributes";
    public static final String ELT_ATTRIBUTE = "attribute";
    protected CECFactory _daoFactory;
    String _sourceName;
    Collection<DBAttrib.Value> _attributes = null;

    public DBAttributesHandlerXml(DBLogs.DBLogsManager logMng, Locator locator, CECFactory daoFactory, String sourceName) {
        super(logMng, locator);
        this._daoFactory = daoFactory;
        this._sourceName = sourceName;
        this._attributes = new ArrayList<DBAttrib.Value>();
    }

    public Collection<DBAttrib.Value> getAttributes() {
        return this._attributes;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            if (!ELT_ATTRIBUTES.equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", ELT_ATTRIBUTES), this.getLocator()));
            }
        } else if (ELT_ATTRIBUTE.equals(key)) {
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._daoFactory.createFolderDAO(), "ATTRIBUTES", false);
            if (dbFolder == null) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{ELT_ATTRIBUTE, DBFolder.Family.ATTRIBUTE}), this.getLocator()));
            } else if (dbFolder.getFamily() != DBFolder.Family.ATTRIBUTE) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{ELT_ATTRIBUTE, DBFolder.Family.ATTRIBUTE}), this.getLocator()));
            } else {
                String value = attrs.get("value");
                DBWrap dbWrap = this._daoFactory.findOrCreateWrap(dbFolder);
                if (dbWrap == null) {
                    this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_ERR_DBMOD_ATTRIBS_XML_READ", dbFolder.getRefPath(), this._sourceName), this.getLocator()));
                } else {
                    DBAttrib.Value dbValue = ((DBAttrib)dbWrap).createInstance(value);
                    if (dbValue == null) {
                        String definition = new StringBuilder(128).append("'").append(dbFolder.getRefPath()).append("' = ").append(value).toString();
                        this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_ERR_DBMOD_ATTRIBS_XML_VALUE", definition, this._sourceName), this.getLocator()));
                    } else {
                        this._attributes.add(dbValue);
                    }
                }
            }
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXParseException {
        return ELT_ATTRIBUTES.equals(name);
    }

    public static void writeAttributes(Appendable out, Collection<DBAttrib.Value> attributes, String indent) throws IOException {
        if (attributes.isEmpty()) {
            return;
        }
        out.append(indent).append("<").append(ELT_ATTRIBUTES).append(">\n");
        for (DBAttrib.Value value : attributes) {
            out.append(indent).append("  <").append(ELT_ATTRIBUTE);
            DBObjectXmlUtility.writeDBFolder(out, value.getKey().getDBFolder(), null);
            Object val = value.getValue();
            if (val != null) {
                DBObjectXmlUtility.appendXML(out.append(" ").append("value").append("='"), value.getValue().toString()).append("'");
            }
            out.append("/>\n");
        }
        out.append(indent).append("</").append(ELT_ATTRIBUTES).append(">\n");
    }
}

