/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.icon.gui;

import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.general.icon.gui.IconFolderTree;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class IconPanelTree
extends JPanel {
    CeciliaAppl _application;
    boolean _onlySelect;
    DBFolderTreeModel _ctrlModel;
    IconFolderTree _ctrlTree;

    public IconPanelTree(CeciliaAppl application, boolean onlySelect) {
        super(new BorderLayout());
        this._application = application;
        this._onlySelect = onlySelect;
        this.make();
    }

    private void make() {
        DAOFolder daoFolder = this._application.getDAOFactory().createFolderDAO();
        DBFolder root = daoFolder.getRootID("IMAGE_FAMILIES");
        if (root == null) {
            throw new NullPointerException();
        }
        this._ctrlModel = new DBFolderTreeModel(daoFolder, this._application.getDAOFactory().createUserDAO(), this._application.getDBUser(), DBFolder.Family.IMAG, "Manage-Icon");
        this._ctrlModel.setFolderRoot(root);
        this._application.addFolderUpdateListener(this._ctrlModel);
        this._ctrlTree = new IconFolderTree(this._application, this._ctrlModel, this._onlySelect);
        this._ctrlTree.addDBTreeActionListener(new DBFolderTree.DBTreeActionListener(){

            @Override
            public void actionPerformed(DBFolderTreeNode selectNode, MouseEvent e) {
                DBFolder dbFolder = selectNode.getDBFolder();
                if (dbFolder == null) {
                    return;
                }
                if (dbFolder.isVersion() && IconPanelTree.this._application.isDebugMode() && e.isControlDown()) {
                    IconPanelTree.this._ctrlTree.doDebug(dbFolder);
                }
            }
        });
        JScrollPane scrollTree = new JScrollPane(this._ctrlTree);
        scrollTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        scrollTree.setPreferredSize(new Dimension(250, 200));
        this.add(this.makeToolbar(), "North");
        this.add((Component)scrollTree, "Center");
    }

    private Component makeToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.add(Box.createGlue());
        toolbar.add(this._ctrlTree.getAction("ACTION_ADD").createButton(CeciliaAction.BorderStyle.LIGHT));
        if (!this._onlySelect) {
            toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            toolbar.add(this._ctrlTree.getAction("ACTION_DEL").createButton(CeciliaAction.BorderStyle.LIGHT));
        }
        toolbar.setBorder(CeciliaAction.STANDARD_BORDER);
        toolbar.setFloatable(false);
        return toolbar;
    }

    public void addDBTreeActionListener(DBFolderTree.DBTreeActionListener listener) {
        this._ctrlTree.addDBTreeActionListener(listener);
    }

    public void setSelectionMode(int treeSelectionMode) {
        this._ctrlTree.getSelectionModel().setSelectionMode(treeSelectionMode);
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this._ctrlTree.addTreeSelectionListener(listener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        this._ctrlTree.removeTreeSelectionListener(listener);
    }

    public void setSelectFolder(DBFolder dbFolder) {
        this._ctrlTree.doSelect(dbFolder == null ? null : Collections.singletonList(dbFolder));
    }

    public DBFolder getSelectFolder() {
        return this.convertToDBVersion(this._ctrlTree.getSelectionPath());
    }

    public Collection<DBFolder> getSelectFolders() {
        TreePath[] paths = this._ctrlTree.getSelectionPaths();
        if (paths == null) {
            return Collections.EMPTY_LIST;
        }
        if (paths.length == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashMap<DBFolder, DBFolder> result = new LinkedHashMap<DBFolder, DBFolder>();
        for (int i = 0; i < paths.length; ++i) {
            DBFolder dbFolder = this.convertToDBVersion(paths[i]);
            if (dbFolder == null) continue;
            DBFolder dbParent = dbFolder.getParent();
            DBFolder dbExist = (DBFolder)result.get(dbParent);
            if (dbExist != null) {
                if (Integer.parseInt(dbExist.getName()) >= Integer.parseInt(dbFolder.getName())) continue;
                result.put(dbParent, dbFolder);
                continue;
            }
            result.put(dbParent, dbFolder);
        }
        return result.values();
    }

    protected DBFolder convertToDBVersion(TreePath path) {
        if (path == null) {
            return null;
        }
        DBFolderTreeNode selectNode = (DBFolderTreeNode)path.getLastPathComponent();
        if (selectNode == null) {
            return null;
        }
        DBFolder dbFolder = selectNode.getDBFolder();
        if (dbFolder == null) {
            return null;
        }
        if (dbFolder.isModel()) {
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = this._application.getDAOFactory().createFolderDAO().findChildren(dbFolder);
            }
            if (children != null && children.size() == 1) {
                dbFolder = children.get(0);
            }
        }
        if (dbFolder.isVersion()) {
            return dbFolder;
        }
        return null;
    }

    public boolean atMostOneSelectedFolder() {
        switch (this._ctrlTree.getSelectionCount()) {
            case 0: {
                return false;
            }
            case 1: {
                DBFolder dbFolder = this.convertToDBVersion(this._ctrlTree.getSelectionPath());
                return dbFolder != null;
            }
        }
        TreePath[] paths = this._ctrlTree.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            DBFolder dbFolder = this.convertToDBVersion(paths[i]);
            if (dbFolder == null) continue;
            return true;
        }
        return false;
    }
}

