/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law;

import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class LawManager {
    private static final Logger _LOG = Logger.getLogger(LawManager.class.getPackage().getName());
    public static final int NOTDATA = -1;
    public static final int NODEFAULT = -2;
    public static final String BADPARAM = "mauvais parametre";
    protected String _name;
    protected List<LawData> _lstLaws;
    protected Map<Integer, LawData> _mapLaws;
    protected Map<Integer, ParamData> _mapParams;
    protected LawManager _parameterManager;
    protected LawManager _modifierManager;
    protected int _defaultLaw;

    public LawManager(String name) {
        this._name = name;
        this._lstLaws = new ArrayList<LawData>();
        this._mapLaws = new HashMap<Integer, LawData>();
        this._mapParams = new HashMap<Integer, ParamData>();
        this._parameterManager = null;
        this._modifierManager = null;
        this._defaultLaw = -1;
    }

    public void setParameterManager(LawManager mng) {
        this._parameterManager = mng;
    }

    public LawManager getParameterManager() {
        return this._parameterManager;
    }

    public void setModifierManager(LawManager mng) {
        this._modifierManager = mng;
    }

    public LawManager getModifierManager() {
        return this._modifierManager;
    }

    public String format(double value) {
        return String.valueOf(value);
    }

    public String getID() {
        return this._name;
    }

    public Collection<LawData> getDataLaws() {
        return this._lstLaws;
    }

    public boolean isInspectedCompatible(Law law) {
        return false;
    }

    public boolean isConstanteCompatible(Law law) {
        return false;
    }

    public ParamData defineParam(int id, String lbl, String tlt, TypeParam type, double def) {
        ParamData result = new ParamData(id, lbl, tlt, type, def);
        if (this._mapParams.put(id, result) != null) {
            _LOG.info("Il y a deja un parametre avec l'ID '" + id + "' dans le gestionnaire " + this._name);
        }
        return result;
    }

    public boolean addParam(int idLaw, ParamData param) {
        LawData law = this.getLaw(idLaw);
        if (this._mapParams.get(param.getID()) == null) {
            _LOG.info("Utilisation d'une definition de parametre inconnu dans le gestionnaire " + this._name);
        }
        if (law == null) {
            return false;
        }
        law.add(param);
        return true;
    }

    public ParamData getParam(int id) {
        ParamData param = this._mapParams.get(id);
        if (param == null) {
            _LOG.info("Recherche d'un parametre avec un ID '" + id + "' inconnu dans le gestionnaire " + this._name);
        }
        return param;
    }

    public LawData getLaw(int id) {
        LawData law = this._mapLaws.get(id);
        if (law == null) {
            _LOG.info("Recherche d'une loi avec un ID '" + id + "' inconnu dans le gestionnaire " + this._name);
        }
        return law;
    }

    public LawData defineLaw(int id, String lbl, String tt, int version, String dagExport, String xmlExport) {
        LawData conflictLaw = this.findIdLawFromExport(dagExport);
        if (this.findIdLawFromXMLExport(xmlExport) != null) {
            _LOG.info("Il y a deja une loi avec l'export XML '" + xmlExport + "' dans le gestionnaire " + this._name);
        }
        LawData result = new LawData(id, lbl, tt, dagExport, xmlExport, version);
        this._lstLaws.add(result);
        LawData old = this._mapLaws.put(id, result);
        if (old != null) {
            _LOG.info("Il y a deja une loi avec l'ID '" + id + "' dans le gestionnaire " + this._name);
            this._lstLaws.remove(old);
        }
        if (conflictLaw != null) {
            conflictLaw._dagExportConflict = true;
            result._dagExportConflict = true;
        }
        return result;
    }

    public boolean addLawDagExportAlias(int idLaw, String dagExport) {
        LawData result = this.getLaw(idLaw);
        if (result == null) {
            return false;
        }
        LawData conflictLaw = this.findIdLawFromExport(dagExport);
        result.addAliasDag(dagExport);
        if (conflictLaw != null) {
            conflictLaw._dagExportConflict = true;
            result._dagExportConflict = true;
        }
        return true;
    }

    public int getNbrLaw() {
        return this._lstLaws.size();
    }

    public int[] getLaws() {
        int[] result = new int[this._lstLaws.size()];
        for (int i = 0; i < this._lstLaws.size(); ++i) {
            result[i] = this._lstLaws.get((int)i)._idLaw;
        }
        return result;
    }

    public LawData findIdLawFromExport(String export) {
        for (LawData lawData : this._lstLaws) {
            if (!lawData.acceptExportName(export)) continue;
            return lawData;
        }
        return null;
    }

    public LawData findIdLawFromXMLExport(String export) {
        for (LawData lawData : this._lstLaws) {
            if (!export.equals(lawData._xmlExport)) continue;
            return lawData;
        }
        return null;
    }

    public Law createLaw(int idLaw) {
        if (idLaw == -1) {
            idLaw = this._defaultLaw;
        }
        assert (idLaw != -1);
        LawData datalaw = this.getLaw(idLaw);
        assert (datalaw != null) : "No law (" + idLaw + ")";
        Law create = new Law(idLaw, this);
        for (int i = 0; i < datalaw.size(); ++i) {
            Param par = this.createParam((ParamData)datalaw.get(i));
            if (par == null) {
                return null;
            }
            create.setParamAt(i, par);
        }
        return create;
    }

    public Param createParam(ParamData data) {
        return new ParamValue(data._type, data._default);
    }

    public Param createParam(TypeParam type) {
        return new ParamValue(type, type.getDefaultValue());
    }

    public abstract double evaluate(Param var1);

    public abstract double evaluate(Law var1, double var2);

    public static class LawData
    extends ArrayList<ParamData> {
        int _idLaw;
        String _label;
        String _tooltip;
        String _dagExport;
        boolean _dagExportConflict;
        String _xmlExport;
        int _version;
        List<String> _aliasDagExport;

        public LawData(int id, String lbl, String tooltip, String dagExport, String xmlExport, int version) {
            this._idLaw = id;
            this._label = lbl;
            this._tooltip = tooltip;
            this._dagExport = dagExport;
            this._xmlExport = xmlExport;
            this._version = version;
            this._aliasDagExport = new ArrayList<String>(3);
        }

        public int getID() {
            return this._idLaw;
        }

        public String getLabel() {
            return this._label;
        }

        public String getTooltip() {
            return this._tooltip;
        }

        public String getExportDag() {
            return this._dagExport;
        }

        public boolean isConflictExportDag() {
            return this._dagExportConflict;
        }

        public String getExportXML() {
            return this._xmlExport;
        }

        public int getVersion() {
            return this._version;
        }

        public void addAliasDag(String export) {
            if (!this._aliasDagExport.contains(export)) {
                this._aliasDagExport.add(export);
            }
        }

        public boolean acceptExportName(String export) {
            if (export.equals(this._dagExport)) {
                return true;
            }
            return !this._aliasDagExport.isEmpty() && this._aliasDagExport.contains(export);
        }
    }

    public class ParamData {
        int _idParam;
        String _label;
        String _tooltip;
        TypeParam _type;
        double _default;
        boolean _opt;

        ParamData(int id, String lbl, String tlt, TypeParam idType, double def) {
            this._idParam = id;
            this._label = lbl;
            this._tooltip = tlt;
            this._type = idType;
            this._default = def;
            this._opt = false;
        }

        public int getID() {
            return this._idParam;
        }

        public String getLabel() {
            return this._label;
        }

        public String getTooltip() {
            return this._tooltip;
        }

        public TypeParam getType() {
            return this._type;
        }

        public double getDefaultValue() {
            return this._default;
        }

        public boolean isOpt() {
            return this._opt;
        }

        public ParamData setOpt(boolean value) {
            this._opt = value;
            return this;
        }
    }
}

