/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawException;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ResLaw;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.io.ParamHandlerXml;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class LawHandlerXml
extends ParamHandlerXml {
    TypeParam _defaultType = null;
    Law _law = null;
    LawManager.LawData _lawInfo = null;
    int _idxParam = 0;
    String _startName;

    public LawHandlerXml(DBLogs.DBLogsManager logMng, Locator locator, CECFactory cecFactory, LawManager lawManager) {
        super(logMng, locator, cecFactory, lawManager);
    }

    public void setDefaultType(TypeParam type) {
        this._defaultType = type;
    }

    public Law getLaw() {
        return this._law;
    }

    @Override
    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            this._startName = name;
            String type = attrs.get("type");
            if (type == null || type.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", this._startName, "type"), this.getLocator()));
            }
            this._lawInfo = this._lawManager.findIdLawFromXMLExport(type);
            if (this._lawInfo == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", this._startName, "type", type), this.getLocator()));
            }
            this._law = this._lawManager.createLaw(this._lawInfo.getID());
        } else if (this._childHandler != null) {
            this._childHandler.startAction(name, attrs, false);
        } else if ("law.modifier".equals(name)) {
            if (this._lawManager.getModifierManager() == null) {
                this.error(new SAXParseException(ResMsgObj.getString("MSG_ERR_DBMOD_LAW_NO_MANAGER"), this.getLocator()));
            }
            this._childHandler = new LawHandlerXml(this.getLogManager(), this.getLocator(), this._cecFactory, this._lawManager.getModifierManager()){

                @Override
                protected String getOwnerObject() {
                    return LawHandlerXml.this.getOwnerObject();
                }
            };
            this._childHandler.startAction(name, attrs, true);
        } else {
            super.startAction(name, attrs, startAction);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._childHandler != null) {
            boolean result = this._childHandler.endAction(name, attrs, txt);
            if (result) {
                this.manageChildEndAction(name);
                this._childHandler = null;
            }
            return false;
        }
        boolean result = this._startName.equals(name);
        if (result) {
            if (this._idxParam != this._lawInfo.size()) {
                this.warning(new SAXParseException(this.getOwnerObject() + ": " + ResLaw.getString("MSG_ERR_WRONG_NUMBER_OF_PARAMS"), this.getLocator()));
                this._law = this._lawManager.createLaw(this._lawInfo.getID());
            } else {
                try {
                    this._law.verify(this._cecFactory);
                }
                catch (LawException e) {
                    this.warning(new SAXParseException(this.getOwnerObject() + ": " + ResLaw.getString("MSG_ERR_WRONG_LAW"), this.getLocator(), e));
                    this._law = this._lawManager.createLaw(this._lawInfo.getID());
                }
            }
        }
        return result;
    }

    @Override
    protected TypeParam getCurrentType() {
        TypeParam type = ((LawManager.ParamData)this._lawInfo.get(this._idxParam)).getType();
        if (type == null) {
            type = this._defaultType;
        }
        return type;
    }

    @Override
    protected Param createDefaultParam() {
        return this._lawManager.createParam((LawManager.ParamData)this._lawInfo.get(this._idxParam));
    }

    @Override
    protected void manageCreateParam(Param param) {
        this._law.setParamAt(this._idxParam++, param);
    }

    @Override
    protected void manageChildEndAction(String name) {
        if ("law.modifier".equals(name)) {
            this._law.setModifierLaw(this._childHandler.getLaw());
        } else {
            super.manageChildEndAction(name);
        }
    }
}

