/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.log;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class GeneralLogsPreferencies
implements PluginWithOptions,
PlugPanel {
    public static String PREF_KEY = GeneralLogsPreferencies.class.getName();
    public static final String PREF_LEVEL_DISPLAY = PREF_KEY + "#LevelDisplay";
    public static final String PREF_LEVEL_DEPENDENCY = PREF_KEY + "#LevelDependency";
    JPanel _perfsPanel;
    DBLogs.DBLevel _valueLevelDisplay = DBLogs.DBLevel.INFO;
    DBLogs.DBLevel _valueLevelDepends = DBLogs.DBLevel.WARNING;
    JComboBox _ctrlLevelDisplay;
    JComboBox _ctrlLevelDepends;
    public static final String PREF_UPDATE = PREF_KEY + "#Update";
    private UpdatePref _updatePref;
    JComboBox<UpdatePref> _majPrefsCB;

    @Override
    public void trash() {
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        this.load(launcher);
        return this;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        this.load(launcher);
    }

    @Override
    public boolean validOptions(Plugable launcher) {
        this.save(launcher);
        return true;
    }

    @Override
    public JPanel getPanel() {
        return this.makeContent();
    }

    @Override
    public String getInfo(String key) {
        if ("plugin.key".equals(key)) {
            return PREF_KEY;
        }
        if ("plugin.key.path".equals(key)) {
            return "GENERAL";
        }
        if ("plugin.name".equals(key)) {
            return ResMsgVoc.getString("VOC_LOGS_UPDATE");
        }
        if ("plugin.title".equals(key)) {
            return ResMsgObj.getString("PREF_GENERAL_LOG_TITLE");
        }
        if ("plugin.description".equals(key)) {
            return ResMsgObj.getString("PREF_GENERAL_LOG_LEVEL_TITLE");
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        return null;
    }

    protected JPanel makeContent() {
        if (this._perfsPanel == null) {
            this._perfsPanel = new JPanel(new GridBagLayout());
            this._perfsPanel.add(this.createPrefLogsPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 20, 10, 10), 0, 0));
            this._perfsPanel.add((Component)this.createUpdatePrefPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 20, 10, 10), 0, 0));
            this._perfsPanel.add((Component)new JLabel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this._perfsPanel;
    }

    protected void load(Plugable launcher) {
        this.loadPrefLogs(launcher);
        this.loadPrefUpdate(launcher);
    }

    protected void save(Plugable launcher) {
        this.savePrefLogs(launcher);
        this.savePrefUpdate(launcher);
    }

    private Component createPrefLogsPanel() {
        this._ctrlLevelDisplay = new JComboBox();
        this._ctrlLevelDisplay.addItem(DBLogs.DBLevel.WARNING);
        this._ctrlLevelDisplay.addItem(DBLogs.DBLevel.INFO);
        this._ctrlLevelDisplay.addItem(DBLogs.DBLevel.FINE);
        this._ctrlLevelDisplay.addItem(DBLogs.DBLevel.FINER);
        this._ctrlLevelDisplay.addItem(DBLogs.DBLevel.FINEST);
        this._ctrlLevelDisplay.setSelectedItem((Object)this._valueLevelDisplay);
        this._ctrlLevelDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralLogsPreferencies.this._valueLevelDisplay = (DBLogs.DBLevel)((Object)GeneralLogsPreferencies.this._ctrlLevelDisplay.getSelectedItem());
            }
        });
        this._ctrlLevelDisplay.setRenderer(DBLogs.DBLevel.getListCellRenderer());
        this._ctrlLevelDepends = new JComboBox();
        this._ctrlLevelDepends.addItem(DBLogs.DBLevel.ERROR);
        this._ctrlLevelDepends.addItem(DBLogs.DBLevel.WARNING);
        this._ctrlLevelDepends.addItem(DBLogs.DBLevel.INFO);
        this._ctrlLevelDepends.addItem(DBLogs.DBLevel.FINE);
        this._ctrlLevelDepends.setSelectedItem((Object)this._valueLevelDepends);
        this._ctrlLevelDepends.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralLogsPreferencies.this._valueLevelDepends = (DBLogs.DBLevel)((Object)GeneralLogsPreferencies.this._ctrlLevelDepends.getSelectedItem());
            }
        });
        this._ctrlLevelDepends.setRenderer(DBLogs.DBLevel.getListCellRenderer());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(ResMsgObj.getString("PREF_GENERAL_LOG_LEVEL_DISPLAY")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlLevelDisplay, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(ResMsgObj.getString("PREF_GENERAL_LOG_LEVEL_DEPENDS")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlLevelDepends, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(ResMsgObj.getString("PREF_GENERAL_LOG_LEVEL_TITLE")));
        return panel;
    }

    private DBLogs.DBLevel loadDBLogsLevel(Plugable launcher, String key, DBLogs.DBLevel def) {
        String value = PlugableUtility.getStrOpt(launcher, key, def.toString());
        DBLogs.DBLevel select = null;
        if (value != null && !value.isEmpty()) {
            DBLogs.DBLevel[] type = DBLogs.DBLevel.values();
            for (int i = 0; select == null && i < type.length; ++i) {
                if (!type[i].toString().equalsIgnoreCase(value)) continue;
                select = type[i];
            }
        }
        if (select == null) {
            select = def;
        }
        return select;
    }

    protected void loadPrefLogs(Plugable launcher) {
        this._valueLevelDisplay = this.loadDBLogsLevel(launcher, PREF_LEVEL_DISPLAY, DBLogs.DBLevel.INFO);
        if (this._ctrlLevelDisplay != null) {
            this._ctrlLevelDisplay.setSelectedItem((Object)this._valueLevelDisplay);
        }
        this._valueLevelDepends = this.loadDBLogsLevel(launcher, PREF_LEVEL_DEPENDENCY, DBLogs.DBLevel.WARNING);
        if (this._ctrlLevelDepends != null) {
            this._ctrlLevelDepends.setSelectedItem((Object)this._valueLevelDepends);
        }
    }

    protected void savePrefLogs(Plugable launcher) {
        launcher.setOption(PREF_LEVEL_DISPLAY, this._valueLevelDisplay.toString());
        launcher.setOption(PREF_LEVEL_DEPENDENCY, this._valueLevelDepends.toString());
    }

    public DBLogs.DBLevel getLevelDisplay() {
        return this._valueLevelDisplay;
    }

    public DBLogs.DBLevel getLevelDepends() {
        return this._valueLevelDepends;
    }

    public UpdatePref getUpdatePref() {
        return this._updatePref;
    }

    protected void loadPrefUpdate(Plugable launcher) {
        String value = PlugableUtility.getStrOpt(launcher, PREF_UPDATE, UpdatePref.ASK.toString());
        this._updatePref = this.loadUpdate(value);
        if (this._majPrefsCB != null) {
            this._majPrefsCB.setSelectedItem((Object)this._updatePref);
        }
    }

    protected void savePrefUpdate(Plugable launcher) {
        launcher.setOption(PREF_UPDATE, this._updatePref.name());
    }

    private UpdatePref loadUpdate(String value) {
        UpdatePref pref = UpdatePref.valueOf(value);
        return pref == null ? UpdatePref.ASK : pref;
    }

    private JPanel createUpdatePrefPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel lbl = new JLabel(ResMsgObj.getString("PREF_GENERAL_UPDATE"));
        panel.add((Component)lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(this.createUpdatePrefCB(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        return panel;
    }

    private JComboBox<UpdatePref> createUpdatePrefCB() {
        this._majPrefsCB = new JComboBox();
        this._majPrefsCB.addItem(UpdatePref.ALWAYS);
        this._majPrefsCB.addItem(UpdatePref.NEVER);
        this._majPrefsCB.addItem(UpdatePref.ASK);
        this._majPrefsCB.addActionListener(e -> {
            this._updatePref = (UpdatePref)((Object)((Object)this._majPrefsCB.getSelectedItem()));
        });
        this._majPrefsCB.setSelectedItem((Object)this._updatePref);
        this._majPrefsCB.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                JLabel lbl = (JLabel)comp;
                UpdatePref pref = (UpdatePref)((Object)value);
                lbl.setText(pref.getText());
                lbl.setToolTipText(pref.getTooltip());
                return lbl;
            }
        });
        return this._majPrefsCB;
    }

    public static enum UpdatePref {
        ALWAYS("VOC_UPDATE_PREF_ALWAYS", "VOC_UPDATE_PREF_ALWAYS_TOOLTIP"),
        NEVER("VOC_UPDATE_PREF_NEVER", "VOC_UPDATE_PREF_NEVER_TOOLTIP"),
        ASK("VOC_UPDATE_PREF_ASK", "VOC_UPDATE_PREF_ASK_TOOLTIP");

        String _text;
        String _tooltip;

        private UpdatePref(String text, String tooltip) {
            this._text = text;
            this._tooltip = tooltip;
        }

        public String getText() {
            return ResMsgVoc.getString(this._text);
        }

        public String getTooltip() {
            return ResMsgVoc.getString(this._tooltip);
        }
    }
}

