/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.nparam;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.io.SAXLogHandler;
import com.dassault.cecilia.dbobj.general.nparam.io.DBParamHandler;
import com.dassault.cecilia.dbobj.general.nparam.io.DBParamHandlerRaw;
import com.dassault.cecilia.dbobj.general.nparam.io.DBParamHandlerXml;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DBParam
extends DBWrap {
    private static Logger _LOG = Logger.getLogger(DBParam.class.getPackage().getName());
    TypeParam _type = TypeParam.RATE;
    Param _value = new ParamValue(this._type, 0.001);

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public DBParam(DBFolder folder) {
        super(folder);
    }

    @Override
    public DBParam getCopy() {
        DBParam dest = new DBParam(this._dbFolder);
        dest.copy(this);
        dest._type = this._type;
        dest._value = this._value.getCopy();
        return dest;
    }

    public TypeParam getType() {
        return this._type;
    }

    public void setType(TypeParam type) {
        this._type = type;
    }

    public Param getValue() {
        return this._value;
    }

    public void setValue(Param param) {
        this._value = param;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBParam)) {
            return false;
        }
        DBParam param = (DBParam)obj;
        if (!param.getType().equals((Object)this.getType())) {
            return false;
        }
        return param.getValue().equals(this.getValue());
    }

    @Override
    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        List<Function<DBWrap, CompareResult>> list = super.getFieldsToCompare(factoryWrap, forImport);
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                String type1 = DBParam.this.getType().toString();
                String type2 = ((DBParam)wrap).getType().toString();
                return new CompareResultString(ResMsgVoc.getString("VOC_TYPE"), type1, type2);
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                Param param1 = DBParam.this.getValue();
                Param param2 = ((DBParam)wrap).getValue();
                return new CompareResultString(ResMsgVoc.getString("VOC_PARAMETER"), param1.getFieldsCompare(), param2.getFieldsCompare());
            }
        });
        return list;
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.PARAMETER;
    }

    @Override
    protected String getNature() {
        return "parameter";
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        InputStream istream;
        InputStream stream = null;
        SAXLogHandler handler = null;
        String format = model.getFormat();
        if ("RAWTOHEX".equals(format)) {
            istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            String istr = DAOObjModel.convertWithFromRAWTOHEX(istream);
            if (istr == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                return false;
            }
            stream = new ByteArrayInputStream(istr.getBytes());
            handler = new DBParamHandlerRaw(logMng, cecFactory);
        } else if ("RAW".equals(format)) {
            istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            byte[] ibyte = DAOObjModel.convertAsByte(istream);
            if (ibyte == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                return false;
            }
            stream = new ByteArrayInputStream(ibyte);
            handler = new DBParamHandlerRaw(logMng, cecFactory);
        } else if ("ZML".equals(format) || "XML".equals(format)) {
            stream = this.getBinaryStream(model, cecFactory, logMng);
            if (stream == null) {
                return false;
            }
            if ("ZML".equals(format)) {
                stream = new InflaterInputStream(stream, new Inflater());
            }
            handler = new DBParamHandlerXml(logMng, null, cecFactory);
        } else {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
            return false;
        }
        if (stream != null && handler != null && handler instanceof DBParamHandler) {
            try {
                this.readXml(stream, handler);
                DBParamHandler hParam = handler;
                this._type = hParam.getParamType();
                this._value = hParam.getParamValue();
                return true;
            }
            catch (IOException e) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC"));
            }
        }
        return false;
    }

    @Override
    protected void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("cec.parameter");
        DBObjectXmlUtility.appendXML(out.append(" ").append("type").append("='"), this._type.toString().toLowerCase()).append("'");
        out.append(">\n");
        this._value.toXML(out, indent + "  ", true);
        out.append(indent).append("</").append("cec.parameter").append(">\n");
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        this._value.addRelation(this.getDBFolder(), "PARAMETER", relations);
        return relations;
    }
}

