/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.update;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.log.GeneralLogsPreferencies;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public abstract class UpdateUtility {
    private JButton _updateButton = new JButton(ResMsgVoc.getString("VOC_UPDATE"));
    private DBInternalFrame _frame;

    protected UpdateUtility(DBInternalFrame frame) {
        this._frame = frame;
        this._updateButton.addActionListener(e -> {
            this.updateEdit();
            this.refreshVisibility();
        });
    }

    protected abstract DBWrap getWrap();

    protected abstract CECFactory getCECFactory();

    protected abstract Preferencies getPreferencies();

    protected abstract boolean withUpdateEdit();

    protected abstract void updateEdit();

    public boolean askForUpdate() {
        int result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this._frame), ResMsgObj.getString("MSG_UPDATE_OBJECT"), JOptionCecilia.getTopTitleOf(this._frame), 0);
        return result == 0;
    }

    public JButton getButUpdate() {
        return this._updateButton;
    }

    public void update() {
        PluginWithOptions pref = this.getPreferencies().getOptions(GeneralLogsPreferencies.PREF_KEY);
        GeneralLogsPreferencies.UpdatePref updatePref = !(pref instanceof GeneralLogsPreferencies) ? GeneralLogsPreferencies.UpdatePref.ASK : ((GeneralLogsPreferencies)pref).getUpdatePref();
        if (updatePref != GeneralLogsPreferencies.UpdatePref.NEVER && this.canBeUpdated()) {
            switch (updatePref) {
                case ASK: {
                    if (!this.askForUpdate()) break;
                    this.updateEdit();
                    break;
                }
                case ALWAYS: {
                    this.updateEdit();
                    break;
                }
            }
        }
        this.refreshVisibility();
    }

    public boolean canBeUpdated() {
        return this.withUpdateEdit() && this.getWrap().changeDependTimeUpdt();
    }

    public void refreshVisibility() {
        this._updateButton.setVisible(this.canBeUpdated());
    }
}

