/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaImage;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLine;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPolygone;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaText;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.VisioPropsDlg;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class OCmdEditVisio
extends OCCmd {
    public static final int UNDEF = -3;
    public static final int NaV = -2;
    List<GrfProps> _graphics = new ArrayList<GrfProps>(16);
    GrfProps _propertyDo;

    public OCmdEditVisio(CeciliaAppl appl, AltaContentEditPanel c) {
        super(appl, c);
    }

    @Override
    protected boolean prepareDo() {
        int nbrGroup = 0;
        int nbrLine = 0;
        int nbrPolygone = 0;
        int nbrForm = 0;
        int nbrText = 0;
        int nbrIcon = 0;
        GrfProps combine = new GrfProps();
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph grf : sheet.getGraphs()) {
                if (!grf.isSelected() || grf.isLocked() || !grf.isVisio()) continue;
                GrfProps curr = new GrfProps(grf);
                combine.combine(curr);
                this._graphics.add(curr);
                switch (curr._type) {
                    case FORM: {
                        ++nbrForm;
                        break;
                    }
                    case GROUP: {
                        ++nbrGroup;
                        break;
                    }
                    case LINE: {
                        ++nbrLine;
                        break;
                    }
                    case POLYGONE: {
                        ++nbrPolygone;
                        break;
                    }
                    case TEXT: {
                        ++nbrText;
                        break;
                    }
                    case ICON: {
                        ++nbrIcon;
                    }
                }
            }
        }
        if (this._graphics.isEmpty()) {
            return false;
        }
        VisioPropsDlg dlg = new VisioPropsDlg(SwingUtilities.getWindowAncestor(this.getPanel()), this.getAppl());
        dlg.setVisibleLocation(nbrForm + nbrGroup + nbrText + nbrIcon > 0, combine.x, combine.y);
        dlg.setVisibleSize(nbrForm + nbrText + nbrIcon > 0, combine.w, combine.h);
        dlg.setVisibleColor(nbrForm + nbrText + nbrLine + nbrPolygone > 0, combine.ccf, combine.cf, nbrForm + nbrText + nbrPolygone > 0, combine.ccb, combine.cb);
        dlg.setVisibleArrows(nbrLine > 0, combine.ab, combine.ae);
        dlg.setVisibleText(nbrText > 0, combine.bDiffText ? null : combine.text, combine.fs, combine.fb, combine.fi, combine.ah, combine.av);
        dlg.setVisibleIcon(nbrIcon > 0, combine.bDiffIcon ? null : combine.dbIcon);
        dlg.pack();
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this.getSource()));
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return false;
        }
        this._propertyDo = new GrfProps();
        if (dlg.isValidX()) {
            this._propertyDo.x = dlg.getValueX();
        }
        if (dlg.isValidY()) {
            this._propertyDo.y = dlg.getValueY();
        }
        if (dlg.isValidW()) {
            this._propertyDo.w = dlg.getValueW();
        }
        if (dlg.isValidH()) {
            this._propertyDo.h = dlg.getValueH();
        }
        if (dlg.isValidFore()) {
            this._propertyDo.ccf = 1;
            this._propertyDo.cf = dlg.getColorFore().getRGB();
        }
        this._propertyDo.ccb = -3;
        if (dlg.isValidBackOpaque()) {
            switch (dlg.getBackOpaque()) {
                case PARTIAL: {
                    this._propertyDo.ccb = -2;
                    break;
                }
                case TRUE: {
                    this._propertyDo.ccb = 1;
                    break;
                }
                case FALSE: {
                    this._propertyDo.ccb = 0;
                }
            }
        }
        if (this._propertyDo.ccb == -2 || this._propertyDo.ccb == 1) {
            Color color = dlg.getColorBack();
            this._propertyDo.cb = color == null ? 0 : color.getRGB();
        }
        if (dlg.isValidArrowBeg()) {
            int n = this._propertyDo.ab = dlg.withArrowBeg() ? 1 : 0;
        }
        if (dlg.isValidArrowEnd()) {
            int n = this._propertyDo.ae = dlg.withArrowEnd() ? 1 : 0;
        }
        if (dlg.isValidFontSize()) {
            this._propertyDo.fs = dlg.getFontSize();
        }
        if (dlg.isValidFontBold()) {
            int n = this._propertyDo.fb = dlg.withFontBold() ? 1 : 0;
        }
        if (dlg.isValidFontItalic()) {
            int n = this._propertyDo.fi = dlg.withFontItalic() ? 1 : 0;
        }
        if (dlg.isValidText()) {
            this._propertyDo.text = dlg.getValueText();
        }
        if (dlg.isValidAlignH()) {
            this._propertyDo.ah = dlg.getValueAlignH();
        }
        if (dlg.isValidAlignV()) {
            this._propertyDo.av = dlg.getValueAlignV();
        }
        if (dlg.isValidIcon()) {
            this._propertyDo.dbIcon = dlg.getValueIcon();
        }
        return true;
    }

    @Override
    protected void firstDo() {
        this.redo();
        this.getPanel().addHisto(this);
    }

    @Override
    public void redo() {
        for (int i = this._graphics.size() - 1; i >= 0; --i) {
            this._graphics.get(i).affect(this._propertyDo);
        }
        this.refreshAll();
    }

    @Override
    public void undo() {
        for (int i = this._graphics.size() - 1; i >= 0; --i) {
            this._graphics.get(i).affect(null);
        }
        this.refreshAll();
    }

    private static class GrfProps {
        AlgaGraph _grf;
        TypeVisio _type;
        int x = -3;
        int y = -3;
        int w = -3;
        int h = -3;
        int ccf = -3;
        int cf = -3;
        int ccb = -3;
        int cb = -3;
        int ab = -3;
        int ae = -3;
        int fb = -3;
        int fi = -3;
        int fs = -3;
        int ah = -3;
        int av = -3;
        boolean bDiffText = false;
        String text = null;
        boolean bDiffIcon = false;
        DBIcon dbIcon = null;

        GrfProps() {
        }

        GrfProps(AlgaGraph grf) {
            this();
            this._grf = grf;
            if (grf instanceof AlgaGroup) {
                this._type = TypeVisio.GROUP;
                this.x = grf.getX();
                this.y = grf.getY();
            } else if (grf instanceof AlgaForm) {
                this._type = TypeVisio.FORM;
                this.x = grf.getX();
                this.y = grf.getY();
                this.w = ((AlgaForm)grf).getWUser();
                this.h = ((AlgaForm)grf).getHUser();
                if (grf instanceof AlgaImage) {
                    this._type = TypeVisio.ICON;
                    this.dbIcon = ((AlgaImage)grf).getDBIcon();
                } else {
                    this.ccf = 0;
                    this.cf = grf.getForeground().getRGB();
                    this.ccb = grf.isOpaque() ? 1 : 0;
                    this.cb = grf.getBackground().getRGB();
                    if (grf instanceof AlgaText) {
                        this._type = TypeVisio.TEXT;
                        AlgaText gText = (AlgaText)grf;
                        this.fs = gText.getFontSize();
                        this.fb = gText.isFontBold() ? 1 : 0;
                        this.fi = gText.isFontItalic() ? 1 : 0;
                        this.ah = gText.getHorizontalAlignement().ordinal();
                        this.av = gText.getVerticalAlignement().ordinal();
                        this.text = gText.getText();
                    }
                }
            } else if (grf instanceof AlgaLine) {
                this._type = TypeVisio.LINE;
                this.ccf = 0;
                this.cf = grf.getForeground().getRGB();
                this.ab = ((AlgaLine)grf).isArrowBegin() ? 1 : 0;
                this.ae = ((AlgaLine)grf).isArrowEnd() ? 1 : 0;
            } else if (grf instanceof AlgaPolygone) {
                this._type = TypeVisio.POLYGONE;
                this.ccf = 0;
                this.cf = grf.getForeground().getRGB();
                this.ccb = grf.isOpaque() ? 1 : 0;
                this.cb = grf.getBackground().getRGB();
            }
        }

        private int combine(int ref, int add) {
            if (add != -3) {
                switch (ref) {
                    case -3: {
                        return add;
                    }
                    case -2: {
                        return ref;
                    }
                }
                if (ref != add) {
                    return -2;
                }
            }
            return ref;
        }

        void combine(GrfProps other) {
            this.x = this.combine(this.x, other.x);
            this.y = this.combine(this.y, other.y);
            this.w = this.combine(this.w, other.w);
            this.h = this.combine(this.h, other.h);
            this.ccf = this.combine(this.ccf, other.ccf);
            this.cf = this.combine(this.cf, other.cf);
            this.ccb = this.combine(this.ccb, other.ccb);
            this.cb = this.combine(this.cb, other.cb);
            this.ab = this.combine(this.ab, other.ab);
            this.ae = this.combine(this.ae, other.ae);
            this.fb = this.combine(this.fb, other.fb);
            this.fi = this.combine(this.fi, other.fi);
            this.fs = this.combine(this.fs, other.fs);
            this.ah = this.combine(this.ah, other.ah);
            this.av = this.combine(this.av, other.av);
            if (this.text == null) {
                this.text = other.text;
            } else if (!this.bDiffText && !this.text.equals(other.text)) {
                this.bDiffText = true;
            }
            if (this.dbIcon == null) {
                this.dbIcon = other.dbIcon;
            } else if (!this.bDiffIcon && !this.dbIcon.equals(other.dbIcon)) {
                this.bDiffIcon = true;
            }
        }

        public void affect(GrfProps props) {
            AlgaGraph grf;
            if (props == null) {
                props = this;
            }
            if ((grf = this._grf) instanceof AlgaGroup) {
                if (props.x >= 0) {
                    grf.setX(props.x);
                }
                if (props.y >= 0) {
                    grf.setY(props.y);
                }
            } else if (grf instanceof AlgaForm) {
                AlgaForm form = (AlgaForm)grf;
                if (grf instanceof AlgaImage) {
                    if (props.dbIcon != null) {
                        ((AlgaImage)grf).setDBIcon(props.dbIcon);
                    }
                } else {
                    if (props.ccf >= 0) {
                        grf.setForeground(new Color(props.cf));
                    }
                    switch (props.ccb) {
                        case 0: {
                            grf.setOpaque(false);
                            break;
                        }
                        case 1: {
                            grf.setOpaque(true);
                            grf.setBackground(new Color(props.cb));
                            break;
                        }
                        case -2: {
                            grf.setBackground(new Color(props.cb));
                        }
                    }
                    if (grf instanceof AlgaText) {
                        AlgaText gText = (AlgaText)grf;
                        if (props.fs >= 0 || props.fb >= 0 || props.fi >= 0) {
                            gText.setFont(props.fs >= 0 ? props.fs : gText.getFontSize(), props.fb >= 0 ? props.fb != 0 : gText.isFontBold(), props.fi >= 0 ? props.fi != 0 : gText.isFontItalic());
                        }
                        if (props.ah >= 0) {
                            gText.setHorizontalAlignement(AlgaText.HAlignement.values()[props.ah]);
                        }
                        if (props.av >= 0) {
                            gText.setVerticalAlignement(AlgaText.VAlignement.values()[props.av]);
                        }
                        if (props.text != null) {
                            gText.setText(props.text);
                        }
                    }
                }
                if (props.w >= 0) {
                    form.setWUser(props.w);
                }
                if (props.h >= 0) {
                    form.setHUser(props.h);
                }
                if (props.x >= 0) {
                    grf.setX(props.x);
                }
                if (props.y >= 0) {
                    grf.setY(props.y);
                }
            } else if (grf instanceof AlgaLine) {
                if (props.ccf >= 0) {
                    grf.setForeground(new Color(props.cf));
                }
                if (props.ab >= 0) {
                    ((AlgaLine)grf).setArrowBegin(props.ab != 0);
                }
                if (props.ae >= 0) {
                    ((AlgaLine)grf).setArrowEnd(props.ae != 0);
                }
            } else if (grf instanceof AlgaPolygone) {
                if (props.ccf >= 0) {
                    grf.setForeground(new Color(props.cf));
                }
                switch (props.ccb) {
                    case 0: {
                        grf.setOpaque(false);
                        break;
                    }
                    case 1: {
                        grf.setOpaque(true);
                        grf.setBackground(new Color(props.cb));
                        break;
                    }
                    case -2: {
                        grf.setBackground(new Color(props.cb));
                    }
                }
            }
            grf.computeControlPoints();
        }
    }

    private static enum TypeVisio {
        GROUP,
        LINE,
        POLYGONE,
        TEXT,
        ICON,
        FORM;

    }
}

