/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import java.util.ArrayList;
import java.util.List;

public class OCmdGroupDissociate
extends OCCmd {
    List<AlgaGroup> _groups = new ArrayList<AlgaGroup>(8);
    List<AlgaSheet> _sheets = new ArrayList<AlgaSheet>(8);
    List<Integer> _indexs;

    public OCmdGroupDissociate(AltaContentEditPanel c) {
        super(c.getAppl(), c);
    }

    @Override
    protected boolean prepareDo() {
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected() || graph.isLocked() || !(graph instanceof AlgaGroup)) continue;
                this._groups.add((AlgaGroup)graph);
                this._sheets.add(sheet);
            }
        }
        return this._groups.size() > 0;
    }

    @Override
    protected void firstDo() {
        if (this._groups.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    @Override
    public void redo() {
        this._indexs = new ArrayList<Integer>(this._groups.size());
        for (int i = this._groups.size() - 1; i >= 0; --i) {
            AlgaGroup grp = this._groups.get(i);
            AlgaSheet sheet = this._sheets.get(i);
            int idx = sheet.remove(grp);
            this._indexs.add(idx);
            for (AlgaGraph grf : grp.getGraphs()) {
                sheet.add(grf, idx++);
                grf.setSelected(true);
                grf.computeControlPoints();
            }
        }
        this.refreshAll();
    }

    @Override
    public void undo() {
        for (int i = 0; i < this._groups.size(); ++i) {
            AlgaGroup grp = this._groups.get(i);
            AlgaSheet sheet = this._sheets.get(i);
            int idx = this._indexs.get(i);
            for (AlgaGraph grf : grp.getGraphs()) {
                sheet.remove(grf);
                grf.setSelected(false);
            }
            sheet.add(grp, idx);
        }
        this.refreshAll();
    }
}

