/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import java.util.ArrayList;
import java.util.List;

public class OCmdMoveIntoSheet
extends OCCmd {
    int _idxSheet;
    AlgaSheet _currentSheet;
    int _sizeBefore;
    List<AlgaSheetTransform> _sheetsTransfom;

    public OCmdMoveIntoSheet(AltaContentEditPanel c, int idxSheet) {
        super(c.getAppl(), c);
        this._idxSheet = idxSheet;
        this._sheetsTransfom = new ArrayList<AlgaSheetTransform>();
    }

    @Override
    protected boolean prepareDo() {
        List<AlgaSheet> sheets = this.getContent().getSheets();
        this._currentSheet = sheets.get(this._idxSheet);
        this._sizeBefore = this._currentSheet.getGraphs().size();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            if (i == this._idxSheet) continue;
            AlgaSheet sheet = sheets.get(i);
            AlgaSheetTransform transform = null;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected() || graph.isLocked()) continue;
                if (transform == null) {
                    transform = this.createTransform(sheet);
                }
                transform.addGraph(graph);
            }
        }
        return this._sheetsTransfom.size() > 0;
    }

    private AlgaSheetTransform createTransform(AlgaSheet sheet) {
        AlgaSheetTransform result = new AlgaSheetTransform(sheet);
        this._sheetsTransfom.add(result);
        return result;
    }

    @Override
    protected void firstDo() {
        if (this._sheetsTransfom.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    @Override
    public void redo() {
        int size = this._sizeBefore;
        for (int i = this._sheetsTransfom.size() - 1; i >= 0; --i) {
            this._sheetsTransfom.get(i).redo();
            size += this._sheetsTransfom.get(i).getGraphs().size();
        }
        ArrayList<AlgaGraph> result = new ArrayList<AlgaGraph>(size);
        result.addAll(this._currentSheet.getGraphs());
        for (int i = 0; i < this._sheetsTransfom.size(); ++i) {
            result.addAll(this._sheetsTransfom.get(i).getGraphs());
        }
        this._currentSheet.setGraphs(result);
        this.refreshAll();
    }

    @Override
    public void undo() {
        ArrayList<AlgaGraph> result = new ArrayList<AlgaGraph>(this._sizeBefore);
        int i = this._sizeBefore;
        for (AlgaGraph graph : this._currentSheet.getGraphs()) {
            result.add(graph);
            if (i-- > 0) continue;
            break;
        }
        this._currentSheet.setGraphs(result);
        for (i = 0; i < this._sheetsTransfom.size(); ++i) {
            this._sheetsTransfom.get(i).undo();
        }
        this.refreshAll();
    }

    class AlgaSheetTransform {
        AlgaSheet _sheet;
        List<AlgaGraph> _graphs;
        List<Integer> _graphsIndexes;

        public AlgaSheetTransform(AlgaSheet sheet) {
            this._sheet = sheet;
            int nbrGraph = this._sheet.getGraphs().size();
            if (nbrGraph < 16) {
                nbrGraph = 16;
            }
            this._graphs = new ArrayList<AlgaGraph>(nbrGraph);
        }

        public void addGraph(AlgaGraph graph) {
            this._graphs.add(graph);
        }

        public List<AlgaGraph> getGraphs() {
            return this._graphs;
        }

        public void redo() {
            if (this._graphs.isEmpty()) {
                return;
            }
            this._graphsIndexes = new ArrayList<Integer>(this._graphs.size() + 1);
            for (int i = 0; i < this._graphs.size(); ++i) {
                int index = this._sheet.remove(this._graphs.get(i));
                this._graphsIndexes.add(index);
            }
        }

        public void undo() {
            if (this._graphs.isEmpty()) {
                return;
            }
            for (int i = this._graphs.size() - 1; i >= 0; --i) {
                this._sheet.add(this._graphs.get(i), this._graphsIndexes.get(i));
            }
        }
    }
}

