/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OCmdPathBreakStyle
extends OCCmd {
    Pt.Style _style;
    List<AlgaPoints> _graphs;
    List<Pt> _points;
    List<Pt.Style> _styles;

    public OCmdPathBreakStyle(AltaContentEditPanel c, Pt.Style style) {
        super(c.getAppl(), c);
        this._style = style;
        this._graphs = new ArrayList<AlgaPoints>(8);
        this._points = new ArrayList<Pt>(16);
        this._styles = new ArrayList<Pt.Style>(16);
    }

    @Override
    protected boolean prepareDo() {
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected() || graph.isLocked() || !(graph instanceof AlgaPoints)) continue;
                AlgaPoints path = (AlgaPoints)graph;
                boolean addPoint = false;
                Iterator<Pt> iterPt = path.iteratePoint();
                while (iterPt.hasNext()) {
                    Pt pt = iterPt.next();
                    if (!pt.isSelected() || pt.getStyle().equals((Object)this._style)) continue;
                    addPoint = true;
                    this._points.add(pt);
                    this._styles.add(pt.getStyle());
                }
                if (!addPoint) continue;
                this._graphs.add(path);
            }
        }
        return this._points.size() > 0;
    }

    @Override
    protected void firstDo() {
        if (this._graphs.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    @Override
    public void undo() {
        for (int i = this._points.size() - 1; i >= 0; --i) {
            this._points.get(i).setStyle(this._styles.get(i));
        }
        this.refreshAll();
    }

    @Override
    public void redo() {
        for (int i = this._points.size() - 1; i >= 0; --i) {
            this._points.get(i).setStyle(this._style);
        }
        this.refreshAll();
    }
}

