/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.event.Event;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawFormat;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import java.io.IOException;
import java.util.logging.Logger;

public class AltaEvent
extends Event
implements ObjectWithName {
    private static Logger _LOG = Logger.getLogger(AltaEvent.class.getPackage().getName());
    private String _comment = "";
    protected String _name;
    private static final LawFormat ALTA_LAW_FORMAT = new LawFormat.DefaultLawFormat(){

        @Override
        public String format(String id) {
            return id.replace("-", "_");
        }

        @Override
        public String getSeparatorBegin() {
            return "(";
        }

        @Override
        public String getSeparator() {
            return ", ";
        }

        @Override
        public String getSeparatorEnd() {
            return ")";
        }

        @Override
        public boolean format(Law law, DoubleFormat dblFormat, StringBuilder out) {
            double value;
            if (law.getID() == 4 && law.getNbrParam() == 3 && (value = law.getManager().evaluate(law.getParamAt(2))) == 0.0) {
                return this.doFormat(dblFormat, out, law.getModifierLaw(), "Weibull", law.getReadOnlyParameters().subList(0, 2));
            }
            return super.format(law, dblFormat, out);
        }
    };

    public AltaEvent(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public AltaEvent setName(String name) {
        this._name = name;
        return this;
    }

    @Override
    public void setLabel(String comment) {
        this._comment = comment;
    }

    @Override
    public String getLabel() {
        return this._comment;
    }

    public String toString() {
        return this.getName();
    }

    public boolean compareProperties(AltaEvent event) {
        if (!this._comment.equals(event.getLabel())) {
            return false;
        }
        return super.compareProperties(event);
    }

    @Override
    public AltaEvent getCopy() {
        AltaEvent other = new AltaEvent(this._name);
        other.copy(this);
        return other;
    }

    protected void copy(AltaEvent src) {
        super.copy(src);
        this.setLabel(src.getLabel());
    }

    public void toXML(Appendable out, String indent0) throws IOException {
        this.toXMLEvent(out, indent0);
    }

    public void toXMLEvent(Appendable out, String indent0) throws IOException {
        out.append(indent0).append("<").append("alta.event");
        DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), this._name).append("'");
        out.append(">\n");
        this.toXML_Content(out, indent0, this.getLabel(), true);
        out.append(indent0).append("</").append("alta.event").append(">\n");
    }

    public void writeAltaRicaExtern(Appendable out) throws IOException {
        Param inflight_tested;
        Param inspected;
        boolean generate51 = Boolean.getBoolean("cecilia.event.WriteAttributeCecilia51");
        Law distrib = this.getOccurrence();
        DBModelLaw dbModelLaw = this.getModelLaw();
        if (dbModelLaw != null) {
            out.append("  attribute DassaultSpecialBTP( <event ").append(this.getName()).append("> ) = \"");
            if (generate51) {
                out.append(dbModelLaw.getDBFolder().getPathUntilSystem(new StringBuilder()).toString()).append("\";\n");
            } else {
                out.append(dbModelLaw.getDBFolder().getRefPath()).append("\";\n");
            }
            distrib = dbModelLaw.getLaw();
        }
        if (distrib != null) {
            out.append("  law <event ").append(this.getName()).append("> = ");
            if (!ALTA_LAW_FORMAT.format(distrib, DoubleFormat.getJavaInstance(), out)) {
                _LOG.severe("La loi de distribution de l'evenement '" + this._name + "' ne semble pas compatible.");
            }
            out.append(" ;\n");
        }
        if (generate51) {
            inspected = this.getInspected();
            if (inspected != null) {
                out.append("  attribute DassaultSpecialCtrlPeriod( <event ").append(this.getName()).append("> ) = ");
                if (!ALTA_LAW_FORMAT.format(inspected, DoubleFormat.getJavaInstance(), out)) {
                    _LOG.severe("Le parametre d'inspection de l'evenement '" + this._name + "' ne semble pas compatible.");
                }
                out.append(";\n");
            }
            if ((inflight_tested = this.getInflightTested()) != null) {
                out.append("  attribute DassaultSpecialTestBeforeUse( <event ").append(this.getName()).append("> ) = ");
                if (!ALTA_LAW_FORMAT.format(inflight_tested, DoubleFormat.getJavaInstance(), out)) {
                    _LOG.severe("Le parametre d'inspection de l'evenement '" + this._name + "' ne semble pas compatible.");
                }
                out.append(";\n");
            }
        } else {
            inspected = this.getInspected();
            inflight_tested = this.getInflightTested();
            if (inspected != null || inflight_tested != null) {
                out.append("  attribute DassaultSpecialLawModifier( <event ").append(this.getName()).append("> ) = \"");
                if (inspected != null) {
                    out.append("inspected(");
                    if (!ALTA_LAW_FORMAT.format(inspected, DoubleFormat.getJavaInstance(), out)) {
                        _LOG.severe("Le parametre d'inspection de l'evenement '" + this._name + "' ne semble pas compatible.");
                    }
                    out.append(")\";\n");
                } else {
                    out.append("inflight(");
                    if (!ALTA_LAW_FORMAT.format(inflight_tested, DoubleFormat.getJavaInstance(), out)) {
                        _LOG.severe("Le parametre d'inspection de l'evenement '" + this._name + "' ne semble pas compatible.");
                    }
                    out.append(")\";\n");
                }
            }
        }
        if (this._comment.length() > 0) {
            String escapeComment = StringUtilities.escapeCR((String)this._comment);
            out.append("  remark <event ").append(this.getName()).append("> = \"");
            out.append(escapeComment).append("\";\n");
            out.append("  attribute DassaultSpecialRemark( <event ").append(this.getName()).append("> ) = \"");
            out.append(escapeComment).append("\";\n");
        }
        block5: for (DBAttrib.Value attribValue : this.getAttributes()) {
            DBFolder dbFolder = attribValue.getKey().getDBFolder();
            if (generate51 && dbFolder.getDepthUntilSystem() == 3) {
                out.append("  attribute ");
                if (!dbFolder.getParent().getParent().getName().equals("Default")) {
                    out.append(dbFolder.getParent().getParent().getName()).append("0x002f");
                }
                out.append(dbFolder.getParent().getName()).append("0x002f");
                out.append(dbFolder.getName());
            } else {
                out.append("  attribute '").append(dbFolder.getRefPath()).append("'");
            }
            out.append("( <event ").append(this._name).append("> )");
            String value = attribValue.getValue().toString();
            switch (attribValue.getKey().getType()) {
                default: {
                    out.append(";\n");
                    continue block5;
                }
                case ENUM: {
                    if (generate51) {
                        if (DBFactory.verifyDouble(value)) {
                            out.append(" = ").append(value).append(" ;\n");
                            continue block5;
                        }
                        out.append(" = \"").append(value).append("\" ;\n");
                        continue block5;
                    }
                    out.append(" = '").append(value).append("' ;\n");
                    continue block5;
                }
                case NUMBER: {
                    out.append(" = ").append(value).append(";\n");
                    continue block5;
                }
                case STRING: 
            }
            out.append(" = \"").append(value).append("\" ;\n");
        }
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_DESCRIPTION"), this.getLabel()));
        sb.append(super.getAbstract());
        return sb.toString();
    }
}

