/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node;

import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.AltaVar;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaTypeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import java.io.IOException;

public class AltaState
extends AltaVar {
    private String _defaultValue;
    private ViewVariable _simulVar = null;

    public AltaState(String name, AltaType type, String value) {
        super(name, type);
        this._defaultValue = value.isEmpty() ? new String(type.getDefaultValue()) : new String(value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(":").append(this._type.toString());
        sb.append("[=").append(this._defaultValue).append("]");
        return this.getName();
    }

    public void setSimulVar(ViewVariable var) {
        this._simulVar = var;
    }

    public ViewVariable getSimulVar() {
        return this._simulVar;
    }

    public void setDefaultValue(String value) {
        this._defaultValue = new String(value);
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    @Override
    public AltaState getCopy() {
        return new AltaState(this._name, this._type.getCopy(), this._defaultValue);
    }

    public boolean compareType(AltaState state) {
        return state.getType().equals(this._type);
    }

    public boolean compareDefaultValue(AltaState state) {
        return state.getDefaultValue().equals(this._defaultValue);
    }

    public void toXML(Appendable out, String indent0) throws IOException {
        out.append(indent0).append("<").append("alta.state");
        DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), this._name).append("'");
        DBAltaTypeHandlerXml.writeType(this._type, out);
        DBObjectXmlUtility.appendXML(out.append(" ").append("value").append("='"), this._defaultValue).append("'");
        out.append("/>\n");
    }

    @Override
    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean result = super.update(daoFactory, logMng);
        if (result) {
            if (!this._type.valueExist(this._defaultValue)) {
                logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_ERR_STATE_VALUE", this._defaultValue, this.getName()));
                this._defaultValue = this._type.getDefaultValue();
                result = false;
            }
        } else {
            this._defaultValue = this._type.getDefaultValue();
        }
        return true;
    }
}

