/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.gui;

import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.dbobj.mbsa.node.gui.EditorInterface;
import com.dassault.cecilia.dbobj.mbsa.node.gui.HelperLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class EditorHelper {
    private static Logger _LOG = Logger.getLogger(EditorHelper.class.getPackage().getName());
    public static boolean _activateHelp = true;
    private String[] _separator = new String[]{" ", "\t", "\n", "(", ")", "&", "|", ",", "="};
    private JPanel _panel = new JPanel();
    private JTextComponent _editor;
    private EditorInterface _editorInterface;
    private JLabel _title = new JLabel("");
    private JList _list = new JList();
    private HelperWindow _window;

    public EditorHelper(JTextComponent editor, EditorInterface editorInterface) {
        this._editor = editor;
        this._editorInterface = editorInterface;
        this.makePanel();
    }

    private HelperWindow getHelperWindow() {
        if (this._window == null) {
            Window owner = SwingUtilities.getWindowAncestor(this._editor);
            this._window = new HelperWindow(owner);
            this._window.setUndecorated(true);
        }
        return this._window;
    }

    private void makePanel() {
        this._panel.setLayout(new GridBagLayout());
        this._title.setBorder(BorderFactory.createRaisedBevelBorder());
        this._title.setOpaque(true);
        this._title.setBackground(new Color(181, 178, 156));
        this._title.setForeground(Color.black);
        this._title.setFont(new Font(this._title.getFont().getFamily(), 2, this._title.getFont().getSize()));
        this._list.setVisibleRowCount(10);
        this._list.setCellRenderer(new HelperListRenderer());
        this._list.setBackground(new Color(255, 255, 231));
        this._panel.add((Component)this._title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._panel.add((Component)new JScrollPane(this._list), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.defineActions();
    }

    public static void activateHelp(boolean activate) {
        _activateHelp = activate;
    }

    public int searchBegining(String str) {
        int position = -1;
        for (int i = 0; i < this._separator.length; ++i) {
            position = Math.max(position, str.lastIndexOf(this._separator[i]));
        }
        return position;
    }

    public void defineActions() {
        this._editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (EditorHelper.this._editor.isEditable()) {
                    int caretLocation = EditorHelper.this._editor.getCaretPosition();
                    char typedChar = this.isSearchCode(e);
                    if (typedChar != ' ') {
                        int position = EditorHelper.this.searchBegining(EditorHelper.this._editor.getText().substring(0, caretLocation));
                        String lastWord = EditorHelper.this._editor.getText().substring(position + 1, caretLocation);
                        Vector list = new Vector();
                        EditorHelper.this._title.setText("  " + EditorHelper.this._editorInterface.analyseString(lastWord, typedChar, list) + "  ");
                        if (!list.isEmpty()) {
                            if (typedChar == '^' && e.getKeyCode() == 130) {
                                EditorHelper.this._editor.replaceSelection("^");
                            }
                            EditorHelper.this.showHelp(list, caretLocation);
                            e.consume();
                        }
                    } else if (e.getKeyCode() == 32 && e.isControlDown()) {
                        Vector list = new Vector();
                        EditorHelper.this._title.setText("  " + EditorHelper.this._editorInterface.getHelpRoots(list) + "  ");
                        if (!list.isEmpty()) {
                            EditorHelper.this.showHelp(list, caretLocation);
                            e.consume();
                        }
                    }
                }
            }

            private char isSearchCode(KeyEvent e) {
                if (e.getKeyChar() == '.') {
                    return '.';
                }
                if (e.getKeyCode() == 130) {
                    _LOG.finest("Press: VK_DEAD_CIRCUMFLEX");
                    return '^';
                }
                if (e.getKeyCode() == 514) {
                    _LOG.finest("Press: VK_CIRCUMFLEX");
                } else if (e.getKeyCode() == 57 && e.getModifiersEx() == 8192) {
                    _LOG.finest("Press: VK_9 + modifier_10");
                } else if (e.getKeyCode() == 57 && e.isAltGraphDown()) {
                    _LOG.finest("Press: VK_9 + AltGraph");
                } else if (e.getKeyChar() == '^' && e.isAltGraphDown()) {
                    _LOG.finest("Press: '^' + AltGraph");
                }
                return ' ';
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char typedChar = '\u0000';
                if (e.getKeyCode() == 514) {
                    _LOG.finest("Typed: VK_CIRCUMFLEX");
                    typedChar = '^';
                } else if (e.getKeyChar() == '^') {
                    _LOG.finest("Typed: char '^'");
                    typedChar = '^';
                }
                if (typedChar != '\u0000') {
                    int caretLocation = EditorHelper.this._editor.getCaretPosition();
                    this.pressTyped(typedChar, caretLocation);
                }
            }

            private void pressTyped(char typedChar, int caretLocation) {
                int position = EditorHelper.this.searchBegining(EditorHelper.this._editor.getText().substring(0, caretLocation));
                String lastWord = EditorHelper.this._editor.getText().substring(position + 1, caretLocation);
                Vector list = new Vector();
                EditorHelper.this._title.setText("  " + EditorHelper.this._editorInterface.analyseString(lastWord, typedChar, list) + "  ");
                if (!list.isEmpty()) {
                    EditorHelper.this.showHelp(list, caretLocation);
                }
            }
        });
        this._editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (EditorHelper.this.getHelperWindow().isVisible()) {
                    EditorHelper.this.hideWindow();
                }
            }
        });
        this._list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        EditorHelper.this.hideWindow();
                        EditorHelper.this.insertString();
                        EditorHelper.this._editor.requestFocus();
                    }
                }
            }
        });
        this._list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() <= 1) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                EditorHelper.this.hideWindow();
                EditorHelper.this.insertString();
                EditorHelper.this._editor.requestFocus();
            }
        });
        this._list.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "CLOSE");
        this._list.getActionMap().put("CLOSE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHelper.this.hideWindow();
                EditorHelper.this._editor.requestFocus();
            }
        });
    }

    public void showHelp(Vector list, int caretLocation) {
        if (list.size() != 0) {
            this._list.setListData(list);
            try {
                Point editorPoint = this._editor.getLocationOnScreen();
                Rectangle caretSize = this._editor.modelToView(caretLocation);
                Point screenPoint = caretSize.getLocation();
                screenPoint.x += editorPoint.x;
                screenPoint.y += editorPoint.y;
                Dimension defaultScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle currentScreen = new Rectangle(0, 0, defaultScreenSize.width, defaultScreenSize.height);
                GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] devices = gEnv.getScreenDevices();
                if (devices.length > 0) {
                    boolean find = false;
                    for (int i = 0; !find && i < devices.length; ++i) {
                        Rectangle screen = devices[i].getDefaultConfiguration().getBounds();
                        if (!screen.contains(screenPoint)) continue;
                        currentScreen = screen;
                        find = true;
                    }
                }
                HelperWindow helper = this.getHelperWindow();
                Window owner = SwingUtilities.getWindowAncestor(this._editor);
                int x = (int)Math.min(screenPoint.getX() + (double)caretSize.width, currentScreen.getX() + currentScreen.getWidth() - (double)helper.getWidth());
                int y = (int)Math.min(screenPoint.getY() + (double)caretSize.height, Math.min((currentScreen.getY() + currentScreen.getHeight()) * 0.97, (double)(owner.getY() + owner.getHeight())) - (double)helper.getHeight());
                helper.getContentPane().add(this._panel);
                helper.pack();
                helper.setLocation(x, y);
                helper.setVisible(true);
            }
            catch (BadLocationException ex) {
                System.out.println(ex);
            }
            this._list.setSelectedIndex(0);
            this._list.requestFocus();
        }
    }

    public boolean windowIsVisible() {
        return this.getHelperWindow().isVisible();
    }

    public void hideWindow() {
        this.getHelperWindow().getContentPane().removeAll();
        this.getHelperWindow().setVisible(false);
    }

    public void insertString() {
        JLabel value = (JLabel)this._list.getSelectedValue();
        if (value != null) {
            try {
                this._editor.getDocument().insertString(this._editor.getCaretPosition(), value.getText(), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void setEditorInterface(EditorInterface editorInterface) {
        this._editorInterface = editorInterface;
    }

    public class HelperListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            HelperLabel helperLabel = (HelperLabel)value;
            return helperLabel.getPanel(list, isSelected);
        }
    }

    public class HelperWindow
    extends JDialogCecilia {
        public HelperWindow(Window win) {
            super(win);
            this.init();
        }
    }
}

