/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul;

import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.simul.AlgaSimulContext;
import com.dassault.cecilia.dbobj.mbsa.simul.AltaSimulPanel;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.swing.ToolTipManager;

public class AltaSimulView
extends AltaContentView {
    AltaSimulPanel _panel;
    private boolean _ttipChangeActive;
    private int _ttipViewInitialDelay;
    private int _ttipViewDismissDelay;
    private int _ttipViewReshowDelay;
    private int _ttipSaveInitialDelay;
    private int _ttipSaveDismissDelay;
    private int _ttipSaveReshowDelay;
    public static final int PROP_DEF_MBSA_SIMUL_TTIP_INITIAL = 500;
    public static final String PROP_MBSA_SIMUL_TTIP_INITIAL = "cecilia.mbsa.simul.TTipInitialDelay";
    public static final int PROP_DEF_MBSA_SIMUL_TTIP_DISMISS = -1;
    public static final String PROP_MBSA_SIMUL_TTIP_DISMISS = "cecilia.mbsa.simul.TTipDismissDelay";
    public static final int PROP_DEF_MBSA_SIMUL_TTIP_RESHOW = -1;
    public static final String PROP_MBSA_SIMUL_TTIP_RESHOW = "cecilia.mbsa.simul.TTipReshowDelay";
    public static final int PROP_DEF_MBSA_SIMUL_RECORD_FIELD_TTIP = 40;
    public static final String PROP_MBSA_SIMUL_RECORD_FIELD_TTIP = "cecilia.mbsa.simul.MaxFieldForTooltip";

    public AltaSimulView(AlgaContext context, AltaSimulPanel panel) {
        super(context);
        this._panel = panel;
        ToolTipManager tooltipMng = ToolTipManager.sharedInstance();
        this._ttipViewInitialDelay = Integer.getInteger(PROP_MBSA_SIMUL_TTIP_INITIAL, 500);
        if (this._ttipViewInitialDelay < 0) {
            this._ttipViewInitialDelay = tooltipMng.getInitialDelay();
        }
        this._ttipViewDismissDelay = Integer.getInteger(PROP_MBSA_SIMUL_TTIP_DISMISS, -1);
        if (this._ttipViewDismissDelay < 0) {
            this._ttipViewDismissDelay = tooltipMng.getDismissDelay();
        }
        this._ttipViewReshowDelay = Integer.getInteger(PROP_MBSA_SIMUL_TTIP_RESHOW, -1);
        if (this._ttipViewReshowDelay < 0) {
            this._ttipViewReshowDelay = tooltipMng.getReshowDelay();
        }
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = (int)((double)e.getX() / AltaSimulView.this.getZoom());
                int y = (int)((double)e.getY() / AltaSimulView.this.getZoom());
                AltaSimulView.this.defineSimulTootip(x, y);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AltaSimulView.this._panel.displayPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AltaSimulView.this._panel.displayPopup(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!AltaSimulView.this._ttipChangeActive) {
                    ToolTipManager tooltipMng = ToolTipManager.sharedInstance();
                    AltaSimulView.this._ttipSaveInitialDelay = tooltipMng.getInitialDelay();
                    tooltipMng.setInitialDelay(AltaSimulView.this._ttipViewInitialDelay);
                    AltaSimulView.this._ttipSaveReshowDelay = tooltipMng.getReshowDelay();
                    tooltipMng.setReshowDelay(AltaSimulView.this._ttipViewReshowDelay);
                    AltaSimulView.this._ttipSaveDismissDelay = tooltipMng.getDismissDelay();
                    tooltipMng.setDismissDelay(AltaSimulView.this._ttipViewDismissDelay);
                    AltaSimulView.this._ttipChangeActive = true;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (AltaSimulView.this._ttipChangeActive) {
                    ToolTipManager tooltipMng = ToolTipManager.sharedInstance();
                    tooltipMng.setInitialDelay(AltaSimulView.this._ttipSaveInitialDelay);
                    tooltipMng.setReshowDelay(AltaSimulView.this._ttipSaveReshowDelay);
                    tooltipMng.setDismissDelay(AltaSimulView.this._ttipSaveDismissDelay);
                    AltaSimulView.this._ttipChangeActive = false;
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 525 && !e.isAltDown()) {
                    int x = AltaSimulView.this.getWidth() / 2 - 100;
                    int y = AltaSimulView.this.getHeight() / 2 - 200;
                    AltaSimulView.this._panel.displayPopup(new MouseEvent(AltaSimulView.this, 502, new Date().getTime(), e.getModifiersEx(), x, y, 1, true));
                }
            }
        });
    }

    protected void defineSimulTootip(int x, int y) {
        AlgaGraph grf = this.getContent().getGraphAtPoint(x, y, this.getContext().getLinkDisplay());
        StringBuilder sb = new StringBuilder();
        if (grf != null) {
            if (grf instanceof AlgaNode) {
                AlgaNode node = (AlgaNode)grf;
                AltaFlow flow = node.getFlowAt(x, y);
                if (flow != null) {
                    StringBuilder path = new StringBuilder();
                    path.append(node.getLogical().getName()).append(".").append(flow.getName());
                    sb.append("<html><b>");
                    sb.append(this.getContext().getInstance()).append(path.toString());
                    sb.append("</b>");
                    if (flow.isRecord()) {
                        DBRecord type = (DBRecord)flow.getType();
                        this.appendFlowRecordToTooltip(sb, path.toString(), type);
                    } else {
                        this.appendFlowValueToTooltip(sb, path.toString());
                    }
                    sb.append("</html>");
                } else {
                    String path2 = node.getLogical().getName();
                    sb.append("<html><b>");
                    sb.append(this.getContext().getInstance()).append(path2);
                    sb.append("</b>");
                    List<AltaState> states = node.getLogical().getNode().getStates();
                    if (!states.isEmpty()) {
                        sb.append("<br/><ul>");
                        for (int i = 0; i < states.size(); ++i) {
                            AltaState state = states.get(i);
                            sb.append("<li>").append(state.getName()).append(" : ");
                            ViewVariable var = this.getContext().getVariable(path2 + "." + state.getName());
                            if (var != null) {
                                sb.append(var.getSValue());
                            } else {
                                sb.append("???");
                            }
                            sb.append("</li>");
                        }
                        sb.append("</ul>");
                    }
                    sb.append("</html>");
                }
            } else if (grf instanceof AlgaLink) {
                AlgaLink link = (AlgaLink)grf;
                sb.append("<html><b>");
                sb.append(link.getTooltip());
                sb.append("</b>");
                StringBuilder path = new StringBuilder();
                try {
                    link.getLogical().appendTo(path);
                }
                catch (IOException path2) {
                    // empty catch block
                }
                if (link.getLogical().isRecord()) {
                    DBRecord type = (DBRecord)link.getLogical().getToFlow().getType();
                    this.appendFlowRecordToTooltip(sb, path.toString(), type);
                } else {
                    this.appendFlowValueToTooltip(sb, path.toString());
                }
                sb.append("</html>");
            } else if (grf instanceof AlgaPort) {
                AltaFlow flow = ((AlgaPort)grf).getFlow();
                String path = flow.getName();
                sb.append("<html><b>");
                sb.append(this.getContext().getInstance()).append(path);
                sb.append("</b>");
                if (flow.isRecord()) {
                    DBRecord type = (DBRecord)flow.getType();
                    this.appendFlowRecordToTooltip(sb, path, type);
                } else {
                    this.appendFlowValueToTooltip(sb, path);
                }
                sb.append("</html>");
            }
        }
        if (sb.length() > 0) {
            this.setToolTipText(sb.toString());
        } else {
            this.setToolTipText(null);
        }
    }

    private void appendFlowValueToTooltip(StringBuilder sb, String path) {
        sb.append(" : <i>");
        ViewVariable var = this.getContext().getVariable(path);
        if (var != null) {
            sb.append(var.getSValue());
        } else {
            sb.append("???");
        }
        sb.append("</i>");
    }

    private void appendFlowRecordToTooltip(StringBuilder sb, String path, DBRecord dbRecord) {
        int limit = Integer.getInteger(PROP_MBSA_SIMUL_RECORD_FIELD_TTIP, 40);
        if (dbRecord.getValueCount() < limit) {
            sb.append("<br/><ul>");
            for (int i = 0; i < dbRecord.getValueCount(); ++i) {
                DBRecordField field = dbRecord.getFieldAt(i);
                sb.append("<li>").append(field.getName()).append(" : ");
                ViewVariable var = this.getContext().getVariable(path + "^" + field.getName());
                if (var != null) {
                    sb.append(var.getSValue());
                } else {
                    sb.append("???");
                }
                sb.append("</li>");
            }
            sb.append("</ul>");
        } else {
            sb.append("<br/><table border=0 cellspacing=2 cellpadding=1> <tr>");
            int nbrValue = dbRecord.getValueCount();
            int nbrCol = nbrValue / limit + 1;
            int nbrRow = nbrValue / nbrCol + 1;
            int idx = 0;
            for (int col = 0; col < nbrCol; ++col) {
                sb.append("<td><ul>");
                for (int row = 0; row < nbrRow && idx < nbrValue; ++row) {
                    DBRecordField field = dbRecord.getFieldAt(idx++);
                    sb.append("<li>").append(field.getName()).append(" : ");
                    ViewVariable var = this.getContext().getVariable(path + "^" + field.getName());
                    if (var != null) {
                        sb.append(var.getSValue());
                    } else {
                        sb.append("???");
                    }
                    sb.append("</li>");
                }
                sb.append("</ul></td>");
            }
            sb.append("</tr></table>");
        }
    }

    @Override
    public AlgaSimulContext getContext() {
        return (AlgaSimulContext)super.getContext();
    }

    public String getSelectedComponentPath() {
        AlgaGraph graph = this.getContent().getSelectedGraph();
        if (graph == null || !(graph instanceof AlgaNode)) {
            String result = this.getContext().getInstance();
            if (!result.isEmpty() && result.endsWith(".")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
        StringBuilder sb = new StringBuilder().append(this.getContext().getInstance());
        sb.append(((AlgaNode)graph).getLogical().getName());
        return sb.toString();
    }
}

