/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.DlgChangeStepper;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.other.JIntegerTextField;
import com.dassault.cecilia.dbobj.mbsa.simul.ResIcoSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class DebugPreferencies
extends JPanel
implements PluginWithOptions,
PlugPanel {
    private static String CLASSNAME = DebugPreferencies.class.getName();
    public static final String OPT_ALWAYS_INIT = AltaConfig.OPTION_CONFIG_ALWAYS_SELECT;
    public static final String OPT_INSTANT_AUTO = Stepper.OPTION_INSTANTANEOUS_AUTO;
    public static final String OPT_INSTANT_LOOP = Stepper.OPTION_INSTANTANEOUS_LOOP;
    public static final String OPT_CHANGE = CLASSNAME + "#Change.tmp";
    public int _defaultCycleMax = 100;
    private static final String PROP_STEPPER_PREF_DEFAULT = "cecilia.mbsa.stepper.PreferenciesDefault";
    private JTextArea _legend = new JTextArea("");
    private JCheckBox _alwayInitialConfigOption = new JCheckBox(ResMsgSimul.getString("OPT_SIMUL_ALWAY_CHOOSE_CONFIG"), false);
    private JCheckBox _stepByStepOption = new JCheckBox(ResMsgSimul.getString("OPT_SIMUL_FIRE_AUTO_INSTANTANEOUS"));
    private JLabel _cycleMaxLabel = new JLabel(ResMsgSimul.getString("OPT_SIMUL_AUTONBR"));
    private JIntegerTextField _cycleMaxValue = new JIntegerTextField("" + this._defaultCycleMax, 6);
    private JLabel _defaultStepperLblName = new JLabel(ResMsgVoc.getString("VOC_NAME"));
    private JLabel _defaultStepperLblClass = new JLabel(ResMsgSimul.getString("OPT_SYSTEM_STEPPER_CLASSNAME"));
    private JTextField _defaultStepperCtrlName = new JTextField();
    private JTextField _defaultStepperCtrlClass = new JTextField();
    private JButton _defaultStepperBut = new JButton(ResMsgVoc.getString("VOC_CHANGE"));
    CeciliaAppl _appl;
    Plugable _launcher;

    public DebugPreferencies(CeciliaAppl appl) {
        super(new GridBagLayout());
        this.makePanel();
        this.defineActions();
        this._appl = appl;
    }

    public void InitDefaultPlugins() {
        List plugins = this._appl.getPlugable().getPlugins("PluginStepper");
        Object defPlugin = null;
        for (String pluginKey : plugins) {
            String def;
            PluginModel plugin = this._appl.getPlugable().getPlugin(pluginKey);
            if (plugin == null || !(plugin instanceof PluginMStepper) || !"true".equals(def = plugin.getInfo("plugin.default")) && defPlugin != null) continue;
            String name = plugin.getInfo("plugin.name");
            this._defaultStepperCtrlName.setText(name);
            this._defaultStepperCtrlClass.setText(pluginKey);
            if (!"true".equals(def)) continue;
            break;
        }
    }

    private void makePanel() {
        JPanel panelStepper = new JPanel(new GridBagLayout());
        panelStepper.setBorder(new TitledBorder(ResMsgSimul.getString("OPT_SYSTEM_STEPPER_INFO")));
        panelStepper.add((Component)this._defaultStepperLblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelStepper.add((Component)this._defaultStepperCtrlName, new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelStepper.add((Component)this._defaultStepperLblClass, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelStepper.add((Component)this._defaultStepperCtrlClass, new GridBagConstraints(1, 1, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelStepper.add((Component)this._defaultStepperBut, new GridBagConstraints(0, 2, 2, 1, 100.0, 100.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._defaultStepperCtrlName.setEditable(false);
        this._defaultStepperCtrlClass.setEditable(false);
        if (Boolean.getBoolean(PROP_STEPPER_PREF_DEFAULT)) {
            this.add((Component)panelStepper, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        JPanel panelOptions = new JPanel(new GridBagLayout());
        panelOptions.setBorder(new TitledBorder(""));
        this._legend.setText(ResMsgSimul.getString("OPT_PANEL_SIMUL_OPTION"));
        this._legend.setLineWrap(true);
        this._legend.setWrapStyleWord(true);
        this._legend.setEditable(false);
        this._legend.setOpaque(false);
        panelOptions.add((Component)this._legend, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 30, 10), 0, 0));
        panelOptions.add((Component)this._alwayInitialConfigOption, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 2, 10), 0, 0));
        this._stepByStepOption.setSelected(true);
        panelOptions.add((Component)this._stepByStepOption, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 2, 10), 0, 0));
        panelOptions.add((Component)this._cycleMaxLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 30, 2, 2), 0, 0));
        panelOptions.add((Component)this._cycleMaxValue, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 10), 0, 0));
        this._cycleMaxValue.setEnabled(this._stepByStepOption.isSelected());
        JButton defVal = new JButton(ResMsgSimul.getString("DLG_DEFVALUE"));
        defVal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugPreferencies.this._alwayInitialConfigOption.setSelected(false);
                DebugPreferencies.this._stepByStepOption.setSelected(true);
                DebugPreferencies.this._cycleMaxValue.setText("100");
                DebugPreferencies.this._cycleMaxValue.setEnabled(true);
                DebugPreferencies.this.refreshPlugable(DebugPreferencies.this._launcher);
            }
        });
        panelOptions.add((Component)defVal, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 2, 10), 0, 0));
        this.add((Component)panelOptions, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void defineActions() {
        this._stepByStepOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugPreferencies.this._cycleMaxValue.setEnabled(DebugPreferencies.this._stepByStepOption.isSelected());
                DebugPreferencies.this._launcher.setOption(OPT_INSTANT_AUTO, Boolean.toString(DebugPreferencies.this._stepByStepOption.isSelected()));
                DebugPreferencies.this._launcher.setOption(OPT_CHANGE, "true");
            }
        });
        this._cycleMaxValue.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                DebugPreferencies.this._launcher.setOption(OPT_INSTANT_AUTO, Boolean.toString(DebugPreferencies.this._stepByStepOption.isSelected()));
                DebugPreferencies.this._launcher.setOption(OPT_CHANGE, "true");
            }
        });
        this._alwayInitialConfigOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugPreferencies.this._launcher.setOption(OPT_ALWAYS_INIT, Boolean.toString(DebugPreferencies.this._alwayInitialConfigOption.isSelected()));
            }
        });
        this._defaultStepperBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window win = SwingUtilities.getWindowAncestor(DebugPreferencies.this._defaultStepperBut);
                DlgChangeStepper dlg = new DlgChangeStepper(win);
                dlg.refreshList(DebugPreferencies.this._appl.getPlugable(), "PluginStepper", null, DebugPreferencies.this.getCurrentStepperKey(), null);
                dlg.setVisible(true);
                if (dlg.getResult()) {
                    String stepperKey = dlg.getSelKey();
                    PluginModel plugin = DebugPreferencies.this._appl.getPlugable().getPlugin(stepperKey);
                    if (plugin != null) {
                        DebugPreferencies.this._defaultStepperCtrlName.setText(plugin.getInfo("plugin.name"));
                        DebugPreferencies.this._defaultStepperCtrlClass.setText(stepperKey);
                    }
                }
            }
        });
    }

    public void setCurrentStepperKey(String key) {
        PluginModel plugin = this._appl.getPlugable().getPlugin(key);
        if (plugin != null) {
            this._defaultStepperCtrlClass.setText(key);
            this._defaultStepperCtrlName.setText(plugin.getInfo("plugin.name"));
        }
    }

    public String getCurrentStepperKey() {
        return this._defaultStepperCtrlClass.getText();
    }

    @Override
    public String getInfo(String key) {
        if ("plugin.key".equals(key)) {
            return CLASSNAME;
        }
        if ("plugin.key.path".equals(key)) {
            return "MBSA";
        }
        if ("plugin.name".equals(key)) {
            return ResMsgVoc.getString("VOC_STEPPER");
        }
        if ("plugin.title".equals(key)) {
            return ResMsgSimul.getString("OPT_SIMUL_TITLE");
        }
        if ("plugin.description".equals(key)) {
            return ResMsgSimul.getString("OPT_PANEL_SIMUL_OPTION");
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        return ResIcoSimul.getImageIcon("SIMULATION");
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public void trash() {
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        this.prepareWith(launcher);
        this.refreshPlugable(launcher);
        return this;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        this.prepareWith(launcher);
    }

    @Override
    public boolean validOptions(Plugable launcher) {
        this.refreshPlugable(launcher);
        return true;
    }

    private void prepareWith(Plugable launcher) {
        this._launcher = launcher;
        boolean bAlwayInit = PlugableUtility.getBoolOpt(launcher, OPT_ALWAYS_INIT, false);
        this._alwayInitialConfigOption.setSelected(bAlwayInit);
        boolean bInstantAuto = PlugableUtility.getBoolOpt(launcher, OPT_INSTANT_AUTO, true);
        this._stepByStepOption.setSelected(bInstantAuto);
        int iInstantLoop = PlugableUtility.getIntOpt(launcher, OPT_INSTANT_LOOP, 100);
        if (iInstantLoop <= 0) {
            iInstantLoop = 100;
        }
        this._cycleMaxValue.setText(Integer.toString(iInstantLoop));
        this._cycleMaxValue.setEnabled(this._stepByStepOption.isSelected());
    }

    private void refreshPlugable(Plugable launcher) {
        this._launcher.setOption(OPT_INSTANT_AUTO, Boolean.toString(this._stepByStepOption.isSelected()));
        this._launcher.setOption(OPT_INSTANT_LOOP, this._cycleMaxValue.getText());
        this._launcher.setOption(OPT_ALWAYS_INIT, Boolean.toString(this._alwayInitialConfigOption.isSelected()));
        this._launcher.setOption(OPT_CHANGE, "true");
    }
}

