/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul;

import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.simul.CentralizedStepper;
import com.dassault.cecilia.dbobj.mbsa.simul.ResIcoSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.SimulationAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class SimulationActionStartWithChoice
extends SimulationAction {
    CentralizedStepper _centralized;
    private JPopupMenu _popupMenu = new JPopupMenu();
    private AbstractButton _associatedButton = null;

    SimulationActionStartWithChoice(CentralizedStepper owner) {
        super("");
        this._centralized = owner;
        this.setIcon(ResIcoSimul.getImageIcon("SELECT_CHOICE"));
    }

    public void setAssociatedButton(AbstractButton associatedButton) {
        this._associatedButton = associatedButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._popupMenu.removeAll();
        List plugins = this._centralized.getPlugable().getPlugins("PluginStepper");
        if (plugins.size() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._centralized.getPlugable().getWindow()), ResMsgSimul.getString("ERR_NO_STEPPER"), ResMsgSimul.getString("MSG_TITLE"), 0);
            return;
        }
        PluginMStepper currentStepper = this._centralized.getPluginStepper();
        for (String keyStepper : plugins) {
            final PluginMStepper iterStepper = (PluginMStepper)this._centralized.getPlugable().getPlugin(keyStepper);
            String name = iterStepper.getInfo("plugin.name");
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(name);
            Icon icon = iterStepper.getIcon("plugin.default");
            if (icon != null) {
                item.setIcon(icon);
            }
            item.setSelected(currentStepper == iterStepper);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SimulationActionStartWithChoice.this._centralized.setPluginStepper(iterStepper);
                    SimulationActionStartWithChoice.this._centralized.startSimulation();
                }
            });
            this._popupMenu.add((Component)item, 0);
        }
        this._popupMenu.show(this._associatedButton, 0, this._associatedButton.getHeight());
    }

    @Override
    public void altaModelChanged(ViewStepper acastep) {
        this.setEnabled(this._centralized.getSimStepper() == null && this._centralized.getModel() != null);
    }

    @Override
    public AbstractButton createButton(CeciliaAction.BorderStyle borderStyle) {
        JButton but = new JButton(this);
        but.setMargin(new Insets(1, 1, 0, 1));
        but.setPreferredSize(new Dimension(15, 17));
        but.setFocusPainted(false);
        but.setEnabled(false);
        return but;
    }
}

